package org.gcube.application.framework.search.library.cache;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

import org.gcube.application.framework.search.library.model.CollectionInfo;
import org.gcube.application.framework.search.library.util.FindFieldsInfo;

public class CollectionsFieldsCache {
	
	protected static Thread thread = new CleanCacheThread();
	
	protected static CollectionsFieldsCache collectionsFieldsCache = new CollectionsFieldsCache();
	protected HashMap<String, HashMap<CollectionInfo, ArrayList<CollectionInfo>>> scopesInfosCache;
	
	
	protected CollectionsFieldsCache() {
		scopesInfosCache = new HashMap<String, HashMap<CollectionInfo, ArrayList<CollectionInfo>>>();
		thread.setDaemon(true);
		thread.start();
	}
	
	
	public static CollectionsFieldsCache getInstance() {
		return collectionsFieldsCache;
	}
	
	public HashMap<CollectionInfo, ArrayList<CollectionInfo>> getCollectionsInfoForScope(String scope, boolean refresh) {
		HashMap<CollectionInfo, ArrayList<CollectionInfo>> info = scopesInfosCache.get(scope);
		if (info == null || info.size() == 0) {
			info = FindFieldsInfo.joinDynamicAndStaticConfiguration(scope, refresh);
			scopesInfosCache.put(scope, info);
		}
		
		return info;
	}
	
	public HashMap<CollectionInfo, ArrayList<CollectionInfo>> refreshCollectionInfoForScope(String scope, boolean refresh) {
		HashMap<CollectionInfo, ArrayList<CollectionInfo>> info = FindFieldsInfo.joinDynamicAndStaticConfiguration(scope, refresh);
		synchronized (this){
			collectionsFieldsCache.scopesInfosCache.put(scope, info);
		}
		
		return info;
	}
	
	
	
	@Override
	protected void finalize() throws Throwable {
		thread.interrupt();
		System.out.println(new Date(System.currentTimeMillis()) + " clean thread was interrupted");
		thread.join();
		System.out.println(new Date(System.currentTimeMillis()) + " clean thread was joint");
		super.finalize();
	}
	
	
	protected static class CleanCacheThread extends Thread
	{
		public void run()
		{
			while(true)
			{
				try {
					Thread.sleep(3600000);	// 60 minutes
				} catch (InterruptedException e) {
					e.printStackTrace();
					System.out.println(new Date(System.currentTimeMillis()) + " clean thread was interrupted (in clean thread)");
					break;
				}
				//TODO: Refresh cache 
				Set<String> keys = collectionsFieldsCache.scopesInfosCache.keySet();
				HashMap<String, HashMap<CollectionInfo, ArrayList<CollectionInfo>>> tempMap = new HashMap<String, HashMap<CollectionInfo, ArrayList<CollectionInfo>>>();
				for (String scope:keys) {
					HashMap<CollectionInfo, ArrayList<CollectionInfo>> info = FindFieldsInfo.joinDynamicAndStaticConfiguration(scope, false);
					tempMap.put(scope, info);
				}
				
				synchronized (this){
					collectionsFieldsCache.scopesInfosCache = tempMap;
				}
			}
			System.out.println(new Date(System.currentTimeMillis()) + " clean thread was terminated");
		}

	}

}
