package org.gcube.application.framework.search.library.model;

import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.element.query.QueryHelper;

import java.net.URISyntaxException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map.Entry;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

import javax.xml.rpc.ServiceException;

import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.EndpointReference;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.types.URI.MalformedURIException;
import org.gcube.application.framework.accesslogger.library.impl.AccessLogger;
import org.gcube.application.framework.accesslogger.model.AdvancedSearchAccessLogEntry;
import org.gcube.application.framework.accesslogger.model.BrowseAccessLogEntry;
import org.gcube.application.framework.accesslogger.model.QuickSearchAccessLogEntry;
import org.gcube.application.framework.accesslogger.model.SimpleSearchAccessLogEntry;
import org.gcube.application.framework.core.cache.RIsManager;
import org.gcube.application.framework.core.security.ServiceContextManager;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.search.library.exception.InitialBridgingNotCompleteException;
import org.gcube.application.framework.search.library.exception.InternalErrorException;
import org.gcube.application.framework.search.library.exception.NoSearchMasterEPRFoundException;
import org.gcube.application.framework.search.library.exception.QuerySubmissionSearchException;
import org.gcube.application.framework.search.library.exception.QuerySyntaxException;
import org.gcube.application.framework.search.library.exception.ReadingUserProfileException;
import org.gcube.application.framework.search.library.exception.SearchSystemPortRetrievalException;
import org.gcube.application.framework.search.library.exception.URIRetrievalFromISCacheException;
import org.gcube.application.framework.search.library.exception.gRS2CreationException;
import org.gcube.application.framework.search.library.impl.ResultSetConsumer;
import org.gcube.application.framework.search.library.impl.SearchHelper;
import org.gcube.application.framework.search.library.interfaces.ResultSetConsumerI;
import org.gcube.application.framework.search.library.util.ArraysComparison;
import org.gcube.application.framework.search.library.util.FindFieldsInfo;
import org.gcube.application.framework.search.library.util.Modifiers;
import org.gcube.application.framework.search.library.util.Operator;
import org.gcube.application.framework.search.library.util.Order;
import org.gcube.application.framework.search.library.util.Point;
import org.gcube.application.framework.search.library.util.SearchConstants;
import org.gcube.application.framework.search.library.util.SearchType;
import org.gcube.application.framework.search.library.util.SessionConstants;
import org.gcube.application.framework.userprofiles.library.impl.UserProfile;
import org.gcube.common.core.faults.GCUBERetryEquivalentFault;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.informationsystem.cache.SrvType;
import org.gcube.searchsystem.searchsystemservice.stubs.SearchResponse;
import org.gcube.searchsystem.searchsystemservice.stubs.SearchSystemServicePortType;
import org.gcube.searchsystem.searchsystemservice.stubs.service.SearchMasterServiceAddressingLocator;

import search.library.util.cql.query.tree.GCQLAndNode;
import search.library.util.cql.query.tree.GCQLNode;
import search.library.util.cql.query.tree.GCQLOrNode;
import search.library.util.cql.query.tree.GCQLProjectNode;
import search.library.util.cql.query.tree.GCQLQueryTreeManager;
import search.library.util.cql.query.tree.GCQLRelation;
import search.library.util.cql.query.tree.GCQLSortNode;
import search.library.util.cql.query.tree.GCQLTermNode;
import search.library.util.cql.query.tree.Modifier;
import search.library.util.cql.query.tree.ModifierSet;

/**
 * 
 * @author Rena - NKUA
 * 
 */

public class Query implements Cloneable {

	// ACCESS LOGGER
	private AccessLogger accessLogger = AccessLogger.getAccessLogger();

	// the browsable fields
	protected List<Field> browsableFields;

	// the criteria set by the user
	protected List<Criterion> criteria;

	// the previous criteria set by the user
	protected List<Criterion> previousCriteria;

	// whether the user wants distinct values from browsing
	protected boolean distinct;

	// the geospatial information set by the user
	protected GeospatialInfo geospatialInfo;

	// AND/OR operator for conditions
	protected Operator operator;

	// Ascending or Descending order per collection
	protected Order order;

	protected String queryDescription;

	protected List<String> languages;

	protected List<Field> searchableFields;

	protected String searchType; // Used for Google Search distinction

	protected List<String> selectedCollections;

	// protected ArrayList<String> sortBy = new ArrayList<String>();
	private String sortBy;

	protected ResultSetConsumerI searchRSC;

	// the query as a string
	protected String queryString;

	protected String genericSearchType;

	/** Object logger. **/
	protected final GCUBELog logger = new GCUBELog(this);

	protected boolean setRelation; // used for Geospatial Search

	protected String relation; // probably needed

	ArrayList<String> relationModifiers; // probably needed

	ArrayList<String> indexModifiers; // needed?

	int selectedLanguage;

	//flag to define the semantic enrichment
	private boolean semanticEnrichment;
	
	protected String browseBy;

	private String searchTerm = new String();

	private boolean ftsAvailable;

	List<Field> sortableFields;

	private GCQLNode previousQuery = null;

	private String previousQueryDescription = new String();

	protected static AtomicInteger SMid = new AtomicInteger();

	private String searchEPR;

	private String ftsId = new String();

	Field geoField;

	boolean hasResults = true;

	ArrayList<String> selectedPresentationFields;

	ArrayList<String> searchQueryTerms;

	/* Flag to indicate if the data fusion is supported. */
	private boolean rankingSupport = false;

	public void setRanking(boolean rankSupport) {
		this.rankingSupport = rankSupport;
	}

	public void setHasResults(boolean existResults) {
		hasResults = existResults;
	}

	public boolean hasResults() {
		return hasResults;
	}

	public boolean isFtsAvailable() {
		logger.debug("Supports fts? -> " + ftsAvailable);
		return ftsAvailable;
	}

	public void setFtsAvailable(boolean ftsAvailable) {
		this.ftsAvailable = ftsAvailable;
	}

	public void setSemanticEnrichment(boolean semanticEnrichment){
		this.semanticEnrichment = semanticEnrichment;
	}
	
	public boolean getSemanticEnrichment(){
		return this.semanticEnrichment;
	}
	
	public boolean isGeoAvailable() {
		return geoAvailable;
	}

	public void setGeoAvailable(boolean geoAvailable) {
		this.geoAvailable = geoAvailable;
	}

	private boolean geoAvailable;

	public String getSearchTerm() {
		return searchTerm;
	}

	public void setSearchTerm(String searchTerm) {
		// Check if there is a wildcard
		// if (searchTerm.contains("*")) {
		// if (!searchTerm.startsWith("\"") || !searchTerm.endsWith("\"")) {
		// String newSearchTerm = "\"" + searchTerm + "\"";
		// searchTerm = newSearchTerm;
		// }
		// }
		this.searchTerm = searchTerm;
		this.searchQueryTerms.clear();
	}

	public Query() {
		super();
		criteria = new ArrayList<Criterion>();
		previousCriteria = new ArrayList<Criterion>();
		operator = Operator.OR;
		selectedCollections = new ArrayList<String>();
		searchableFields = new ArrayList<Field>();
		browsableFields = new ArrayList<Field>();
		languages = new ArrayList<String>();
		order = Order.ASC;
		distinct = false;
		searchRSC = null;
		searchType = SearchType.NoSearch;
		genericSearchType = SearchType.NoSearch;
		sortableFields = new ArrayList<Field>();
		sortBy = new String();
		browseBy = new String();
		selectedPresentationFields = new ArrayList<String>();
		searchQueryTerms = new ArrayList<String>();
		semanticEnrichment = false;
	}

	/**
	 * Adds a new criterion to the list of search criteria
	 * 
	 * @param criterion
	 *            the criterion to be added
	 * 
	 */
	public void addCriterion(Criterion criterion) {
		logger.debug("adding criterion id: " + criterion.getSearchFieldId() + " and value: " + criterion.getSearchFieldValue());
		// Check for wild card!
		// if (criterion.getSearchFieldValue().contains("*")) {
		// if (!criterion.getSearchFieldValue().startsWith("\"") ||
		// !criterion.getSearchFieldValue().endsWith("\"")) {
		// logger.debug("changing value");
		// String newValue = "\"" + criterion.getSearchFieldValue() + "\"";
		// criterion.setSearchFieldValue(newValue);
		// }
		// }
		if (criterion.getSearchFieldValue().contains(" ")
				&& (!criterion.getSearchFieldValue().startsWith("\"") || !criterion.getSearchFieldValue().endsWith("\""))) {
			String[] splitted = criterion.getSearchFieldValue().split(" ");
			for (int i = 0; i < splitted.length; i++) {
				Criterion crit = new Criterion();
				crit.setSearchFieldId(criterion.getSearchFieldId());
				crit.setSearchFieldName(criterion.getSearchFieldName());
				crit.setSearchFieldValue(splitted[i]);

				criteria.add(crit);
				logger.debug("Criterion added: " + crit.getSearchFieldValue());

			}
			return;
		}
		logger.debug("Criterion added: " + criterion.getSearchFieldValue());
		criteria.add(criterion);
	}

	/**
	 * Removes the i-th search criterion
	 * 
	 * @param i
	 *            the position in the list where the desired search criterion
	 *            rests
	 */
	public void removeCriterion(int i) {
		criteria.remove(i);
	}

	/**
	 * 
	 * @param previous
	 *            whether it should be cloned for previous or not
	 * 
	 * @return cloned query object
	 */
	public Query clone(boolean previous) {
		Query q = new Query();
		logger.debug("cloning - previous: " + previous);
		if (!previous) {
			for (Criterion x : this.criteria) {
				q.criteria.add(x.clone());
			}

			for (String s : this.searchQueryTerms) {
				q.searchQueryTerms.add(new String(s));
			}

			for (String x : this.selectedCollections) {
				String y = new String(x);
				q.selectedCollections.add(y);
			}

			for (Field x : this.searchableFields) {
				q.searchableFields.add(x.clone());
			}

			for (Field x : this.sortableFields) {
				q.sortableFields.add(x.clone());
			}

			for (Field x : this.browsableFields) {
				q.browsableFields.add(x.clone());
			}

			for (String x : this.selectedPresentationFields) {
				String y = new String(x);
				q.selectedPresentationFields.add(y);
			}

			q.searchType = SearchType.NoSearch;
			q.genericSearchType = SearchType.NoSearch;

			if (ftsAvailable)
				q.ftsAvailable = true;
			else
				q.ftsAvailable = false;
			if (geoAvailable)
				q.geoAvailable = true;
			else
				q.geoAvailable = false;

			for (int i = 0; i < languages.size(); i++) {
				q.languages.add(new String(this.languages.get(i)));
			}
			q.selectedLanguage = this.selectedLanguage;
			previousQuery = null;
			previousQueryDescription = new String();
			q.ftsId = this.ftsId;

			q.rankingSupport = this.rankingSupport;
			
			if (this.geoField != null)
				q.geoField = this.geoField.clone();
		} else {

			logger.debug("do i have criteria? : " + criteria.size() + " " + previousCriteria.size());
			for (Criterion x : this.criteria) {
				logger.debug(x.getSearchFieldName() + " " + x.getSearchFieldValue());
				if (!x.getSearchFieldValue().equals(""))
					q.previousCriteria.add(x.clone());
			}

			for (String x : this.selectedCollections) {
				String y = new String(x);
				q.selectedCollections.add(y);
			}

			for (String x : this.selectedPresentationFields) {
				String y = new String(x);
				q.selectedPresentationFields.add(y);
			}

			q.searchType = SearchType.PreviousSearch;
			q.genericSearchType = searchType;

			if (searchType.equals(SearchType.SimpleSearch)) {
				Criterion newCrit = new Criterion();
				newCrit.setSearchFieldId(ftsId);
				newCrit.setSearchFieldName("Any");
				newCrit.setSearchFieldValue(searchTerm);
				q.previousCriteria.add(newCrit);
			}
			for (Field x : this.searchableFields) {
				q.searchableFields.add(x.clone());
			}

			for (Field x : this.sortableFields) {
				q.sortableFields.add(x.clone());
			}

			for (Field x : this.browsableFields) {
				q.browsableFields.add(x.clone());
			}

			if (ftsAvailable)
				q.ftsAvailable = true;
			else
				q.ftsAvailable = false;

			for (int i = 0; i < languages.size(); i++) {
				q.languages.add(new String(this.languages.get(i)));
			}
			q.selectedLanguage = this.selectedLanguage;
			// TODO: Correct?
			q.previousQuery = this.previousQuery;
			q.previousQueryDescription = new String(this.previousQueryDescription);

			q.ftsId = this.ftsId;
			if (this.geoField != null)
				q.geoField = this.geoField.clone();
		}

		q.distinct = this.distinct;
		if (this.geospatialInfo != null && this.geospatialInfo.getBounds() != null) {
			q.geospatialInfo = this.geospatialInfo.clone();
		}

		q.operator = this.operator;
		q.order = this.order;
		q.queryDescription = this.queryDescription;
		q.queryString = this.queryString;
		q.sortBy = new String(this.sortBy);
		q.browseBy = new String(this.browseBy);

		if (this.searchTerm != null)
			q.searchTerm = new String(this.searchTerm);

		return q;
	}

	/**
	 * Sets the selected language
	 * 
	 * @param language
	 */
	public void setLanguage(int language) {
		selectedLanguage = language;
	}

	public void setPresentationFields(ArrayList<String> presentationFields) {
		selectedPresentationFields = presentationFields;
	}

	private void findAvailableLanguages(ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {
		SearchHelper sh = new SearchHelper(session);
		CollectionInfo firstCol = null;
		List<String> selectedRealCollections = getSelectedRealCollections(session);
		if (selectedRealCollections != null && selectedRealCollections.size() != 0) {
			ArrayList<String> allLanguages = new ArrayList<String>();

			/* Find common languages supported by the collections */

			// Get the languages of the first collection
			logger.debug("Finding Available Languages");
			logger.debug("The number of selected collections is: " + selectedCollections.size());

			List<String> realCollections = getSelectedRealCollections(session);
			firstCol = sh.findCollectionInfo(realCollections.get(0));
			allLanguages.addAll(firstCol.getLanguages());
			logger.debug("initially languages are: " + allLanguages.size());
			logger.debug("Real selected Collections: " + realCollections.size());
			CollectionInfo col = null;
			// Remove the languages that are not in common with the other
			// selected collections
			for (int i = 1; i < realCollections.size(); i++) {

				col = sh.findCollectionInfo(realCollections.get(i));
				// get the languages for this collection
				ArrayList<String> colLanguages = col.getLanguages();
				for (int j = 0; j < firstCol.getLanguages().size(); j++) {
					if (!colLanguages.contains(firstCol.getLanguages().get(j))) {
					
						int ind = allLanguages.indexOf(firstCol.getLanguages().get(j));
						
						//TODO
						if(ind >= 0)
							allLanguages.remove(ind);
						else
							logger.debug("Element: " + firstCol.getLanguages().get(j) + "wasn't found in allLanguages collection!");
					}
				}

			}

			languages.clear();
			languages = allLanguages;
		} else
			languages.clear();

		logger.debug("Number of languages: " + languages.size());
	}

	private void findAvailableSearchFields(ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {
		/*
		 * Find the available Search Fields based on the selected collections
		 * and the selected language.
		 */

		logger.debug("Find available search fields");
		if (selectedCollections.size() == 0 || selectedLanguage == -1 || languages.size() == 0) {
			searchableFields = new ArrayList<Field>();
			browsableFields = new ArrayList<Field>();
			logger.debug("No selected collections or no languages - returning");
			return;
		}

		SearchHelper sh = new SearchHelper(session);
		HashMap<CollectionInfo, ArrayList<CollectionInfo>> collections = sh.getAvailableCollections();

		// find the common fields for those collections
		ArrayList<Field> searchableFields = new ArrayList<Field>();
		List<String> realCollections = getSelectedRealCollections(session);
		logger.debug("Number of selected real collections: " + realCollections.size());
		CollectionInfo firstCol = sh.findCollectionInfo(realCollections.get(0));
		logger.debug("Found collection - printing info: ");
		logger.debug(firstCol.getName());
		searchableFields.addAll(firstCol.getIndices());
		logger.debug("For collection: " + firstCol.getId() + " adding indices: " + searchableFields.size());
		// ArrayList<Field> clone = searchableFields;
		ArrayList<Field> clone = new ArrayList<Field>();
		for (int i = 0; i < searchableFields.size(); i++) {
			clone.add(searchableFields.get(i).clone());
		}
		logger.debug("clone has: " + clone.size());
		for (int i = 1; i < realCollections.size(); i++) {
			for (int j = 0; j < searchableFields.size(); j++) {
				logger.debug("Checking or field: " + searchableFields.get(j).getLabel() + " inside collection: " + realCollections.get(i));
				CollectionInfo colInfo = sh.findCollectionInfo(realCollections.get(i));
				boolean found = false;
				for (int k = 0; k < colInfo.getIndices().size(); k++) {
					logger.debug("Comparing fields: " + colInfo.getIndices().get(k).getId() + " " + colInfo.getIndices().get(k).getLabel() + " with "
							+ searchableFields.get(j).getId() + " " + searchableFields.get(j).getLabel());
					if (colInfo.getIndices().get(k).getId().equals(searchableFields.get(j).getId())) {
						found = true;
						logger.debug("FOUND!");
						break;
					}
				}
				if (!found) {
					for (int k = 0; k < clone.size(); k++) {
						if (clone.get(k).getId().equals(searchableFields.get(j).getId())) {
							logger.debug("REMOVING");
							clone.remove(k);
							break;
						}
					}
				}
			}
		}
		logger.debug("clone has now: " + clone.size());
		searchableFields.clear();

		// find the common fields for that language
		for (int i = 0; i < clone.size(); i++) {
			ArrayList<String> langs = clone.get(i).getLanguages();
			logger.debug("The number of field languages is: " + langs.size());
			logger.debug("Number of languages: " + languages.size());
			logger.debug("Selected language: " + selectedLanguage);
			if (!langs.contains(languages.get(selectedLanguage))) {
				logger.debug("Adding Field");
				searchableFields.add(clone.get(i));
			} else
				logger.debug("Not adding field");
		}

		// searchableFields = clone;
		this.searchableFields = searchableFields;
		// browsableFields.clear();
		// for (int i = 0; i < searchableFields.size(); i++) {
		// if (!searchableFields.get(i).getName().equals("Any"))
		// this.browsableFields.add(searchableFields.get(i));
		// }
		logger.debug("Finally the number is: " + searchableFields.size());
	}

	private void findAvailableBrowseFields(ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {
		/*
		 * Find the available Search Fields based on the selected collections
		 * and the selected language.
		 */

		logger.debug("Find available browse fields");
		if (selectedCollections.size() == 0 || selectedLanguage == -1) {
			searchableFields = new ArrayList<Field>();
			browsableFields = new ArrayList<Field>();
			return;
		}

		SearchHelper sh = new SearchHelper(session);
	//	HashMap<CollectionInfo, ArrayList<CollectionInfo>> collections = sh.getAvailableCollections();

		// find the common fields for those collections
		ArrayList<Field> browsableFields = new ArrayList<Field>();
		List<String> realCollections = getSelectedRealCollections(session);
		logger.debug("Number of selected real collections: " + realCollections.size());
		CollectionInfo firstCol = sh.findCollectionInfo(realCollections.get(0));
		browsableFields.addAll(firstCol.getBrowsableFields());
		logger.debug("For collection: " + firstCol.getId() + " adding browse fields: " + browsableFields.size());
		// ArrayList<Field> clone = searchableFields;
		ArrayList<Field> clone = new ArrayList<Field>();
		for (int i = 0; i < browsableFields.size(); i++) {
			clone.add(browsableFields.get(i).clone());
		}
		logger.debug("clone has: " + clone.size());
		for (int i = 1; i < realCollections.size(); i++) {
			for (int j = 0; j < browsableFields.size(); j++) {
				logger.debug("Checking or field: " + browsableFields.get(j).getLabel() + " inside collection: " + realCollections.get(i));
				CollectionInfo colInfo = sh.findCollectionInfo(realCollections.get(i));
				boolean found = false;
				for (int k = 0; k < colInfo.getBrowsableFields().size(); k++) {
					logger.debug("Comparing fields: " + colInfo.getBrowsableFields().get(k).getId() + " " + colInfo.getBrowsableFields().get(k).getLabel()
							+ " with " + browsableFields.get(j).getId() + " " + browsableFields.get(j).getLabel());
					if (colInfo.getBrowsableFields().get(k).getId().equals(browsableFields.get(j).getId())) {
						found = true;
						logger.debug("FOUND!");
						break;
					}
				}
				if (!found) {
					for (int k = 0; k < clone.size(); k++) {
						if (clone.get(k).getId().equals(browsableFields.get(j).getId())) {
							logger.debug("REMOVING");
							clone.remove(k);
							break;
						}
					}
				}
			}
		}
		logger.debug("clone has now: " + clone.size());
		browsableFields.clear();

		browsableFields = clone;

		this.browsableFields = browsableFields;
		// browsableFields.clear();

		logger.debug("Finally the number is: " + this.browsableFields.size());
	}

	// Gathers the sortable fields: the fields that are sortable - searchable
	// and presentable
	private void findAvailableSortFields(ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {
		if (selectedCollections == null || selectedCollections.size() == 0) {
			searchableFields = new ArrayList<Field>();
			return;
		}
		
		session.removeAttribute(SessionConstants.SESSION_SNIPPET_ATTR);
		session.removeAttribute(SessionConstants.SESSION_TITLE_ATTR);
		session.removeAttribute(SessionConstants.sessionDetailedResult);
		
		List<String> presentables;
		try {
			presentables = findPresentableFields(session);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			logger.error("******************************************************findpresentableFields method thrown an exception. Going to get all presentables", e);
			try {
				presentables = findAllPresentableFields(session);
				
				for (Field x : searchableFields) {
					if (x.isSortable) {
						// Check if it is presentable also
						if (presentables.contains(x.id))
							sortableFields.add(x);
					}
				}
			} catch (ResourceRegistryException e1) {
				logger.error("Resource registry exception", e1);
			}
		}
	}

	public List<String> getSelectedRealCollections(ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {
		logger.debug("Inside get selected real collections.");
		List<String> cols = new ArrayList<String>();
		SearchHelper sh = new SearchHelper(session);
		HashMap<CollectionInfo, ArrayList<CollectionInfo>> allCollections = sh.getAvailableCollections();
		Set<CollectionInfo> groups = allCollections.keySet();
		logger.debug("number of selected collections: " + selectedCollections.size());
		for (String a : selectedCollections) {
			CollectionInfo colInfo = sh.findCollectionInfo(a);
			logger.debug("Collection: " + a);
			if (a.equals("all_collections") || selectedCollections.contains("all_collections")) {
				logger.debug("all_collections");
				for (CollectionInfo group : groups) {
					logger.debug("Iterrating group!: " + group.getName());
					for (int i = 0; i < allCollections.get(group).size(); i++) {
						cols.add(allCollections.get(group).get(i).getId());
					}
				}
				logger.debug("number of returned collections: " + cols.size());
				return cols;
			} else if (colInfo.isCollectionGroup) {
				logger.debug("collection group");
				for (CollectionInfo group : groups) {
					if (group.getId().equals(colInfo.getId())) {
						// add all the collections of the group
						ArrayList<CollectionInfo> realCols = allCollections.get(group);
						for (int i = 0; i < realCols.size(); i++) {
							cols.add(realCols.get(i).getId());
						}
					}
				}
			} else {
				logger.debug("real collection");
				for (CollectionInfo group : groups) {
					// if (allCollections.get(group).contains(a))
					// cols.add(a);
					for (int i = 0; i < allCollections.get(group).size(); i++) {
						logger.debug("Comparing: " + allCollections.get(group).get(i).getId() + " with " + a);
						if (allCollections.get(group).get(i).getId().equals(a)) {
							if (!cols.contains(a))
								cols.add(a);
						}
					}
				}
			}
		}

		logger.debug("number of returned collections: " + cols.size());
		return cols;
	}

	public List<Field> getAvailableBrowseFields() {
		return browsableFields;
	}

	public List<Field> getAvailableSearchFields() {
		return searchableFields;
	}

	public List<Field> getAvailableSortFields() {
		return sortableFields;
	}

	public List<String> getAvailableLanguages() {
		return languages;
	}

	public List<Criterion> getCriteria() {
		return criteria;
	}

	public GeospatialInfo getGeosatial() {
		return geospatialInfo;
	}

	public Operator getOperator() {
		return operator;
	}

	public String getQueryDescription() {
		return queryDescription;
	}

	public String getQueryString() {
		return queryString;
	}

	public List<String> getSelectedCollections() {
		return selectedCollections;
	}

	public String getSelectedLanguage() {
		return languages.get(selectedLanguage);
	}

	public void reset() {
		criteria.clear();
		operator = Operator.OR;
		order = Order.ASC;
		distinct = false;
		searchQueryTerms.clear();
	}

	public void selectCollections(List<String> newCollections, boolean selected, ASLSession session) {
		try {
			for (int i = 0; i < newCollections.size(); i++) {
				logger.debug("new collections:**" + newCollections.get(i) + "**");
				if (selected && !selectedCollections.contains(newCollections.get(i))) {
					logger.debug("adding:**" + newCollections.get(i) + "**");
					selectedCollections.add(newCollections.get(i));
				} else if (!selected && selectedCollections.contains(newCollections.get(i))) {
					logger.debug("removing:**" + newCollections.get(i) + "**");
					selectedCollections.remove(newCollections.get(i));
				}

				criteria.clear();
				searchQueryTerms.clear();

			}

			logger.debug("Going to update the information for the selected collections");
			findAvailableFts(session);
			findAvailableGeospatial(session);
			findAvailableLanguages(session);
			findAvailableSearchFields(session);
			findAvailableBrowseFields(session);
			findAvailableSortFields(session);
			logger.debug("Number of searchable fields found -> " + searchableFields.size());
		} catch (Exception e) {
			logger.error("Exception:", e);
		}
	}

	public void setDistinct(boolean distinct) {
		this.distinct = distinct;
	}

	public void setGeospatial(GeospatialInfo geospatial) {
		logger.debug("Setting geospatial info.");
		this.geospatialInfo = geospatial;
	}

	public void setOperator(Operator operator) {
		this.operator = operator;
	}

	public boolean setSelectedLanguage(String lang, ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {
		reset();
		if (!languages.contains(lang))
			return false;
		selectedLanguage = languages.indexOf(lang);

		findAvailableSearchFields(session);
		return true;
	}

	public void updateCriterionId(int i, String id) {
		logger.debug("Updating criterion: " + i + ", previous id was: " + criteria.get(i).getSearchFieldId() + ", new is: " + id);
		criteria.get(i).setSearchFieldId(id);
	}

	public void updateCriterionName(int i, String name) {
		logger.debug("Updating criterion: " + i + ", previous name was: " + criteria.get(i).getSearchFieldName() + ", new is: " + name);
		criteria.get(i).setSearchFieldName(name);
	}

	public void updateCriterionValue(int i, String value) {
		logger.debug("Updating criterion: " + i + ", previous value was: " + criteria.get(i).getSearchFieldName() + ", new is: " + value);
		// if (value.contains("*")) {
		// if (!value.startsWith("\"") || !value.endsWith("\"")) {
		// String newValue = "\"" + value + "\"";
		// value = newValue;
		// }
		// }

		if (value.contains(" ") && (!value.startsWith("\"") || !value.endsWith("\""))) {
			String[] splitted = value.split(" ");
			criteria.get(i).setSearchFieldValue(splitted[0]);
			for (int j = 1; j < splitted.length; j++) {
				Criterion crit = new Criterion();
				crit.setSearchFieldId(criteria.get(i).getSearchFieldId());
				crit.setSearchFieldName(criteria.get(i).getSearchFieldName());
				crit.setSearchFieldValue(splitted[j]);
				criteria.add(crit);
			}
			return;
		}
		criteria.get(i).setSearchFieldValue(value);
	}

	public String getSearchType() {
		return searchType;
	}

	public void setSearchType(String searchType) {
		this.searchType = searchType;
	}

	public String getGenericSearchType() {
		return genericSearchType;
	}

	public List<String> getSelectedCollectionNames(ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {
	//	HashMap<CollectionInfo, ArrayList<CollectionInfo>> collections = (HashMap<CollectionInfo, ArrayList<CollectionInfo>>) session
	//			.getAttribute(SessionConstants.Collections);

		List<String> realCollections = getSelectedRealCollections(session);
		List<String> collectionNames = new ArrayList<String>();
		SearchHelper sh = new SearchHelper(session);
		for (String colId : realCollections) {
			CollectionInfo colInf = sh.findCollectionInfo(colId);
			if (colInf != null) {
				collectionNames.add(colInf.getName());
			}
		}
		return collectionNames;
	}

	public void setGenericSearchType(String genType) {
		genericSearchType = genType;
	}

	public void setSetRelation(boolean set) {
		setRelation = set;
	}

	public void setBrowseBy(String browseByField) {

		browseBy = browseByField;
	}

	public String getBrowseByField() {
		return browseBy;
	}

	public ResultSetConsumerI search(ASLSession session, boolean simple) throws URIRetrievalFromISCacheException, URISyntaxException, gRS2CreationException,
	QuerySyntaxException, NoSearchMasterEPRFoundException, InitialBridgingNotCompleteException, InternalErrorException {
		logger.debug("About to create Query");
		if (simple) {
			searchType = SearchType.SimpleSearch;
		} else
			searchType = SearchType.AdvancedSearch;
		ResultSetConsumer.removeSessionVariables(session);
		String[] query = createSearchQuery(session, simple);

		queryDescription = query[1];

		logger.debug("The Search Query is: ///////////////////////////////////////////////////////");
		logger.debug(query[0]);
		logger.debug("/////////////////////////////////////////////////////////////////////////");

		// submit query 0
		EndpointReference[] searchMasters = findSearchMasterEPR(session);
		if (searchMasters == null || searchMasters.length == 0) {
			logger.debug("No Search Masters Found");
			throw new NoSearchMasterEPRFoundException();
		} else {
			logger.debug("Number of Search Master EPRs: " + searchMasters.length);
		}
		for (int i = 0; i < searchMasters.length; i++) {
			try {
				long startTime = System.currentTimeMillis();
				logger.debug("////////////////////////Parsing query again!!!///////////////////////////////");
				//GCQLNode head = GCQLQueryTreeManager.parseGCQLString(query[0]);
				searchEPR = submitSearch(query[0], searchMasters[SMid.getAndIncrement() % searchMasters.length].getAddress().toString(), session);
				long endTime = System.currentTimeMillis();
				long diff = endTime - startTime;
				logger.debug("Portal Benchmarking - Time to get RSEpr from SearchMaster: " + diff);
			} catch (MalformedURIException e) {
				logger.error("An error occured while submitting search!", e);
				session.setAttribute(SessionConstants.searchException, "An internal error occurred while executing your query:<br>" + e.getMessage());
			} catch (SearchSystemPortRetrievalException e) {
				logger.error("An error occured while submitting search!", e);
				session.setAttribute(SessionConstants.searchException, "An internal error occurred while executing your query:<br>" + e.getMessage());
			} catch (QuerySubmissionSearchException e) {
				logger.error("An error occured while submitting search!", e);
				session.setAttribute(SessionConstants.searchException, "An internal error occurred while executing your query:<br>" + e.getMessage());
			}

			if (searchEPR != null) {
				logger.debug("The rs EPR returned is: " + searchEPR);
				session.setAttribute("rsEPR", searchEPR);
				searchRSC = new ResultSetConsumer(searchEPR, searchType);
				searchRSC.setGenericSearchType(genericSearchType);

				long time = System.currentTimeMillis();
				logger.debug("Portal Benchmarking - ResultSetConsumer is ready now: " + time);
				return searchRSC;
			} else
				logger.debug("No RS epr found - it is null.");
		}

		return null;

	}

	public ResultSetConsumerI genericSearch(ASLSession session, List<String> terms) throws URIRetrievalFromISCacheException, URISyntaxException,
	gRS2CreationException, QuerySyntaxException, NoSearchMasterEPRFoundException, InitialBridgingNotCompleteException, InternalErrorException {
		logger.debug("About to create Query");
		searchType = SearchType.GenericSearch;
		ResultSetConsumer.removeSessionVariables(session);
		String[] query = createGenericSearchQuery(session, terms);

		queryDescription = query[1];

		logger.debug("The Search Query is: ///////////////////////////////////////////////////////");
		logger.debug(query[0]);
		logger.debug("/////////////////////////////////////////////////////////////////////////");

		// submit query 0
		EndpointReference[] searchMasters = findSearchMasterEPR(session);
		if (searchMasters == null || searchMasters.length == 0) {
			logger.debug("No Search Masters Found");
			throw new NoSearchMasterEPRFoundException();
		} else {
			logger.debug("Number of Search Master EPRs: " + searchMasters.length);
		}
		for (int i = 0; i < searchMasters.length; i++) {
			try {
				long startTime = System.currentTimeMillis();
				logger.debug("////////////////////////Parsing query again!!!///////////////////////////////");
				//GCQLNode head = GCQLQueryTreeManager.parseGCQLString(query[0]);
				searchEPR = submitSearch(query[0], searchMasters[SMid.getAndIncrement() % searchMasters.length].getAddress().toString(), session);
				long endTime = System.currentTimeMillis();
				long diff = endTime - startTime;
				logger.debug("Portal Benchmarking - Time to get RSEpr from SearchMaster: " + diff);
			} catch (MalformedURIException e) {
				logger.error("An error occured while submitting search!", e);
				session.setAttribute(SessionConstants.searchException, "An internal error occurred while executing your query:<br>" + e.getMessage());
			} catch (SearchSystemPortRetrievalException e) {
				logger.error("An error occured while submitting search!", e);
				session.setAttribute(SessionConstants.searchException, "An internal error occurred while executing your query:<br>" + e.getMessage());
			} catch (QuerySubmissionSearchException e) {
				logger.error("An error occured while submitting search!", e);
				session.setAttribute(SessionConstants.searchException, "An internal error occurred while executing your query:<br>" + e.getMessage());
			}

			if (searchEPR != null) {
				logger.debug("The rs EPR returned is: " + searchEPR);
				session.setAttribute("rsEPR", searchEPR);
				searchRSC = new ResultSetConsumer(searchEPR, searchType);
				searchRSC.setGenericSearchType(genericSearchType);

				long time = System.currentTimeMillis();
				logger.debug("Portal Benchmarking - ResultSetConsumer is ready now: " + time);
				return searchRSC;
			} else
				logger.debug("No RS epr found - it is null.");
		}

		return null;

	}

	public ResultSetConsumerI browse(ASLSession session) throws URISyntaxException, gRS2CreationException, URIRetrievalFromISCacheException, InitialBridgingNotCompleteException, InternalErrorException {

		if (!distinct)
			searchType = SearchType.Browse;
		else
			searchType = SearchType.BrowseFields;
		ResultSetConsumer.removeSessionVariables(session);
		String[] query = createBrowseQuery(session);
		queryDescription = query[1];

		logger.debug("The browse Query is: ///////////////////////////////////////////////////////");
		logger.debug(query[0]);
		logger.debug("/////////////////////////////////////////////////////////////////////////");
		// submit query 0
		EndpointReference[] searchMasters = findSearchMasterEPR(session);
		for (int i = 0; i < searchMasters.length; i++) {
			try {
				searchEPR = submitSearch(query[0], searchMasters[SMid.getAndIncrement() % searchMasters.length].getAddress().toString(), session);
			} catch (MalformedURIException e) {
				session.setAttribute(SessionConstants.searchException, "An internal error occurred while executing your query:<br>" + e.getMessage());
			} catch (SearchSystemPortRetrievalException e) {
				session.setAttribute(SessionConstants.searchException, "An internal error occurred while executing your query:<br>" + e.getMessage());
			} catch (QuerySubmissionSearchException e) {
				session.setAttribute(SessionConstants.searchException, "An internal error occurred while executing your query:<br>" + e.getMessage());
			}

			if (searchEPR != null) {
				session.setAttribute("rsEPR", searchEPR);
				searchRSC = new ResultSetConsumer(searchEPR, searchType);
				searchRSC.setGenericSearchType(genericSearchType);

				SearchHelper sh = new SearchHelper(session);

				// ACCESS LOGGER
				String[][] colInfos = new String[selectedCollections.size()][2];
				for (int c = 0; c < selectedCollections.size(); c++) {
					CollectionInfo colInfo = sh.findCollectionInfo(selectedCollections.get(c));
					colInfos[c][0] = colInfo.getName();
					colInfos[c][1] = colInfo.getId();
				}
				String browseByName = new String();
				for (int b = 0; b < browsableFields.size(); b++) {
					if (browseBy.equals(browsableFields.get(b).getId())) {
						browseByName = browsableFields.get(b).getLabel();
					}
				}
				BrowseAccessLogEntry browseEntry = new BrowseAccessLogEntry(colInfos, browseByName, distinct);
				accessLogger.logEntry(session.getUsername(), session.getScopeName(), browseEntry);

				return searchRSC;
			} else
				logger.debug("No search epr found.");
		}

		return null;
	}

	public ResultSetConsumerI quickSearch(ASLSession session, String keyword) throws URIRetrievalFromISCacheException, URISyntaxException,
	gRS2CreationException {
		searchType = SearchType.QuickSearch;

		logger.debug("Inside quick search!");
		ResultSetConsumer.removeSessionVariables(session);
		// Check if there is a wildcard
		// if (keyword.contains("*")) {
		// if (!keyword.startsWith("\"") || !keyword.endsWith("\"")) {
		// String newKeyword = "\"" + keyword + "\"";
		// keyword = newKeyword;
		// }
		// }

		logger.debug("Trying to create quick query");
		String[] query = createQuickQuery(session, keyword);
		queryDescription = query[1];

		logger.debug("/////////////////////////////////////////////////////////////////////////");
		logger.debug("Quick Query: " + query[0]);
		logger.debug("/////////////////////////////////////////////////////////////////////////");
		// submit query 0
		EndpointReference[] searchMasters = findSearchMasterEPR(session);
		for (int i = 0; i < searchMasters.length; i++) {
			try {
				searchEPR = submitSearch(query[0], searchMasters[SMid.getAndIncrement() % searchMasters.length].getAddress().toString(), session);
			} catch (MalformedURIException e) {
				session.setAttribute(SessionConstants.searchException, "An internal error occurred while executing your query:<br>" + e.getMessage());
			} catch (SearchSystemPortRetrievalException e) {
				session.setAttribute(SessionConstants.searchException, "An internal error occurred while executing your query:<br>" + e.getMessage());
			} catch (QuerySubmissionSearchException e) {
				session.setAttribute(SessionConstants.searchException, "An internal error occurred while executing your query:<br>" + e.getMessage());
			}

			if (searchEPR != null) {
				logger.debug("The searchEPR returned is: " + searchEPR);
				session.setAttribute("rsEPR", searchEPR);
				searchRSC = new ResultSetConsumer(searchEPR, searchType);
				searchRSC.setGenericSearchType(genericSearchType);

				// ACCESS LOGGER
				QuickSearchAccessLogEntry quickEntry = new QuickSearchAccessLogEntry(keyword);
				accessLogger.logEntry(session.getUsername(), session.getScopeName(), quickEntry);

				return searchRSC;
			} else
				logger.debug("No search epr found.");
		}

		return null;
	}

	public String[] testSearchQuery(ASLSession session, boolean simple, boolean browse, String quick) throws InitialBridgingNotCompleteException, InternalErrorException {
		logger.debug("About to create Query for testing: ");
		String[] query = new String[2];

		if (!quick.equals("")) {
			query = createQuickQuery(session, quick);
		}

		else if (!browse) {
			try {
				query = createSearchQuery(session, simple);
			} catch (QuerySyntaxException e) {
				logger.error("Exception:", e);
			}
		} else {
			query = createBrowseQuery(session);
		}

		return query;

	}

	/**
	 * Submits the generic query to SearchMaster
	 * 
	 * @param session
	 *            the D4Science session to be used
	 * @param query
	 *            the query described in gCQL query language
	 * @return a consumer to retrieve the results as pages
	 * @throws URIRetrievalFromISCacheException
	 * @throws gRS2CreationException
	 * @throws URISyntaxException
	 * @throws NoSearchMasterEPRFoundException
	 */
	public ResultSetConsumerI genericSearch(ASLSession session, String query) throws URIRetrievalFromISCacheException, URISyntaxException,
	gRS2CreationException, NoSearchMasterEPRFoundException {
		EndpointReference[] searchMasters = findSearchMasterEPR(session);
		if (searchMasters == null || searchMasters.length == 0) {
			logger.debug("No Search Masters Found");
			throw new NoSearchMasterEPRFoundException();
		} else {
			logger.debug("Number of Search Master EPRs: " + searchMasters.length);
		}
		for (int i = 0; i < searchMasters.length; i++) {
			try {
				long startTime = System.currentTimeMillis();
				searchEPR = submitSearch(query, searchMasters[SMid.getAndIncrement() % searchMasters.length].getAddress().toString(), session);
				long endTime = System.currentTimeMillis();
				long diff = endTime - startTime;
				logger.debug("Portal Benchmarking - Time to get RSEpr from SearchMaster: " + diff);
			} catch (MalformedURIException e) {
				logger.error("An error occured while submitting search!", e);
				session.setAttribute(SessionConstants.searchException, "An internal error occurred while executing your query:<br>" + e.getMessage());
			} catch (SearchSystemPortRetrievalException e) {
				logger.error("An error occured while submitting search!", e);
				session.setAttribute(SessionConstants.searchException, "An internal error occurred while executing your query:<br>" + e.getMessage());
			} catch (QuerySubmissionSearchException e) {
				logger.error("An error occured while submitting search!", e);
				session.setAttribute(SessionConstants.searchException, "An internal error occurred while executing your query:<br>" + e.getMessage());
			}

			if (searchEPR != null) {
				logger.debug("The rs EPR returned is: " + searchEPR);
				session.setAttribute("rsEPR", searchEPR);
				searchRSC = new ResultSetConsumer(searchEPR, searchType);
				searchRSC.setGenericSearchType(genericSearchType);

				long time = System.currentTimeMillis();
				logger.debug("Portal Benchmarking - ResultSetConsumer is ready now: " + time);
				return searchRSC;
			} else
				logger.debug("No RS epr found - it is null.");
		}

		return null;
	}

	private void findAvailableFts(ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {
		List<String> selectedRealCollections = getSelectedRealCollections(session);
		ftsAvailable = false;
		if (selectedRealCollections != null && selectedRealCollections.size() != 0) {
			SearchHelper searchH = new SearchHelper(session);
			HashMap<CollectionInfo, ArrayList<CollectionInfo>> collections = searchH.getAvailableCollections();

			logger.debug("Inside findAvailableFTS");

			for (int i = 0; i < selectedRealCollections.size(); i++) {
				logger.debug("Trying to find collection info");
				CollectionInfo colInfo = FindFieldsInfo.findCollectionInfo(selectedRealCollections.get(i), collections);
				if (colInfo != null) {
					if (!colInfo.isFts()) {
						ftsAvailable = false;
						logger.debug("no available fts");
						break;
					} else {
						ftsId = colInfo.getFtsId();
						logger.debug("Col Info fts!: " + ftsId);
						ftsAvailable = true;
					}
				}
			}
		} else {
			ftsAvailable = false;
		}
	}

	private void findAvailableGeospatial(ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {
		List<String> selectedRealCollections = getSelectedRealCollections(session);
		if (selectedRealCollections != null && selectedRealCollections.size() != 0) {
			SearchHelper searchH = new SearchHelper(session);
			HashMap<CollectionInfo, ArrayList<CollectionInfo>> collections = searchH.getAvailableCollections();

			logger.debug("Inside findAvailableGeospatial");
		//	boolean found = false;
			for (int i = 0; i < selectedRealCollections.size(); i++) {
				logger.debug("Trying to find collection info");
				CollectionInfo colInfo = FindFieldsInfo.findCollectionInfo(selectedRealCollections.get(i), collections);
				if (colInfo != null) {
					if (!colInfo.isGeospatial()) {
						geoAvailable = false;
						break;
					} else {
						geoAvailable = true;
						geoField = colInfo.getGeospatialField();
					}

				}
			}
			// geoAvailable = true;
		} else
			geoAvailable = false;
	}

	protected String[] createSearchQuery(ASLSession session, boolean simple) throws QuerySyntaxException, InitialBridgingNotCompleteException, InternalErrorException {

		// ACCESS LOGGER preparation
		SearchHelper sh = new SearchHelper(session);
		ArrayList<String> externalCollections = sh.getExternalCollections();
		List<String> realCollections = getSelectedRealCollections(session);
		String[][] collectionsTable = new String[realCollections.size()][2];
		for (int c = 0; c < realCollections.size(); c++) {
			CollectionInfo colInfo = sh.findCollectionInfo(realCollections.get(c));
			if (externalCollections.contains(colInfo.getId())) {
				collectionsTable[c][0] = colInfo.getName() + "_externalCollection";
				collectionsTable[c][1] = colInfo.getId();
			} else {
				collectionsTable[c][0] = colInfo.getName();
				collectionsTable[c][1] = colInfo.getId();
			}
		}

		String[] q = new String[2];
		GCQLNode projectionNode = null;
		GCQLNode sortNode = null;

		if (!searchType.equals(SearchType.PreviousSearch)) {
			/* Get the projection and sort by part */
			projectionNode = getPresentationPart(session);
			if (sortBy != null && !sortBy.equals("")) {
				logger.debug("Sortby node");
				sortNode = getSortByPart(session);
			}
		}
		GCQLNode termsNode = getCriteriaPart(session, simple);

		if (termsNode == null && (geospatialInfo == null || geospatialInfo.getBounds() == null)) {
			throw new QuerySyntaxException("No criteria specified");
		}
		GCQLNode collectionsPart = getCollectionsQueryPart(session);
		if (searchType.equals(SearchType.PreviousSearch)) {
			// We have previous search: we need to remove the project and sort
			// nodes from the initial query - and add the new criteria
			GCQLProjectNode projectNode = (GCQLProjectNode) previousQuery;
			GCQLNode subtree = projectNode.subtree;
			GCQLSortNode sortInitialNode = null;
			GCQLNode tree = null;
			if (subtree instanceof GCQLSortNode) {
				sortInitialNode = (GCQLSortNode) subtree;
				tree = sortInitialNode.subtree;
			} else
				tree = subtree;

			// Create a boolean Node to connect the previous with the new
			// criteria
			GCQLAndNode andNode = new GCQLAndNode();
			andNode.left = tree;
			andNode.right = termsNode;
			if (sortInitialNode != null) {
				sortInitialNode.subtree = andNode;
				projectNode.subtree = sortInitialNode;
			} else {
				projectNode.subtree = andNode;
			}

			queryString = projectNode.toCQL();
			queryDescription = getQueryDescriptionForPreviousQuery(session);
			q[0] = queryString;
			q[1] = queryDescription;
			return q;
		}
		if (simple) {
			GCQLAndNode andNode = new GCQLAndNode();
			andNode.left = termsNode;
			andNode.right = collectionsPart;

			GCQLProjectNode projNode = null;
			if (projectionNode != null) {
				projNode = (GCQLProjectNode) projectionNode;
				if (sortNode != null) {
					logger.debug("Simple sortby");
					GCQLSortNode sort_node = (GCQLSortNode) sortNode;
					sort_node.subtree = andNode;
					projNode.subtree = sort_node;
				} else {
					projNode.subtree = andNode;
				}
			} else {
				if (sortNode != null) {
					logger.debug("Simple sortby");
					GCQLSortNode sort_node = (GCQLSortNode) sortNode;
					sort_node.subtree = andNode;
				}
			}

			if (projNode != null)
				queryString = projNode.toCQL();
			else {
				if (sortNode != null)
					queryString = sortNode.toCQL();
				else
					queryString = andNode.toCQL();
			}

			//TODO - Check!
			if(this.rankingSupport) {

				/* Create a string with all search terms, separated by empty space. */
				String searchTerms = new String();

				int totalSearchTerms = searchQueryTerms.size();

				/* In case of multiple search terms, start fusion with the " character. */
				if(totalSearchTerms > 1)
					searchTerms += "\"";

				for(int i = 0; i < (totalSearchTerms - 1); ++i)
					searchTerms += (searchQueryTerms.get(i) + " ");

				/* Add last search term, without a trailing space. */
				searchTerms += searchQueryTerms.get(totalSearchTerms - 1);

				/* In case of multiple search terms, end fusion with the " character. */
				if(totalSearchTerms > 1)
					searchTerms += "\"";

				/* Add support for data fusion. */
				queryString += " fuse " + searchTerms;
			}

			queryDescription = getQueryDescriptionForSimple(session);
			q[0] = queryString;
			q[1] = queryDescription;

			// ACCESS LOGGER
			SimpleSearchAccessLogEntry simpleEntry = new SimpleSearchAccessLogEntry(collectionsTable, this.searchTerm);
			accessLogger.logEntry(session.getUsername(), session.getScopeName(), simpleEntry);

			return q;
		} else {
			if (geospatialInfo == null || geospatialInfo.getBounds() == null) {
				GCQLNode languageNode = getLanguageQueryPart(session);
				GCQLAndNode andNode1 = new GCQLAndNode();
				andNode1.left = collectionsPart;
				andNode1.right = languageNode;
				GCQLAndNode andNode2 = new GCQLAndNode();
				andNode2.left = termsNode;
				andNode2.right = andNode1;
				GCQLProjectNode projNode = null;
				if (projectionNode != null) {
					projNode = (GCQLProjectNode) projectionNode;
					if (sortNode != null) {
						logger.debug("Advanced sortBy");
						GCQLSortNode sort_node = (GCQLSortNode) sortNode;
						sort_node.subtree = andNode2;
						projNode.subtree = sort_node;
					} else {
						projNode.subtree = andNode2;
					}
				} else {
					if (sortNode != null) {
						GCQLSortNode sort_node = (GCQLSortNode) sortNode;
						sort_node.subtree = andNode2;
					}
				}

				if (projNode != null)
					queryString = projNode.toCQL();
				else if (sortNode != null)
					queryString = sortNode.toCQL();
				else
					queryString = andNode2.toCQL();

				queryDescription = getQueryDescriptionForAdvanced(session);
				q[0] = queryString;
				q[1] = queryDescription;

				// ACCESS LOGGER
				String[][] criteriaTable = new String[criteria.size()][2];
				for (int m = 0; m < criteria.size(); m++) {
					criteriaTable[m][0] = criteria.get(m).getSearchFieldName();
					logger.info(criteriaTable[m][0]);
					criteriaTable[m][1] = criteria.get(m).getSearchFieldValue();
					logger.info(criteriaTable[m][1]);
				}
				String oper;
				if (operator == Operator.AND) {
					oper = "AND";
				} else
					oper = "OR";
				AdvancedSearchAccessLogEntry advancedEntry = new AdvancedSearchAccessLogEntry(collectionsTable, criteriaTable, oper);
				accessLogger.logEntry(session.getUsername(), session.getScopeName(), advancedEntry);

				return q;
			} else {
				// geospatial search

				// create first the geospatial part
				// GCQLNode languageNode = getLanguageQueryPart(session);
				// GCQLNode geoCollectionsPart =
				// getGeoCollectionsQueryPart(session);
				// GCQLAndNode andNode1 = new GCQLAndNode();
				// andNode1.left = geoCollectionsPart;
				// andNode1.right = languageNode;
				// GCQLAndNode andNode2 = new GCQLAndNode();

				// List<String> realCollections =
				// getSelectedRealCollections(session);
				SearchHelper s_h = new SearchHelper(session);
				CollectionInfo colInfo = null;
				ArrayList<GCQLNode> geoNodes = new ArrayList<GCQLNode>();
				for (int i = 0; i < realCollections.size(); i++) {
					colInfo = s_h.findCollectionInfo(realCollections.get(i));
					if (colInfo.isGeospatial()) {
						GCQLNode geoNd = getGeoQueryPart(session, colInfo.getId());
						geoNodes.add(geoNd);
					}
				}
				// GCQLNode geoQueryPart = getGeoQueryPart(session);
				// andNode2.left = geoQueryPart;
				// andNode2.right = andNode1;

				GCQLNode geoQueryPart = null;
				if (geoNodes.size() > 1) {
					GCQLOrNode previousNode = null;
					for (int i = 0; i < geoNodes.size() - 1; i++) {
						if (previousNode == null) {
							previousNode = new GCQLOrNode();
							previousNode.left = geoNodes.get(i);
							previousNode.right = geoNodes.get(i + 1);
						} else {
							GCQLOrNode orNd = new GCQLOrNode();
							orNd.left = previousNode;
							orNd.right = geoNodes.get(i + 1);
							previousNode = orNd;
						}
					}

					geoQueryPart = previousNode;
				} else {
					geoQueryPart = geoNodes.get(0);
				}

				// create the criteria part node
				GCQLAndNode andNode3 = null;
				if (criteria != null && criteria.size() != 0) {
					andNode3 = new GCQLAndNode();
					// andNode3.left = andNode2;
					andNode3.left = geoQueryPart;
					andNode3.right = termsNode;
				}

				GCQLProjectNode projNode = null;
				if (projectionNode != null) {
					projNode = (GCQLProjectNode) projectionNode;
					if (sortNode != null) {
						GCQLSortNode sort_node = (GCQLSortNode) sortNode;
						if (andNode3 != null)
							sort_node.subtree = andNode3;
						else {
							// sort_node.subtree = andNode2;
							sort_node.subtree = geoQueryPart;
						}

						projNode.subtree = sort_node;
					} else {
						if (andNode3 != null) {
							projNode.subtree = andNode3;
						} else {
							// projNode.subtree = andNode2;
							projNode.subtree = geoQueryPart;
						}
					}
				} else {
					if (sortNode != null) {
						GCQLSortNode sort_node = (GCQLSortNode) sortNode;
						if (andNode3 != null)
							sort_node.subtree = andNode3;
						else {
							// sort_node.subtree = andNode2;
							sort_node.subtree = geoQueryPart;
						}
					}
				}

				if (projNode != null)
					queryString = projNode.toCQL();
				else if (sortNode != null)
					queryString = sortNode.toCQL();
				else if (andNode3 != null)
					queryString = andNode3.toCQL();
				// else if (andNode2 != null)
				// queryString = andNode2.toCQL();
				else if (geoQueryPart != null)
					queryString = geoQueryPart.toCQL();
				queryDescription = getQueryDescriptionForGeospatial(session);
				q[0] = queryString;
				q[1] = queryDescription;

				return q;
			}
		}
	}

	//check this later to add there also the snippet
	private String[] createGenericSearchQuery(ASLSession session, List<String> terms) throws QuerySyntaxException, InitialBridgingNotCompleteException, InternalErrorException {
		// ACCESS LOGGER preparation
		SearchHelper sh = new SearchHelper(session);
		HashMap<CollectionInfo, ArrayList<CollectionInfo>> availableCollections = sh.getAvailableCollections();
		// String[][] collectionsTable = new String[realCollections.size()][2];
		Iterator<Entry<CollectionInfo, ArrayList<CollectionInfo>>> iterator = availableCollections.entrySet().iterator();
		List<String> names = new ArrayList<String>();
		List<String> ids = new ArrayList<String>();
		while (iterator.hasNext()) {
			Entry<CollectionInfo, ArrayList<CollectionInfo>> entry = iterator.next();
			for (CollectionInfo collection : entry.getValue()) {
				if (collection.isFts()) {
					names.add(collection.getName());
					ids.add(collection.getId());
					ftsId = collection.getFtsId();
				}
			}
		}
		String[][] collectionsTable = new String[names.size()][2];
		for (int i = 0; i < names.size(); i++) {
			collectionsTable[i][0] = names.get(i);
			collectionsTable[i][1] = ids.get(i);
		}

		String[] q = new String[2];
		GCQLNode projectionNode = null;
		GCQLNode sortNode = null;

		if (!searchType.equals(SearchType.PreviousSearch)) {
			/* Get the projection and sort by part */
			projectionNode = getPresentationPart(session);
			if (sortBy != null && !sortBy.equals("")) {
				logger.debug("Sortby node");
				sortNode = getSortByPart(session);
			}
		}
		GCQLNode termsNode = getGenericCriterialPart(session, terms);

		if (termsNode == null && (geospatialInfo == null || geospatialInfo.getBounds() == null)) {
			throw new QuerySyntaxException("No criteria specified");
		}
		logger.info("Printing criterial part "+termsNode.toCQL());

		GCQLNode collectionsPart = getCollectionsGenericQueryPart(session);

		if (searchType.equals(SearchType.PreviousSearch)) {
			// We have previous search: we need to remove the project and sort
			// nodes from the initial query - and add the new criteria
			GCQLProjectNode projectNode = (GCQLProjectNode) previousQuery;
			GCQLNode subtree = projectNode.subtree;
			GCQLSortNode sortInitialNode = null;
			GCQLNode tree = null;
			if (subtree instanceof GCQLSortNode) {
				sortInitialNode = (GCQLSortNode) subtree;
				tree = sortInitialNode.subtree;
			} else
				tree = subtree;

			// Create a boolean Node to connect the previous with the new
			// criteria
			GCQLAndNode andNode = new GCQLAndNode();
			andNode.left = tree;
			andNode.right = termsNode;
			if (sortInitialNode != null) {
				sortInitialNode.subtree = andNode;
				projectNode.subtree = sortInitialNode;
			} else {
				projectNode.subtree = andNode;
			}

			queryString = projectNode.toCQL();
			queryDescription = getQueryDescriptionForPreviousQuery(session);
			q[0] = queryString;
			q[1] = queryDescription;
			return q;
		}
		GCQLAndNode andNode = new GCQLAndNode();
		andNode.left = termsNode;
		andNode.right = collectionsPart;

		GCQLProjectNode projNode = null;
		if (projectionNode != null) {
			projNode = (GCQLProjectNode) projectionNode;
			if (sortNode != null) {
				logger.debug("Simple sortby");
				GCQLSortNode sort_node = (GCQLSortNode) sortNode;
				sort_node.subtree = andNode;
				projNode.subtree = sort_node;
			} else {
				projNode.subtree = andNode;
			}
		} else {
			if (sortNode != null) {
				logger.debug("Simple sortby");
				GCQLSortNode sort_node = (GCQLSortNode) sortNode;
				sort_node.subtree = andNode;
			}
		}

		if (projNode != null)
			queryString = projNode.toCQL();
		else {
			if (sortNode != null)
				queryString = sortNode.toCQL();
			else
				queryString = andNode.toCQL();
		}
		queryDescription = getQueryDescriptionForSimple(session);
		q[0] = queryString;
		q[1] = queryDescription;

		// ACCESS LOGGER
		SimpleSearchAccessLogEntry simpleEntry = new SimpleSearchAccessLogEntry(collectionsTable, this.searchTerm);
		accessLogger.logEntry(session.getUsername(), session.getScopeName(), simpleEntry);

		return q;
	}

	protected String[] createBrowseQuery(ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {
		String[] q = new String[2];
		GCQLNode projectionNode = null;
		if (distinct) {
			logger.debug("getting distinct");
			projectionNode = getPresentationPartDistinct(session);
			logger.debug("Got presentation part browse distinct");
		} else {
			projectionNode = getPresentationPart(session);
			logger.debug("Got presentation part browse");
		}
		GCQLNode browseNode = getBrowseCriteriaPart(session);
		GCQLNode collectionsPart = getCollectionsQueryPart(session);

		GCQLAndNode andNode = new GCQLAndNode();
		andNode.left = browseNode;
		andNode.right = collectionsPart;

		if (projectionNode != null) {
			GCQLProjectNode projNode = (GCQLProjectNode) projectionNode;
			projNode.subtree = andNode;

			q[0] = projNode.toCQL();
		} else {
			q[0] = andNode.toCQL();
		}
		q[1] = getQueryDescriptionForBrowse(session);
		return q;
	}

	protected String[] createQuickQuery(ASLSession session, String keyword) {
		String[] q = new String[2];

		logger.debug("quick trying to get presentation part keyword is: " + keyword);
		GCQLNode projectionNode = getPresentationPart(session);
		logger.debug("Quick got presentation part");
		GCQLNode quickNode = getQuickCriterionPart(session, keyword);
		logger.debug("Quick got criteria part");
		if (projectionNode != null) {
			GCQLProjectNode projNode = (GCQLProjectNode) projectionNode;
			projNode.subtree = quickNode;

			q[0] = projNode.toCQL();
		} else {
			q[0] = quickNode.toCQL();
		}
		q[1] = getQueryDescriptionForQuick(session, keyword);
		return q;
	}

	protected String getQueryDescriptionForSimple(ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {
		String queryDescr = /* "Search for: */"\"" + searchTerm + "\" in collection(s): ";
		List<String> selectedRealCollections = getSelectedRealCollections(session);
		SearchHelper sh = new SearchHelper(session);
		for (int i = 0; i < selectedRealCollections.size(); i++) {
			CollectionInfo colInfo = sh.findCollectionInfo(selectedRealCollections.get(i));
			queryDescr += colInfo.getName() + ", ";
		}

		queryDescr = queryDescr.substring(0, queryDescr.length() - 2);
		if (sortBy != null && !sortBy.equals("")) {
			logger.debug("The sort by is simple: " + sortBy);
			queryDescr += ". Sort the results by: " + findSortFieldName(sortBy);
		}
		return queryDescr;
	}

	protected String getQueryDescriptionForQuick(ASLSession session, String keyword) {
		String queryDescr = "Search for: \"" + keyword + "\"  in all collections";
		return queryDescr;
	}

	private String findSortFieldName(String sortById) {
		for (Field x : sortableFields) {
			logger.debug("comparing sortby: " + x.getId() + " with " + sortById);
			if (x.getId().trim().equals(sortById.trim()))
				return x.getName();
		}
		return "";
	}

	protected String getQueryDescriptionForBrowse(ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {
		String queryDescr = "Browse by: " + findSearchFieldName(browseBy.trim()) + " in collection(s): ";
		List<String> selectedRealCollections = getSelectedRealCollections(session);
		SearchHelper sh = new SearchHelper(session);
		for (int i = 0; i < selectedRealCollections.size(); i++) {
			CollectionInfo colInfo = sh.findCollectionInfo(selectedRealCollections.get(i));
			queryDescr += colInfo.getName() + ", ";
		}

		queryDescr = queryDescr.substring(0, queryDescr.length() - 2);
		return queryDescr;
	}

	protected String getQueryDescriptionForAdvanced(ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {
		// String queryDescr = "Search for: ";
		String queryDescr = new String();
		for (int i = 0; i < criteria.size(); i++) {
			logger.debug("Criterion name: " + (criteria.get(i).getSearchFieldId()));
			queryDescr += findSearchFieldName(criteria.get(i).getSearchFieldId());
			queryDescr += " = \"" + criteria.get(i).getSearchFieldValue();
			// queryDescr += "\", ";
			if (operator == Operator.OR) {
				queryDescr += "\" or ";
			} else {
				queryDescr += "\" and ";
			}
		}
		logger.debug(queryDescr);
		if (operator == Operator.OR)
			queryDescr = queryDescr.substring(0, queryDescr.length() - 4);
		else
			queryDescr = queryDescr.substring(0, queryDescr.length() - 5);
		queryDescr += " in collection(s): ";
		SearchHelper sh = new SearchHelper(session);
		List<String> selectedRealCollections = getSelectedRealCollections(session);
		for (int i = 0; i < selectedRealCollections.size(); i++) {
			CollectionInfo colInfo = sh.findCollectionInfo(selectedRealCollections.get(i));
			queryDescr += colInfo.getName() + ", ";
		}
		queryDescr += "in " + languages.get(selectedLanguage) + " language.";
		if (sortBy != null && !sortBy.equals("")) {
			logger.debug("The sortby field is: " + sortBy);
			queryDescr += " Sort the results by: " + findSortFieldName(sortBy);
		}
		return queryDescr;
	}

	protected String getQueryDescriptionForGeospatial(ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {
		if (criteria != null && criteria.size() != 0)
			return getQueryDescriptionForAdvanced(session);
		else
			return "GeospatialSearch";
	}

	protected String getQueryDescriptionForPreviousQuery(ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {
		String queryDescr = previousQueryDescription + ", and" + getQueryDescriptionForAdvanced(session);
		return queryDescr;
	}

	private String findSearchFieldName(String sfId) {
		for (Field x : searchableFields) {
			logger.debug("Compare criterion: " + x.getId().trim() + " with  " + sfId.trim());
			if (x.getId().trim().equals(sfId.trim())) {
				logger.debug("The name is: " + x.getName() + " and the label: " + x.getLabel());
				return x.getName();
			} else {
				logger.debug("Not equal!");
			}
		}
		return "";
	}

	protected GCQLNode getCollectionsQueryPart(ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {
		List<String> realCollections = getSelectedRealCollections(session);

		GCQLRelation colRelation = new GCQLRelation();
		colRelation.setBase(SearchConstants.CollectionsRelation);

		// Create a GCQLTermNode for the First Collection
		GCQLTermNode collectionNode = new GCQLTermNode();
		collectionNode.setIndex(SearchConstants.CollectionField);
		collectionNode.setRelation(colRelation);
		collectionNode.setTerm(realCollections.get(0));
		if (realCollections.size() == 1) {
			return collectionNode;
		}

		// we have more than one collections
		GCQLOrNode previousOrNode = null;

		for (int i = 1; i < realCollections.size(); i++) {
			GCQLTermNode newColNode = new GCQLTermNode();
			newColNode.setIndex(SearchConstants.CollectionField);
			newColNode.setRelation(colRelation);
			newColNode.setTerm(realCollections.get(i));
			if (previousOrNode == null) {
				previousOrNode = new GCQLOrNode();
				previousOrNode.left = collectionNode;
				previousOrNode.right = newColNode;
			} else {
				GCQLOrNode newOrNode = new GCQLOrNode();
				newOrNode.right = previousOrNode;
				newOrNode.left = newColNode;
				previousOrNode = newOrNode;
			}
		}

		return previousOrNode;
	}


	protected GCQLNode getCollectionsGenericQueryPart(ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {
		//		List<String> realCollections = getSelectedRealCollections(session);
		SearchHelper sh = new SearchHelper(session);
		HashMap<CollectionInfo, ArrayList<CollectionInfo>> availableCollections = sh.getAvailableCollections();

		List<String> allCollections = new ArrayList<String>();
		Iterator<CollectionInfo> iter = availableCollections.keySet().iterator();
		while(iter.hasNext())
		{
			ArrayList<CollectionInfo> group = availableCollections.get(iter.next());
			for(int i=0;i<group.size();i++)
			{
				if(group.get(i).isFts())
					allCollections.add(group.get(i).getId());	
			}
		}

		GCQLRelation colRelation = new GCQLRelation();
		colRelation.setBase(SearchConstants.CollectionsRelation);

		// Create a GCQLTermNode for the First Collection
		GCQLTermNode collectionNode = new GCQLTermNode();
		collectionNode.setIndex(SearchConstants.CollectionField);
		collectionNode.setRelation(colRelation);
		collectionNode.setTerm(allCollections.get(0));
		if (allCollections.size() == 1) {
			return collectionNode;
		}

		// we have more than one collections
		GCQLOrNode previousOrNode = null;

		for (int i = 1; i < allCollections.size(); i++) {
			GCQLTermNode newColNode = new GCQLTermNode();
			newColNode.setIndex(SearchConstants.CollectionField);
			newColNode.setRelation(colRelation);
			newColNode.setTerm(allCollections.get(i));
			if (previousOrNode == null) {
				previousOrNode = new GCQLOrNode();
				previousOrNode.left = collectionNode;
				previousOrNode.right = newColNode;
			} else {
				GCQLOrNode newOrNode = new GCQLOrNode();
				newOrNode.right = previousOrNode;
				newOrNode.left = newColNode;
				previousOrNode = newOrNode;
			}
		}

		return previousOrNode;
	}

	protected GCQLNode getGeoQueryPart(ASLSession session, String collectionId) {
		GCQLTermNode geoNode = new GCQLTermNode();
		// geoNode.setIndex(SearchConstants.GEO_Field);
		geoNode.setIndex(geoField.getId());
		GCQLRelation geoRel = new GCQLRelation();
		geoRel.setBase(SearchConstants.GEO_Relation);
		Modifier inclusionMod = new Modifier(SearchConstants.geoInclusionMod, "=", SearchConstants.contains);

		Modifier collectionMod = new Modifier(SearchConstants.geoCollectionMod, "=", collectionId);
		Modifier languageMod = new Modifier(SearchConstants.geoLanguageMod, "=", languages.get(selectedLanguage));
		Modifier rankerMod = new Modifier(SearchConstants.geoRankerMod, "=", "\"" + SearchConstants.genericRanker + " false" + "\"");
		Modifier refinerMod = new Modifier(SearchConstants.geoRefinerMod, "=", "\"" + SearchConstants.timeSpanRefiner + " false "
				+ geospatialInfo.getStartingDateString() + " " + geospatialInfo.getEndingDateString() + "\"");
		ArrayList<Modifier> modifiers = new ArrayList<Modifier>();
		// modifiers.add(inclusionMod);
		modifiers.add(collectionMod);
		modifiers.add(languageMod);
		modifiers.add(inclusionMod);
		modifiers.add(rankerMod);
		modifiers.add(refinerMod);
		geoRel.setModifiers(modifiers);
		geoNode.setRelation(geoRel);
		String coordinates = new String();
		Point[] points = geospatialInfo.getBounds();
		for (int i = 0; i < points.length; i++) {
			double x = points[i].getLongitude();
			double y = points[i].getLatitude();
			coordinates += String.valueOf(x) + " " + String.valueOf(y) + " ";
		}
		// cut the last space
		coordinates = "\"" + coordinates.substring(0, coordinates.length() - 1) + "\"";
		geoNode.setTerm(coordinates);

		return geoNode;
	}

	protected GCQLNode getGeoCollectionsQueryPart(ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {
		List<String> realCollections = getSelectedRealCollections(session);

		GCQLRelation colRelation = new GCQLRelation();
		colRelation.setBase(SearchConstants.CollectionsRelation);
		SearchHelper s_h = new SearchHelper(session);

		// Create a GCQLTermNode for the first collection that has a geo index
		GCQLTermNode collectionNode = null;
		int i;
		for (i = 0; i < realCollections.size(); i++) {
			CollectionInfo colInfo = s_h.findCollectionInfo(realCollections.get(i));
			if (colInfo.isGeospatial()) {
				collectionNode = new GCQLTermNode();
				collectionNode.setIndex(SearchConstants.CollectionField);
				collectionNode.setRelation(colRelation);
				collectionNode.setTerm(realCollections.get(i));
				break;
			}
		}

		if (collectionNode == null)
			return null;
		else {
			GCQLOrNode previousOrNode = null;
			for (; i < realCollections.size(); i++) {
				CollectionInfo colInfo = s_h.findCollectionInfo(realCollections.get(i));
				if (colInfo.isGeospatial()) {
					GCQLTermNode newColNode = new GCQLTermNode();
					newColNode.setIndex(SearchConstants.CollectionField);
					newColNode.setRelation(colRelation);
					newColNode.setTerm(realCollections.get(i));
					if (previousOrNode == null) {
						previousOrNode = new GCQLOrNode();
						previousOrNode.left = collectionNode;
						previousOrNode.right = newColNode;
					} else {
						GCQLOrNode newOrNode = new GCQLOrNode();
						newOrNode.right = previousOrNode;
						newOrNode.left = newColNode;
						previousOrNode = newOrNode;
					}
				}
			}

			if (previousOrNode == null)
				return collectionNode;
			else
				return previousOrNode;
		}
	}

	protected GCQLNode getGenericCriterialPart(ASLSession session, List<String> terms) throws QuerySyntaxException {
		logger.debug("Inside getGenericCriterialPart - the search type is: " + searchType);
		int size = terms.size();
		if (size < 1) {
			throw new QuerySyntaxException("Empty term list given");
		}
		GCQLRelation fieldRelation = new GCQLRelation();
		fieldRelation.setBase(SearchConstants.CommonFieldRelation);
		GCQLTermNode criterionNode = new GCQLTermNode();
		criterionNode.setIndex(ftsId);
		criterionNode.setRelation(fieldRelation);
		criterionNode.setTerm(terms.get(0));
		if (size == 1) {
			return criterionNode;
		}
		GCQLOrNode previousOrNode = null;
		for (int i = 1; i < size; i++) {
			GCQLTermNode newCriterionNode = new GCQLTermNode();
			newCriterionNode.setIndex(ftsId);
			newCriterionNode.setRelation(fieldRelation);
			newCriterionNode.setTerm(terms.get(i));

			if (previousOrNode == null) {
				previousOrNode = new GCQLOrNode();
				previousOrNode.left = criterionNode;
				previousOrNode.right = newCriterionNode;
			} else {
				GCQLOrNode newOrNode = new GCQLOrNode();
				newOrNode.right = previousOrNode;
				newOrNode.left = newCriterionNode;
				previousOrNode = newOrNode;
			}

			searchQueryTerms.add(terms.get(i));
		}
		return previousOrNode;
	}

	protected GCQLNode getCriteriaPart(ASLSession session, boolean simple) {
		logger.debug("Inside getCriteriaPart - the search type is: " + searchType);
		searchQueryTerms.clear();
		if (!simple) {
			if (previousCriteria != null && previousCriteria.size() != 0) {
				for (int i = 0; i < previousCriteria.size(); i++) {
					criteria.add(previousCriteria.get(i).clone());
					searchQueryTerms.add(previousCriteria.get(i).getSearchFieldValue());
				}
				// criteria.addAll(previousCriteria);
				previousCriteria.clear();
				this.operator = Operator.AND;
			} else
				logger.debug("no previous criteria set");
			if (criteria != null && criteria.size() != 0) {
				GCQLRelation fieldRelation = new GCQLRelation();
				fieldRelation.setBase(SearchConstants.CommonFieldRelation);

				// Create a GCQLTermNode for the first criterion
				GCQLTermNode criterionNode = new GCQLTermNode();
				// if (criteria.get(0).getSearchFieldId().equals("Any")) {
				// criterionNode.setIndex(SearchConstants.FTS_Field);
				// } else {
				criterionNode.setIndex(criteria.get(0).getSearchFieldId());
				// }
				criterionNode.setRelation(fieldRelation);
				criterionNode.setTerm(criteria.get(0).getSearchFieldValue());

				searchQueryTerms.add(criteria.get(0).getSearchFieldValue());
				if (criteria.size() == 1) {
					if (criteria.get(0).getSearchFieldValue() == null || criteria.get(0).getSearchFieldValue().equals(""))
						return null;
					return criterionNode;
				}

				// we have more than one criteria
				if (operator.equals(Operator.AND)) {
					GCQLAndNode previousAndNode = null;
					for (int i = 1; i < criteria.size(); i++) {
						if (criteria.get(i).getSearchFieldValue() == null || criteria.get(i).getSearchFieldValue().equals(""))
							continue;

						GCQLTermNode newCriterionNode = new GCQLTermNode();
						// if (criteria.get(i).getSearchFieldId().equals("Any"))
						// {
						// newCriterionNode.setIndex(SearchConstants.FTS_Field);
						// } else {
						newCriterionNode.setIndex(criteria.get(i).getSearchFieldId());
						// }
						newCriterionNode.setRelation(fieldRelation);
						newCriterionNode.setTerm(criteria.get(i).getSearchFieldValue());

						searchQueryTerms.add(criteria.get(i).getSearchFieldValue());

						if (previousAndNode == null) {
							previousAndNode = new GCQLAndNode();
							previousAndNode.left = criterionNode;
							previousAndNode.right = newCriterionNode;
						} else {
							GCQLAndNode newAndNode = new GCQLAndNode();
							newAndNode.right = previousAndNode;
							newAndNode.left = newCriterionNode;
							previousAndNode = newAndNode;
						}
					}
					return previousAndNode;
				} else {
					GCQLOrNode previousOrNode = null;
					for (int i = 1; i < criteria.size(); i++) {

						if (criteria.get(i).getSearchFieldValue() == null || criteria.get(i).getSearchFieldValue().equals(""))
							continue;
						GCQLTermNode newCriterionNode = new GCQLTermNode();
						if (criteria.get(i).getSearchFieldName().equals("Any")) {
							// newCriterionNode.setIndex(SearchConstants.FTS_Field);
							newCriterionNode.setIndex(ftsId);
						} else {
							newCriterionNode.setIndex(criteria.get(i).getSearchFieldId());
						}
						newCriterionNode.setRelation(fieldRelation);
						newCriterionNode.setTerm(criteria.get(i).getSearchFieldValue());

						searchQueryTerms.add(criteria.get(i).getSearchFieldValue());

						if (previousOrNode == null) {
							previousOrNode = new GCQLOrNode();
							previousOrNode.left = criterionNode;
							previousOrNode.right = newCriterionNode;
						} else {
							GCQLOrNode newOrNode = new GCQLOrNode();
							newOrNode.right = previousOrNode;
							newOrNode.left = newCriterionNode;
							previousOrNode = newOrNode;
						}
					}
					return previousOrNode;
				}
			} else
				return null;
		} else {

			if (!searchTerm.contains(" ") || (searchTerm.startsWith("\"") && searchTerm.endsWith("\""))) {
				GCQLRelation fieldRelation = new GCQLRelation();
				fieldRelation.setBase(SearchConstants.CommonFieldRelation);

				// Create a GCQLTermNode for the first criterion
				GCQLTermNode criterionNode = new GCQLTermNode();
				// criterionNode.setIndex(SearchConstants.FTS_Field);
				logger.debug("The fts id is: " + ftsId);
				criterionNode.setIndex(ftsId);
				criterionNode.setRelation(fieldRelation);
				criterionNode.setTerm(searchTerm);

				searchQueryTerms.add(searchTerm);

				return criterionNode;
			} else {
				String[] searchTerms = searchTerm.split("\\s+");
				GCQLRelation fieldRelation = new GCQLRelation();
				fieldRelation.setBase(SearchConstants.CommonFieldRelation);
				GCQLTermNode criterionNode = new GCQLTermNode();
				criterionNode.setIndex(ftsId);
				criterionNode.setRelation(fieldRelation);
				criterionNode.setTerm(searchTerms[0]);

				//TODO - Check
				searchQueryTerms.add(searchTerms[0]);

				GCQLOrNode previousOrNode = null;
				for (int i = 1; i < searchTerms.length; i++) {
					GCQLTermNode newCriterionNode = new GCQLTermNode();
					newCriterionNode.setIndex(ftsId);
					newCriterionNode.setRelation(fieldRelation);
					newCriterionNode.setTerm(searchTerms[i]);

					if (previousOrNode == null) {
						previousOrNode = new GCQLOrNode();
						previousOrNode.left = criterionNode;
						previousOrNode.right = newCriterionNode;
					} else {
						GCQLOrNode newOrNode = new GCQLOrNode();
						newOrNode.right = previousOrNode;
						newOrNode.left = newCriterionNode;
						previousOrNode = newOrNode;
					}

					searchQueryTerms.add(searchTerms[i]);
				}
				return previousOrNode;
			}
		}
	}

	protected GCQLNode getQuickCriterionPart(ASLSession session, String keyword) {
		GCQLRelation fieldRelation = new GCQLRelation();
		fieldRelation.setBase(SearchConstants.CommonFieldRelation);

		logger.debug("Quick getting criterion");
		// Create a GCQLTermNode for the first criterion
		GCQLTermNode criterionNode = new GCQLTermNode();
		// criterionNode.setIndex(SearchConstants.FTS_Field);
		String quickField = "";
		try {

			quickField = (String) session.getAttribute("quickFieldId");
			if (quickField == null) {
				logger.debug("Quick got presentation part from registry");
				List<gr.uoa.di.madgik.rr.element.search.Field> alFields = gr.uoa.di.madgik.rr.element.search.Field.getFieldsWithName(false, "allIndexes");
				if (alFields != null && alFields.size() != 0) {
					criterionNode.setIndex(alFields.get(0).getID());
					session.setAttribute("quickFieldId", criterionNode.getIndex());
				}

				logger.debug("Quick got it");
			} else
				criterionNode.setIndex(quickField);

			// TODO: throw better exception
		} catch (ResourceRegistryException e) {
			// TODO Auto-generated catch block
			logger.error("Exception:", e);
		}
		criterionNode.setRelation(fieldRelation);
		if (!keyword.contains(" ") || (keyword.startsWith("\"") && (keyword.endsWith("\"")))) {
			criterionNode.setTerm(keyword);
			return criterionNode;
		} else if (keyword.contains(" ")) {
			String[] searchTerms = keyword.split(" ");
			criterionNode.setTerm(searchTerms[0]);
			GCQLOrNode previousOrNode = null;
			for (int i = 1; i < searchTerms.length; i++) {
				GCQLTermNode newCriterionNode = new GCQLTermNode();
				newCriterionNode.setIndex(criterionNode.getIndex());
				newCriterionNode.setRelation(criterionNode.getRelation());
				newCriterionNode.setTerm(searchTerms[i]);

				if (previousOrNode == null) {
					previousOrNode = new GCQLOrNode();
					previousOrNode.left = criterionNode;
					previousOrNode.right = newCriterionNode;
				} else {
					GCQLOrNode newOrNode = new GCQLOrNode();
					newOrNode.right = previousOrNode;
					newOrNode.left = newCriterionNode;
					previousOrNode = newOrNode;
				}
			}
			return previousOrNode;

		} else {
			criterionNode.setTerm(keyword);
			return criterionNode;
		}

	}

	protected GCQLNode getBrowseCriteriaPart(ASLSession session) {
		GCQLRelation browseFieldRelation = new GCQLRelation();
		browseFieldRelation.setBase(SearchConstants.BrowseFieldRelation);
		GCQLTermNode newCriterionNode = new GCQLTermNode();
		newCriterionNode.setIndex(browseBy);
		newCriterionNode.setRelation(browseFieldRelation);
		newCriterionNode.setTerm("\"*\"");
		return newCriterionNode;
	}

	protected GCQLNode getLanguageQueryPart(ASLSession session) {
		// Create a GCQLTerm node for the language
		GCQLTermNode languageNode = new GCQLTermNode();
		languageNode.setIndex(SearchConstants.LanguageField);
		GCQLRelation languageRelation = new GCQLRelation();
		languageRelation.setBase(SearchConstants.LanguagesRelation);
		languageNode.setRelation(languageRelation);
		languageNode.setTerm(this.languages.get(this.selectedLanguage));

		return languageNode;
	}

	protected List<String> findAllPresentableFields(ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException, ResourceRegistryException {
		// don't get them from the profile - get all the presentation fields
		SearchHelper sh = new SearchHelper(session);
		List<String> selectedRealCollections = getSelectedRealCollections(session);
		ArrayList<String> allFields = new ArrayList<String>();
		CollectionInfo colInfo = sh.findCollectionInfo(selectedRealCollections.get(0));
		ArrayList<String> commonFields = new ArrayList<String>();
		ArrayList<Field> fields = colInfo.getPresentationFields();
		for (int i = 0; i < fields.size(); i++) {
			commonFields.add(fields.get(i).getId());
		}

		ArrayList<String> tempFields = new ArrayList<String>();
		tempFields.addAll(commonFields);
		allFields.addAll(commonFields);

		for (int i = 0; i < commonFields.size(); i++) {
			for (int j = 1; j < selectedRealCollections.size(); j++) {
				colInfo = sh.findCollectionInfo(selectedRealCollections.get(j));
				fields = colInfo.getPresentationFields();
				ArrayList<String> prFields = new ArrayList<String>();
				for (int k = 0; k < fields.size(); k++) {
					prFields.add(fields.get(k).getId());
				}

				// allFields.addAll(prFields);
				for (int p = 0; p < prFields.size(); p++) {
					if (!allFields.contains(prFields.get(p))) {
						logger.debug("PrFields: Adding - " + prFields.get(p) + " to prFields");
						allFields.add(prFields.get(p));
					}
				}
				if (!prFields.contains(commonFields.get(i))) {
					int place = tempFields.indexOf(commonFields.get(i));
					if (place != -1) {
						tempFields.remove(place);
						logger.debug("Removing from tempFields - " + commonFields.get(i));
					}
				}
			}
		}

		commonFields = tempFields;
		if (commonFields == null || commonFields.size() == 0) {
			logger.debug("PrFields: No common fields - adding all fields");
			commonFields = allFields;
		}

		session.setAttribute(SessionConstants.presentableFields, commonFields);
		
		Boolean isDetailedResult = true;
		for (int n=0; n<commonFields.size(); n++) {
			String id = commonFields.get(n);
			String name = QueryHelper.GetFieldNameById(id);
			if (name.trim().equals(SessionConstants.SNIPPET_FIELD)){
				session.setAttribute(SessionConstants.SESSION_SNIPPET_ATTR, id);
				isDetailedResult = false;
			}
			else if (name.trim().equals(SessionConstants.TITLE_FIELD)){
				session.setAttribute(SessionConstants.SESSION_TITLE_ATTR, id);
				isDetailedResult = false;
			}
		}
		session.setAttribute(SessionConstants.sessionDetailedResult, isDetailedResult);
		
		return commonFields;
	}

	protected List<String> findPresentableFields (ASLSession session) throws Exception {
		logger.debug("PrFields: Inside method");
		// Retrieve Presentation Fields from profile
		HashMap<String, ArrayList<String>> collectionsFields = (HashMap<String, ArrayList<String>>) session.getAttribute("collectionsPresentableFields");
		SearchHelper sh = new SearchHelper(session);
		List<String> selectedRealCollections = getSelectedRealCollections(session);
		ArrayList<String> allFields = new ArrayList<String>();
		if (collectionsFields == null) {
			ArrayList<String> flds = (ArrayList<String>) session.getAttribute("presentationFields");
			// If it is null, then we have to read user's profile
			try {
				if (flds == null)
					collectionsFields = readUserProfile(session);
			} catch (Exception e) {
				logger.debug("Didn't manage to read user profile", e);
				throw e;
			}
			if (collectionsFields != null) {
				session.setAttribute(SessionConstants.allPresentableFields, collectionsFields);
			} else
				logger.debug("The collection's fields from the profile are null - about to ask for all");
		}
		if (collectionsFields != null && collectionsFields.size() == 0) {
			logger.debug("get all presentation fields");
			// don't get them from the profile - get all the presentation fields
			CollectionInfo colInfo = sh.findCollectionInfo(selectedRealCollections.get(0));
			ArrayList<String> commonFields = new ArrayList<String>();
			ArrayList<Field> fields = colInfo.getPresentationFields();
			for (int i = 0; i < fields.size(); i++) {
				commonFields.add(fields.get(i).getId());
			}

			ArrayList<String> tempFields = new ArrayList<String>();
			tempFields.addAll(commonFields);

			allFields.addAll(commonFields);
			logger.debug("PrFields: Initial num allFields: " + allFields.size());
			for (int i = 0; i < commonFields.size(); i++) {
				for (int j = 1; j < selectedRealCollections.size(); j++) {
					colInfo = sh.findCollectionInfo(selectedRealCollections.get(j));
					fields = colInfo.getPresentationFields();
					ArrayList<String> prFields = new ArrayList<String>();
					for (int k = 0; k < fields.size(); k++)
						prFields.add(fields.get(k).getId());

					// allFields.addAll(prFields);
					for (int p = 0; p < prFields.size(); p++) {
						if (!allFields.contains(prFields.get(p))) {
							logger.debug("PrFields: Adding to all fields: " + prFields.get(p));
							allFields.add(prFields.get(p));
						}
					}
					if (!prFields.contains(commonFields.get(i))) {
						int place = tempFields.indexOf(commonFields.get(i));
						if (place != -1) {
							logger.debug("PrFields: Removing from  tempfields: " + commonFields.get(i));
							tempFields.remove(place);
						}
					}
				}
			}

			commonFields = tempFields;
			if (commonFields == null || commonFields.size() == 0) {
				logger.debug("PrFields - No common fields Adding all fields");
				commonFields = allFields;
			}

			logger.debug("final num: " + commonFields.size());
			session.setAttribute(SessionConstants.presentableFields, commonFields);

			Boolean isDetailedResult = true;
			for (int n=0; n<commonFields.size(); n++) {
				String id = commonFields.get(n);
				String name = QueryHelper.GetFieldNameById(id);
				if (name.trim().equals(SessionConstants.SNIPPET_FIELD)){
					session.setAttribute(SessionConstants.SESSION_SNIPPET_ATTR, id);
					isDetailedResult = false;
				}
				else if (name.trim().equals(SessionConstants.TITLE_FIELD)){
					session.setAttribute(SessionConstants.SESSION_TITLE_ATTR, id);
					isDetailedResult = false;
				}
			}
			session.setAttribute(SessionConstants.sessionDetailedResult, isDetailedResult);


			return commonFields;
		}

		// Find common Presentation Fields for the selected collections

		if (selectedRealCollections != null && selectedRealCollections.size() != 0) {
			if(collectionsFields==null)
				logger.debug("collectionsFields is null");

			ArrayList<String> commonFields = new ArrayList<String>();
			// get all the presentable fields of the collection
			CollectionInfo colInfo = sh.findCollectionInfo(selectedRealCollections.get(0));
			ArrayList<Field> prFields = colInfo.getPresentationFields();
			for (int i = 0; i < prFields.size(); i++) {
				commonFields.add(prFields.get(i).getId());
			}

			allFields.addAll(commonFields);
			ArrayList<String> tempFields = new ArrayList<String>();
			for (int i = 0; i < commonFields.size(); i++) {
				tempFields.add(commonFields.get(i));
			}
			for (int i = 0; i < commonFields.size(); i++) {
				for (int j = 1; j < selectedRealCollections.size(); j++) {
					ArrayList<String> fields = collectionsFields.get(selectedRealCollections.get(j));
					if (fields == null) {
						fields = new ArrayList<String>();
						//CollectionInfo
						colInfo = sh.findCollectionInfo(selectedRealCollections.get(j));
						//ArrayList<Field> 
						prFields = colInfo.getPresentationFields();
						for (int k = 0; k < prFields.size(); k++) {
							fields.add(prFields.get(k).getId());
						}
					}
					// allFields.addAll(fields);
					for (int p = 0; p < fields.size(); p++) {
						if (!allFields.contains(fields.get(p))) {
							logger.debug("PrFields: Adding to all Fields: " + fields.get(p));
							allFields.add(fields.get(p));
						}
					}
					if (!fields.contains(commonFields.get(i))) {
						int place = tempFields.indexOf(commonFields.get(i));
						if (place != -1)
							tempFields.remove(place);
					}
				}
			}

			commonFields = tempFields;

			if (commonFields == null || commonFields.size() == 0) {
				commonFields = allFields;
				logger.debug("PrFields: No common fields found - adding all fields");
			}
			// if (commonFields == null || commonFields.size() == 0) {
			// logger.debug("No common presentation fields were found - asking for all the fields");
			// commonFields = new ArrayList<String>();
			// // insert all fields of the collections
			// for (int j = 0; j < selectedRealCollections.size(); j++) {
			// ArrayList<String> fields =
			// collectionsFields.get(selectedRealCollections.get(j));
			// if (fields != null && fields.size() != 0)
			// commonFields.addAll(fields);
			//
			// else {
			// CollectionInfo colInfo =
			// sh.findCollectionInfo(selectedRealCollections.get(j));
			// ArrayList<Field> prFields = colInfo.getPresentationFields();
			// for (int k = 0; k < prFields.size(); k++) {
			// commonFields.add(prFields.get(k).getId());
			// }
			// }
			// }
			// }
			session.setAttribute(SessionConstants.presentableFields, commonFields);

			Boolean isDetailedResult = true;
			for (int n=0; n<commonFields.size(); n++) {
				String id = commonFields.get(n);
				String name = QueryHelper.GetFieldNameById(id);
				if (name.trim().equals(SessionConstants.SNIPPET_FIELD)){
					session.setAttribute(SessionConstants.SESSION_SNIPPET_ATTR, id);
					isDetailedResult = false;
				}
				else if (name.trim().equals(SessionConstants.TITLE_FIELD)){
					session.setAttribute(SessionConstants.SESSION_TITLE_ATTR, id);
					isDetailedResult = false;
				}
			}
			session.setAttribute(SessionConstants.sessionDetailedResult, isDetailedResult);
			
			return commonFields;
		} else
			return new ArrayList<String>();

	}

	protected List<String> findPresentableFields_NEWONE (ASLSession session) throws Exception {
		logger.debug("Inside method getPresentableFields()");

		SearchHelper sh = new SearchHelper(session);

		/*
		//Get from session the previously decided presentable fields list (if exists)
		ArrayList<String> presentableFieldsSession = (ArrayList<String>) session.getAttribute(SessionConstants.presentableFields);
		if(presentableFieldsSession == null){
			logger.debug("No presentables found from previous calculations, ");
		}
		else{
			logger.debug("No presentables found from previous runs");
			return presentableFieldsSession;
		}
		 */

		//Get the user selected collections from the session
		List<String> selectedCollections = getSelectedRealCollections(session);

		ArrayList<String> common = new ArrayList<String>();
		HashMap<String, ArrayList<String>> collectionsPresentableFields = null;

		//Get from session all presentable fields for the collections
		collectionsPresentableFields = (HashMap<String, ArrayList<String>>) session.getAttribute(SessionConstants.allPresentableFields);

		if(collectionsPresentableFields == null){ //if not previously stored in session, get them from the session's user profile
			try{
				collectionsPresentableFields = readUserProfile(session);
			}catch (Exception e) {
				common = askForAllPresentables(selectedCollections, sh);
				throw e;
			}
		}
		if(collectionsPresentableFields != null){
			common = ArraysComparison.getCommonFields(collectionsPresentableFields, selectedCollections);
			logger.debug("NIK__common: " + common.toString());
		}
		else{ //if still null, then there's no hope that this will work, so get all and recompute
			logger.debug("NIK__The collection's fields from the profile are null - about to ask for all");
			common = askForAllPresentables(selectedCollections, sh);
		}
		//session.setAttribute(SessionConstants.presentableFields, ArraysComparison.getCommonFields(collectionsPresentableFieldsSession));
		session.setAttribute(SessionConstants.presentableFields, common); //this is with some extra checks
		return common;
	}

	protected ArrayList<String> askForAllPresentables (List<String> selectedCollections, SearchHelper sh) throws InitialBridgingNotCompleteException, InternalErrorException{
		HashMap<String, ArrayList<String>> collectionsPresentableFields = new HashMap<String, ArrayList<String>>();
		ArrayList<String> common = new ArrayList<String>();
		ArrayList<Field> fields = new ArrayList<Field>();
		//filling the array with the presentation fields
		for(int i=0;i<selectedCollections.size();i++){
			fields = sh.findCollectionInfo(selectedCollections.get(i)).getPresentationFields();
			ArrayList<String> fieldsID = new ArrayList<String>();
			for(int f=0;f<fields.size();f++)
				fieldsID.add(fields.get(f).getId());
			collectionsPresentableFields.put(selectedCollections.get(i), fieldsID);
		}
		logger.debug("NIK__Recomputed the collectionsPresentableFields"); 
		logger.debug("NIK__collectionsPresentableFieldsSession: " + collectionsPresentableFields.toString());
		//		common = ArraysComparison.getCommonFields(collectionsPresentableFieldsSession);
		common = ArraysComparison.getCommonFields(collectionsPresentableFields, selectedCollections); //previous, with some extra checks
		logger.debug("NIK__Common fields are: " + common.toString());
		return common;
	}



	protected GCQLNode getSortByPart(ASLSession session) {
		GCQLSortNode sortNode = new GCQLSortNode();
		ModifierSet modSet = new ModifierSet(sortBy);
		if (order == Order.ASC) {
			modSet.addModifier(Modifiers.SortAscending);
		} else
			modSet.addModifier(Modifiers.SortDescending);
		sortNode.addSortIndex(modSet);
		return sortNode;
	}

	protected GCQLNode getPresentationPart(ASLSession session) {

		GCQLProjectNode projectNode = new GCQLProjectNode();

		if (searchType.equals(SearchType.QuickSearch)) {
			// TODO: change it and put * in projection
			// get the id of the standard presentation field for quick search
			// List<gr.uoa.di.madgik.rr.element.search.Field> titleField = null;
			// try {
			// titleField =
			// gr.uoa.di.madgik.rr.element.search.Field.getFieldsWithName(false,
			// "title");
			// } catch (ResourceRegistryException e) {
			// // TODO Auto-generated catch block
			// logger.error("Exception:", e);
			// }
			// if (titleField != null && titleField.size() != 0) {
			// ModifierSet modSet = new ModifierSet(titleField.get(0).getID());
			// projectNode.addProjectIndex(modSet);
			// return projectNode;
			// } else {
			// logger.debug("quick: title field is null");
			// return null;
			// }

			ModifierSet modfSet = new ModifierSet("*");
			projectNode.addProjectIndex(modfSet);
			session.removeAttribute(SessionConstants.presentableFields);
			return projectNode;
		}
		if (searchType.equals(SearchType.GenericSearch)) {
			ModifierSet modfSet = new ModifierSet("*");
			projectNode.addProjectIndex(modfSet);
			session.removeAttribute(SessionConstants.presentableFields);
			return projectNode;
		}

		// Retrieve Presentation Fields
		ArrayList<String> fields = new ArrayList<String>();

		//no semantic enrichment (normal functionality) 
		if(!semanticEnrichment){  //SEMANTIC ENRICHMENT line mod
			//in case that there is a "S" field available, load the 
			//fields ArrayList just with project only this "S" field
			if(session.getAttribute(SessionConstants.SESSION_SNIPPET_ATTR) != null){
				logger.debug("snippet field is available, project only this");
				fields.add((String)session.getAttribute(SessionConstants.SESSION_SNIPPET_ATTR));
			}
			if(session.getAttribute(SessionConstants.SESSION_TITLE_ATTR) != null){
				logger.debug("title field is available, project this");
				fields.add((String)session.getAttribute(SessionConstants.SESSION_TITLE_ATTR));
			}
		}//SEMANTIC ENRICHMENT line mod
		//fields will be empty if semantic enrichment is not enabled or if there are no snippet fields
		if (fields.isEmpty()){
			logger.debug("use all the available presentable fields");
			if (selectedPresentationFields.size() == 0){
				logger.debug("profile presentation fields are empty, getting all the available");
				fields = (ArrayList<String>) session.getAttribute(SessionConstants.presentableFields);
			}
			else {
				logger.debug("using profile presentation fields");
				fields = selectedPresentationFields;
				selectedPresentationFields.clear();
			}
		}
	
		ArrayList<String> fieldStrings = new ArrayList<String>();
		logger.debug("Presentation num: " + fields.size());
		for (String field : fields) {
			ModifierSet modfSet = new ModifierSet(field);
			projectNode.addProjectIndex(modfSet);
			fieldStrings.add(field);
		}
		
		if (searchType.equals(SearchType.Browse)) {
			if (!fieldStrings.contains(browseBy)) {
				ModifierSet modfSet = new ModifierSet(browseBy);
				projectNode.addProjectIndex(modfSet);
				fields.add(browseBy);
				session.setAttribute(SessionConstants.presentableFields, fields);
			}
		}
		// else if (searchType.equals(SearchType.BrowseFields)) {
		// ModifierSet modfSet = new ModifierSet(browseBy);
		// projectNode.addProjectIndex(modfSet);
		// fields.clear();
		// fields.add(browseBy);
		// session.setAttribute(SessionConstants.presentableFields, fields);
		// }
		else if (searchType.equals(SearchType.AdvancedSearch)) {
			for (int i = 0; i < criteria.size(); i++) {
				if (!fieldStrings.contains(criteria.get(i).getSearchFieldId())) {
					ModifierSet modfSet = new ModifierSet(criteria.get(i).getSearchFieldId());
					projectNode.addProjectIndex(modfSet);
					fields.add(criteria.get(i).getSearchFieldId());
					session.setAttribute(SessionConstants.presentableFields, fields);
				}
			}
		}
		/*************************/
		// session.removeAttribute(SessionConstants.presentableFields);
		// session.setAttribute(SessionConstants.presentableFields, presentationIdsNames);
		if (fields.size() != 0)
			return projectNode;
		else
			return null;
	}

	protected GCQLNode getPresentationPartDistinct(ASLSession session) {

		GCQLProjectNode projectNode = new GCQLProjectNode();
		logger.debug("PresentationPart - browse distinct");

//		if (searchType.equals(SearchType.QuickSearch)) {
//			// TODO: change it and put * in projection
//			// get the id of the standard presentation field for quick search
//			// List<gr.uoa.di.madgik.rr.element.search.Field> titleField = null;
//			// try {
//			// titleField =
//			// gr.uoa.di.madgik.rr.element.search.Field.getFieldsWithName(false,
//			// "title");
//			// } catch (ResourceRegistryException e) {
//			// // TODO Auto-generated catch block
//			// logger.error("Exception:", e);
//			// }
//			// if (titleField != null && titleField.size() != 0) {
//			// ModifierSet modSet = new ModifierSet(titleField.get(0).getID());
//			// projectNode.addProjectIndex(modSet);
//			// return projectNode;
//			// } else {
//			// logger.debug("quick: title field is null");
//			// return null;
//			// }
//
//			ModifierSet modfSet = new ModifierSet("*");
//			projectNode.addProjectIndex(modfSet);
//			session.removeAttribute(SessionConstants.presentableFields);
//			return projectNode;
//		}
///************
		// Retrieve Presentation Fields
		ArrayList<String> fields = new ArrayList<String>();
		//in case that there is a "S" field available, load the fields ArrayList just with project only this "S" field
//		if(session.getAttribute(SessionConstants.SESSION_SNIPPET_ATTR) != null){
//			fields = new ArrayList<String>();
//			fields.add((String)session.getAttribute(SessionConstants.SESSION_SNIPPET_ATTR));
//		}
//		else
//			fields = (ArrayList<String>) session.getAttribute(SessionConstants.presentableFields);
///************
//		ArrayList<String> fieldStrings = new ArrayList<String>();
//		logger.debug("Presentation num: " + fields.size());
//		for (String field : fields) {
//			ModifierSet modfSet = new ModifierSet(field);
//			if (distinct) {
//				modfSet.addModifier("distinct");
//			}
//			projectNode.addProjectIndex(modfSet);
//			fieldStrings.add(field);
//		}
///************
//		if (searchType.equals(SearchType.Browse) || searchType.equals(SearchType.BrowseFields)) {
			logger.debug("PresentationPart browse");
//			if (!fieldStrings.contains(browseBy)) {
//				ModifierSet modfSet = new ModifierSet(browseBy);
//			//	if (distinct) {
//					modfSet.addModifier("distinct");
//					fields.clear();
//					logger.debug("clearing fields - distinct");
//			//	}
//				logger.debug("Not clearing fields - distinct");
//				projectNode.addProjectIndex(modfSet);
//				fields.add(browseBy);
//				session.setAttribute(SessionConstants.presentableFields, fields);
//			} else {
		//		if (distinct) {
					ModifierSet modfSet = new ModifierSet(browseBy);
					modfSet.addModifier("distinct");
//					fields.clear();
					fields.add(browseBy);
					projectNode.addProjectIndex(modfSet);
					session.setAttribute(SessionConstants.presentableFields, fields);
	//			}
//			}
//		} else if (searchType.equals(SearchType.AdvancedSearch)) {
//			for (int i = 0; i < criteria.size(); i++) {
//				if (!fieldStrings.contains(criteria.get(i).getSearchFieldId())) {
//					ModifierSet modfSet = new ModifierSet(criteria.get(i).getSearchFieldId());
//					projectNode.addProjectIndex(modfSet);
//					fields.add(criteria.get(i).getSearchFieldId());
//					session.setAttribute(SessionConstants.presentableFields, fields);
//				}
//			}
//		}
		/*************************/
		// session.removeAttribute(SessionConstants.presentableFields);
		// session.setAttribute(SessionConstants.presentableFields, presentationIdsNames);
		if (fields.size() != 0)
			return projectNode;
		else
			return null;
	}

	private HashMap<String, ArrayList<String>> readUserProfile(ASLSession session) throws ReadingUserProfileException {
		// Reading the profile...
		try {

			logger.debug("Inside readUserProfile");
			UserProfile userProf = new UserProfile(session);
			HashMap<String, ArrayList<String>> userPresentationFields = userProf.getPresentationFields(session.getUsername());

			if (userPresentationFields != null) {
				session.setAttribute(SessionConstants.allPresentableFields, userPresentationFields);
				logger.debug("size map: " + userPresentationFields.size());
			}
			return userPresentationFields;
		} catch (Exception e) {
			// logger.error("Exception:", e);
			// return null;
			throw new ReadingUserProfileException(e);
		}
	}

	public String getSortBy() {
		return sortBy;
	}

	public void setSortBy(String sortBy) {
		logger.debug("Setting sort by");
		this.sortBy = sortBy;
	}

	public Order getOrder() {
		return order;
	}

	public void setOrder(Order order) {
		this.order = order;
	}

	/**
	 * @param session
	 *            the D4Science session to be used
	 * @return a consumer to retrieve the search results as pages
	 */
	public ResultSetConsumerI getSearchResults(ASLSession session) {
		return searchRSC;
	}

	public List<String> getSelectedCollectionsNames(ASLSession session) throws InitialBridgingNotCompleteException, InternalErrorException {

		List<String> realCollections = getSelectedRealCollections(session);
		List<String> collectionNames = new ArrayList<String>();
		SearchHelper sh = new SearchHelper(session);

		for (String colId : realCollections) {
			CollectionInfo colInf = sh.findCollectionInfo(colId);
			if (colInf != null) {
				collectionNames.add(colInf.getName());
			}
		}

		return collectionNames;
	}

	protected EndpointReference[] findSearchMasterEPR(ASLSession session) throws URIRetrievalFromISCacheException {
		EndpointReference[] searchMasters = null;
		logger.debug("Looking for a Search Master epr");
		try {
			searchMasters = RIsManager.getInstance().getISCache(session.getScope()).getEPRsFor("Search", "SearchSystemService", SrvType.SIMPLE.name());
		} catch (Exception e) {
			logger.error(e.getMessage());
			throw new URIRetrievalFromISCacheException(e);
		}
		return searchMasters;
	}

	protected String submitSearch(String query, String searchMasterURI, ASLSession session) throws MalformedURIException, SearchSystemPortRetrievalException,
	QuerySubmissionSearchException {

		EndpointReferenceType serviceEPR = new EndpointReferenceType();
		serviceEPR.setAddress(new Address(searchMasterURI));
		SearchMasterServiceAddressingLocator serviceLocator = new SearchMasterServiceAddressingLocator();
		SearchSystemServicePortType searchMaster;
		GCQLQueryTreeManager.parseGCQLString(query);
		try {
			searchMaster = serviceLocator.getSearchSystemServicePortTypePort(serviceEPR);
		} catch (ServiceException e) {
			logger.error("Error while retrieving Search Master epr.", e);
			throw new SearchSystemPortRetrievalException(e);
		}
		try {
			searchMaster = (SearchSystemServicePortType) ServiceContextManager.applySecurity(searchMaster, session);
		} catch (Exception e) {
			logger.error(e.getMessage());
		}
		logger.debug("Query will be submitted to: " + searchMasterURI);
		SearchResponse ret = null;
		try {
			ret = searchMaster.search(query);
		} catch (GCUBERetryEquivalentFault e) {
			logger.error("Error while submitting search query", e);
			throw new QuerySubmissionSearchException(e);
		} catch (RemoteException e) {
			logger.error("Error while submitting search query", e);
			throw new QuerySubmissionSearchException(e);
		}
		logger.debug("The rs epr is: " + ret.getResultSetEpr());
		return ret.getResultSetEpr();
	}

	public ArrayList<String> getSearchQueryTerms() {
		return this.searchQueryTerms;
	}

}
