package org.gcube.application.framework.vremanagement.vremanagement;

import java.io.File;
import java.util.List;

import org.gcube.common.core.informationsystem.client.RPDocument;
import org.gcube.common.core.informationsystem.client.XMLResult;
import org.gcube.common.core.resources.GCUBECollection;
import org.gcube.common.core.resources.GCUBEMCollection;
import org.gcube.common.core.scope.GCUBEScope;

/**
 * @author valia
 *
 */
public interface ISInfoI {
	
	/**
	 * @param query an XQuery to be submitted on IS
	 * @return a list of XMLResults that represent resources form IS (like RIs, Generic Resources, Collections, etc)
	 */
	public List<XMLResult> queryIS(String query);
	
	/**
	 * @param type the of the WSs to be retrieved
	 * @return a list of RPDocuments
	 */
	public List<RPDocument> getWS(String type);
	
	/**
	 * Adds a GHN to the active VRE
	 * @param url the GHN url
	 */
	public void addGHNToScope(String url); 
	
	/**
	 * Adds a service to the active VRE
	 * @param url the Running Instance url
	 * @param className the name of the class where the RI will belong 
	 * @param name the name of teh service it provides
	 */
	public void addRIToScope(String url, String className, String name);
	
	/**
	 * @param namePort GHN name:port
	 * @return true if GHN exists, otherwise false
	 */
	public boolean existsGHN(String namePort);


	/**
	 * @param id the id of the external running instance to be removed
	 */
	public void removeExternalRIToVRE(String id);
	
	/**
	 * @param file the file that contains the external running instance to be added
	 */
	public void addExternalRIToVRE(File file);
	
	/**
	 * @param url server:port of the GHN to be removed
	 */
	public void removeGHNToScope(String url);
	
	/**
	 * @param scope the scope of the collections.
	 * @return a list of collections profile.
	 * @throws Exception
	 */
	 public List<GCUBECollection> getCollections(GCUBEScope scope)throws Exception;
	 
	 /**
	   * @param scope the scope of the metadata collections.
	   * @param collectionID the associated collection.
	   * @return a list of metadata collections profile.
	   * @throws Exception
	   */
	   public List<GCUBEMCollection> getMCollections(GCUBEScope scope, String collectionID)throws Exception;
	   
	   
	   /**
	    * @param scope the indices scope.
	    * @param mcollectionID the metadata collection id.
	    * @return a list of Resource document.
	    * @throws Exception
	   */
	   public List<RPDocument> getXMLIndices(GCUBEScope scope, String mcollectionID) throws Exception;
	   
	   
	   
	   /**
		* Return all indices associated with a given metadata collection.
		* @param scope the indices scope.
		* @param mcollectionID the metadata collection id.
		* @return a list of Resource document.
		* @throws Exception
		*/
		public List<RPDocument> getIndices(GCUBEScope scope, String mcollectionID) throws Exception;
		
		
		
		/**
		 * @param scope the indices scope.
		 * @param collectionID the collection id.
		 * @return a list of Resource document.
		 * @throws Exception
		 */
		public List<RPDocument> getCollectionIndices(GCUBEScope scope, String collectionID) throws Exception;
		
		
		
		/**
	     * @param scope the collection scope.
	     * @param collectionID the collection id.
	     * @return a collection profile.
	     * @throws Exception
	    */
	     public GCUBECollection getCollection(GCUBEScope scope, String collectionID) throws Exception;
}

