package org.gcube.application.framework.vremanagement.vremanagement.impl;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;

import javax.xml.rpc.ServiceException;

import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.EndpointReference;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.application.framework.core.cache.RIsManager;
import org.gcube.application.framework.core.security.ServiceContextManager;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.vremanagement.vremanagement.VREGeneratorInterface;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.types.VOID;
import org.gcube.common.core.utils.logging.GCUBEClientLog;
import org.gcube.informationsystem.cache.SrvType;
import org.gcube.vremanagement.vremodeler.stubs.FunctionalityList;
import org.gcube.vremanagement.vremodeler.stubs.FunctionalityNodes;
import org.gcube.vremanagement.vremodeler.stubs.GHNArray;
import org.gcube.vremanagement.vremodeler.stubs.GHNList;
import org.gcube.vremanagement.vremodeler.stubs.GHNType;
import org.gcube.vremanagement.vremodeler.stubs.GHNsPerFunctionality;
import org.gcube.vremanagement.vremodeler.stubs.ModelerFactoryPortType;
import org.gcube.vremanagement.vremodeler.stubs.ModelerServicePortType;
import org.gcube.vremanagement.vremodeler.stubs.ReportList;
import org.gcube.vremanagement.vremodeler.stubs.RunningInstanceMessage;
import org.gcube.vremanagement.vremodeler.stubs.SelectedResourceDescriptionType;
import org.gcube.vremanagement.vremodeler.stubs.SetFunctionality;
import org.gcube.vremanagement.vremodeler.stubs.VREDescription;
import org.gcube.vremanagement.vremodeler.stubs.service.ModelerFactoryServiceAddressingLocator;
import org.gcube.vremanagement.vremodeler.stubs.service.ModelerServiceAddressingLocator;


/**
 * 
 * @author Massimiliano Assante - ISTI-CNR
 *
 */
public class VREGeneratorEvo implements VREGeneratorInterface {
	
	GCUBEClientLog log = new GCUBEClientLog("ASL_VRE");
	
	String scope;
	ASLSession session;
	ModelerServicePortType modelPortType;
	
	private final static String MODELERS_NO = "MODELERS_NO";

	protected static AtomicInteger vreId = new AtomicInteger(0);

	/**
	 * @param session the d4s session
	 * @param epr the epr
	 */
	public VREGeneratorEvo(ASLSession session, String id) {
		this(session);
		
		EndpointReferenceType epr = getEprGivenID(id);
		log.info("VREGeneratorEvo called on VRE id (epr)" + epr + " scope: " + session.getScope().toString());
		this.scope = session.getScopeName();
		this.session = session;
		modelPortType = applySecurityEPR(epr);

	}

	public boolean isVreModelerServiceUp() {
		return Integer.parseInt(session.getAttribute(MODELERS_NO).toString()) > 0;
	}
	
	/**
	 * @param session the d4s session
	 */
	public VREGeneratorEvo(ASLSession session) {
		super();
		log.info("VREGeneratorEvo scope: " + session.getScope().toString());
		this.scope = session.getScopeName();
		this.session = session;
		modelPortType = null;
		getModelPortType();
	}
	/**
	 * @param session the d4s session
	 * @return the VRE names
	 * 
	 */
	public ReportList getAllVREs(ASLSession session) {
		EndpointReferenceType serviceEPR = new EndpointReferenceType();
		ModelerFactoryPortType mFPType = null;
		ModelerFactoryServiceAddressingLocator mFSLocator = new ModelerFactoryServiceAddressingLocator();
		EndpointReference[] modelerURIs;
		try {
			modelerURIs =  RIsManager.getInstance().getISCache(GCUBEScope.getScope(scope)).getEPRsFor("VREManagement", "VREModeler", SrvType.FACTORY.name());
		} catch (Exception e1) {
			e1.printStackTrace();
			return null;
		}
		for (int i = 0; i < modelerURIs.length; i++) {
			try {
				System.out.println("getModelFactoryPortTypePort(epr)");
				session.setScope(scope);
				serviceEPR.setAddress(new Address(modelerURIs[vreId.getAndIncrement() % modelerURIs.length].getAddress().toString()));
				mFPType = (ModelerFactoryPortType) ServiceContextManager.applySecurity(mFSLocator.getModelerFactoryPortTypePort(serviceEPR), session);
				return mFPType.getAllVREs(new VOID());

			} catch (ServiceException e) {
				e.printStackTrace();
			} catch (RemoteException e) {
				e.printStackTrace();
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		return null;
	}

	/**
	 * @param session the d4s session
	 * @param id the id of the VRE to be removed
	 */
	public void removeVRE(ASLSession session, String id) {


		EndpointReferenceType serviceEPR = new EndpointReferenceType();
		ModelerFactoryPortType mFPType = null;
		ModelerFactoryServiceAddressingLocator mFSLocator = new ModelerFactoryServiceAddressingLocator();
		EndpointReference[] modelerURIs;
		try {
			modelerURIs = RIsManager.getInstance().getISCache(GCUBEScope.getScope(scope)).getEPRsFor("VREManagement", "VREModeler", SrvType.FACTORY.name());
		} catch (Exception e1) {
			e1.printStackTrace();
			return;
		}
		for (int i = 0; i < modelerURIs.length; i++) {
			try {
				System.out.println("getModelFactoryPortTypePort(epr)");

				serviceEPR.setAddress(new Address(modelerURIs[vreId.getAndIncrement() % modelerURIs.length].getAddress().toString()));
				session.setScope(scope);
				mFPType = (ModelerFactoryPortType) ServiceContextManager.applySecurity(mFSLocator.getModelerFactoryPortTypePort(serviceEPR), session);
				
				System.out.println("ID RECEIVED TO REMOVE:" + id);

				mFPType.removeVRE(id);
				break;

			} catch (ServiceException e) {
				e.printStackTrace();
			} catch (RemoteException e) {
				e.printStackTrace();
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}
	/**
	 * 
	 * @param epr
	 * @return
	 */
	protected ModelerServicePortType applySecurityEPR(EndpointReferenceType epr) {
		try {
			ModelerServiceAddressingLocator mSALocator = new ModelerServiceAddressingLocator();
			session.setScope(scope);
			modelPortType = ServiceContextManager.applySecurity(mSALocator.getModelerServicePortTypePort(epr),session);
			return modelPortType;
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}

	}
	@Override
	public String checkVREStatus() throws RemoteException {
		return modelPortType.checkStatus(new VOID());
	}

	/**
	 * 
	 */
	@Override
	public void deployVRE() throws RemoteException {
		modelPortType.deployVRE(new VOID());

	}

	public String[] getExistingNamesVREs() {
		// TODO Auto-generated method stub
		return null;
	}
	
	public FunctionalityNodes getSelectedFunctionality() throws Exception {
		FunctionalityNodes list = modelPortType.getFunctionalityNodes(new VOID());
		return list;
	}

	@Override
	public List<GHNType> getGHNs() throws RemoteException {

		log.debug("Asking gHN list to service");

		List<GHNType> toReturn = new ArrayList<GHNType>();
		FunctionalityNodes list = modelPortType.getFunctionalityNodes(new VOID());
		
		GHNList ghns = list.getSelectableGHNs(); //selezionabili per le missing func.
		GHNType[] types =  ghns.getList();
		
		for (int i = 0; i < types.length; i++) {
			try {
				log.debug("returned GHN: " + types[i].getHost());
				toReturn.add(new GHNType(types[i].getHost(), types[i].getId(), types[i].getMemory(), types[i].getRelatedRIs(), types[i].isSecurityEnabled(),
						types[i].isSelected(), types[i].getSite()));

			} catch (NullPointerException e) {
				e.printStackTrace();
				return toReturn;
			}
		}
		return toReturn;
	}
	
	@Override
	public GHNsPerFunctionality[] getGHNsPerFunctionality() throws RemoteException {
		FunctionalityNodes list = modelPortType.getFunctionalityNodes(new VOID());
		return list.getFunctionalities();
		
	}
//	RunningInstanceMessage[] ris = list.getFunctionalities()[1].getMissingServices(); //ci sono n RunningInstances (Service) Mancanti
//	ris[0].
//	list.getFunctionalities()[1].getGhns(); //verranno aggiunti per la funzionalit
	

	@Override
	public void setFunctionality(int[] funcIds, SelectedResourceDescriptionType[] selResDesc) throws RemoteException {
		SetFunctionality sf = new SetFunctionality(funcIds, selResDesc);
		modelPortType.setFunctionality(sf);
	}

	@Override
	public FunctionalityList getFunctionality() throws Exception {
		FunctionalityList list = modelPortType.getFunctionality(new VOID());
		return list;
	}

	public String getMetadataRelatedToCollection() throws RemoteException {
		return null;
	}

	public String getQuality() throws RemoteException {
		// TODO Auto-generated method stub
		return null;
	}


	/**
	 * first call
	 */
	@Override
	public VREDescription getVREModel() throws RemoteException {
		VREDescription desc = modelPortType.getDescription(new VOID());
		
		return desc;
	}

	
	@Override
	public void setGHNs(String[] selectedGHNIds) throws RemoteException {
		modelPortType.setUseCloud(false);
		GHNArray ghnArray = new GHNArray(selectedGHNIds);
		modelPortType.setGHNs(ghnArray);		
	}

	@Override
	public void setVREModel(String VREName, String VREDescription,
			String VREDesigner, String VREManager, long startTime, long endTime)
	throws RemoteException {
		VREDescription vreDesc = new VREDescription();
		vreDesc.setDescription(VREDescription);
		vreDesc.setDesigner(VREDesigner);
		vreDesc.setManager(VREManager);
		vreDesc.setName(VREName);
		Calendar start = Calendar.getInstance();
		start.setTimeInMillis(startTime);
		vreDesc.setStartTime(start);
		Calendar end = Calendar.getInstance();
		end.setTimeInMillis(endTime);
		vreDesc.setEndTime(end);
		
		log.debug("StartTime = " + start.getTime());
		log.debug("EndTime = " + end.getTime());
		
		modelPortType.setDescription(vreDesc);
	}

	public void setVREtoPendingState() throws RemoteException {
		modelPortType.setVREtoPendingState(new VOID());
	}

	/**
	 * 
	 */
	private synchronized void getModelPortType() {
	
		EndpointReferenceType serviceEPR = new EndpointReferenceType();
		ModelerFactoryPortType mFPType = null;

		EndpointReferenceType VREEndpointReferenceType;
		if (modelPortType == null) {

			log.warn("VREEndpointReferenceType is null");
			ModelerFactoryServiceAddressingLocator mFSLocator = new ModelerFactoryServiceAddressingLocator();

			EndpointReference[] modelerURIs;
			try {

				modelerURIs = RIsManager.getInstance().getISCache(GCUBEScope.getScope(scope)).getEPRsFor("VREManagement", "VREModeler", SrvType.FACTORY.name());


			} catch (Exception e1) {
				e1.printStackTrace();
				return;
			}
			log.debug("vre modelers: " + modelerURIs.length);
			session.setAttribute(MODELERS_NO, modelerURIs.length);
			for (int i = 0; i < modelerURIs.length; i++) {
				try {
					System.out.println("getModelFactoryPortTypePort(epr)");

					serviceEPR.setAddress(new Address(modelerURIs[vreId.getAndIncrement() % modelerURIs.length].getAddress().toString()));
					session.setScope(scope);
					mFPType = ServiceContextManager.applySecurity(mFSLocator.getModelerFactoryPortTypePort(serviceEPR), session);
					VREEndpointReferenceType = mFPType.createResource(new VOID());
					mFPType.getAllVREs(new VOID());
					ModelerServiceAddressingLocator mSALocator = new ModelerServiceAddressingLocator();
					session.setScope(scope);
					modelPortType = ServiceContextManager.applySecurity(mSALocator.getModelerServicePortTypePort(VREEndpointReferenceType), session);
					// Attaching Credential to port type
					System.out.println("Attaching Credential to port type");
					break;
				} catch (ServiceException e) {
					e.printStackTrace();
				} catch (RemoteException e) {
					e.printStackTrace();
				} catch (Exception e) {
					e.printStackTrace();
					new Random(System.currentTimeMillis()).nextInt(modelerURIs.length);
				}
			}
		} else 
			log.debug("modelPortType!=null");
		
	}

	/** {@inheritDoc}*/
	public String getVREepr() {
		return modelPortType.toString();
	}

	/**
	 * return the per given an id
	 * @param id
	 * @return
	 */
	private EndpointReferenceType getEprGivenID(String id) {
		EndpointReferenceType serviceEPR = new EndpointReferenceType();
		ModelerFactoryPortType mFPType = null;
		ModelerFactoryServiceAddressingLocator mFSLocator = new ModelerFactoryServiceAddressingLocator();
		EndpointReference[] modelerURIs;
		try {
			session.setScope(scope);
			modelerURIs =  RIsManager.getInstance().getISCache(session.getScope()).getEPRsFor("VREManagement", "VREModeler", SrvType.FACTORY.name());
		} catch (Exception e1) {
			e1.printStackTrace();
			return null;
		}
		for (int i = 0; i < modelerURIs.length; i++) {
			try {
				log.debug("getModelFactoryPortTypePort(epr)");

				serviceEPR.setAddress(new Address(modelerURIs[vreId.getAndIncrement() % modelerURIs.length].getAddress().toString()));
				session.setScope(scope);
				mFPType = (ModelerFactoryPortType) ServiceContextManager.applySecurity(mFSLocator.getModelerFactoryPortTypePort(serviceEPR), session);
				return mFPType.getEPRbyId(id);

			} catch (ServiceException e) {
				e.printStackTrace();
			} catch (RemoteException e) {
				e.printStackTrace();
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		return null;
	}

	public boolean isCloudAvailable() {
		//TODO: check actual availability
		return true;
	}


	/**
	 * 
	 */
	public boolean isCloudSelected() {
		System.out.println("isCloudSelected()");
		boolean toReturn = false;
		try {
			toReturn = modelPortType.isUseCloud(new VOID());
		} catch (RemoteException e) {
			e.printStackTrace();
			return false;
		}
		return toReturn;
	}


	public boolean setCloudDeploy(int virtualMachines) {
		try {
			log.debug("setUseCloud(true)");
			modelPortType.setUseCloud(true);
			log.debug("setCloudVMs #: " + virtualMachines);
			modelPortType.setCloudVMs(virtualMachines);
		} catch (RemoteException e) {
			e.printStackTrace();
			return false;
		}
		return true;
	}

	/**
	 * 	
	 */
	public int getCloudVMSelected() {
		int toReturn = -1;
		try {
			toReturn = modelPortType.getCloudVMs(new VOID());
		} catch (RemoteException e) {
			e.printStackTrace();
			return toReturn;
		}
		return toReturn;
	}



}
