/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.authorizationservice.persistence;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.NoResultException;
import javax.persistence.TypedQuery;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.policies.Policy;
import org.gcube.common.authorization.library.policies.PolicyType;
import org.gcube.common.authorization.library.policies.Service2ServicePolicy;
import org.gcube.common.authorization.library.policies.User2ServicePolicy;
import org.gcube.common.authorization.library.provider.ClientInfo;
import org.gcube.common.authorization.library.provider.ContainerInfo;
import org.gcube.common.authorization.library.provider.ExternalServiceInfo;
import org.gcube.common.authorization.library.provider.ServiceIdentifier;
import org.gcube.common.authorization.library.provider.ServiceInfo;
import org.gcube.common.authorization.library.provider.UserInfo;
import org.gcube.common.authorizationservice.persistence.entities.AuthorizationEntity;
import org.gcube.common.authorizationservice.persistence.entities.AuthorizationId;
import org.gcube.common.authorizationservice.persistence.entities.ExternalServiceAuthorizationEntity;
import org.gcube.common.authorizationservice.persistence.entities.NodeAuthorizationEntity;
import org.gcube.common.authorizationservice.persistence.entities.PolicyEntity;
import org.gcube.common.authorizationservice.persistence.entities.ServiceAuthorizationEntity;
import org.gcube.common.authorizationservice.persistence.entities.ServicePolicyEntity;
import org.gcube.common.authorizationservice.persistence.entities.UserAuthorizationEntity;
import org.gcube.common.authorizationservice.persistence.entities.UserPolicyEntity;
import org.gcube.common.authorizationservice.util.TokenPersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RelationDBPersistence
implements TokenPersistence {
    private static final Logger log = LoggerFactory.getLogger(RelationDBPersistence.class);
    @Inject
    EntityManagerFactory emFactory;

    public void setEntitymanagerFactory(EntityManagerFactory emf) {
        this.emFactory = emf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthorizationEntry getAuthorizationEntry(String token) {
        try (EntityManager em = this.emFactory.createEntityManager();){
            AuthorizationEntity authEntity;
            TypedQuery query = em.createNamedQuery("Authz.get", AuthorizationEntity.class);
            query.setParameter("token", (Object)token);
            try {
                em.getTransaction().begin();
                authEntity = (AuthorizationEntity)query.getSingleResult();
                authEntity.setLastTimeUsed(Calendar.getInstance());
                em.merge((Object)authEntity);
                em.getTransaction().commit();
            }
            catch (NoResultException e) {
                log.warn("no result found for token {}", (Object)token);
                AuthorizationEntry authorizationEntry = null;
                em.close();
                return authorizationEntry;
            }
            if (authEntity.getEntryType().equals("ServiceInfo")) {
                ServiceAuthorizationEntity sAuth = (ServiceAuthorizationEntity)authEntity;
                AuthorizationEntry authorizationEntry = new AuthorizationEntry(sAuth.getInfo(), sAuth.getContext(), this.retrievePolicies(sAuth, em), sAuth.getQualifier());
                return authorizationEntry;
            }
            if (authEntity.getEntryType().equals("UserInfo")) {
                UserAuthorizationEntity uAuth = (UserAuthorizationEntity)authEntity;
                AuthorizationEntry authorizationEntry = new AuthorizationEntry(uAuth.getInfo(), uAuth.getContext(), this.retrievePolicies(uAuth, em), uAuth.getQualifier());
                return authorizationEntry;
            }
            if (authEntity.getEntryType().equals("ExternalServiceInfo")) {
                ExternalServiceAuthorizationEntity uAuth = (ExternalServiceAuthorizationEntity)authEntity;
                AuthorizationEntry authorizationEntry = new AuthorizationEntry(uAuth.getInfo(), uAuth.getContext(), new ArrayList(), uAuth.getQualifier());
                return authorizationEntry;
            }
            if (authEntity.getEntryType().equals("ContainerServiceInfo")) {
                NodeAuthorizationEntity uAuth = (NodeAuthorizationEntity)authEntity;
                AuthorizationEntry authorizationEntry = new AuthorizationEntry(uAuth.getInfo(), uAuth.getContext(), new ArrayList(), uAuth.getQualifier());
                return authorizationEntry;
            }
            try {
                throw new IllegalArgumentException("entryType cannot be mapped");
            }
            catch (Throwable t) {
                log.error("error retrieving authorization entry", t);
                AuthorizationEntry authorizationEntry = null;
                return authorizationEntry;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getExistingToken(String clientId, String context, String qualifier) {
        try (EntityManager em = this.emFactory.createEntityManager();){
            AuthorizationEntity authEntity = (AuthorizationEntity)em.find(AuthorizationEntity.class, (Object)new AuthorizationId(context, clientId, qualifier));
            if (authEntity != null) {
                String string = authEntity.getToken();
                return string;
            }
            String string = null;
            return string;
        }
    }

    public void saveAuthorizationEntry(String token, String context, ClientInfo info, String tokenQualifier, String generatedBy) {
        Object authEntity = null;
        authEntity = info instanceof UserInfo ? new UserAuthorizationEntity(token, context, tokenQualifier, (UserInfo)info) : (info instanceof ServiceInfo ? new ServiceAuthorizationEntity(token, context, tokenQualifier, (ServiceInfo)info, generatedBy) : (info instanceof ExternalServiceInfo ? new ExternalServiceAuthorizationEntity(token, context, tokenQualifier, (ExternalServiceInfo)info, generatedBy) : new NodeAuthorizationEntity(token, context, tokenQualifier, (ContainerInfo)info, generatedBy)));
        try (EntityManager em = this.emFactory.createEntityManager();){
            em.getTransaction().begin();
            em.persist(authEntity);
            em.getTransaction().commit();
        }
    }

    public void addPolicies(List<Policy> polices) {
        EntityManager em = this.emFactory.createEntityManager();
        try {
            em.getTransaction().begin();
            for (Policy policy : polices) {
                if (policy.getPolicyType() == PolicyType.SERVICE) {
                    Service2ServicePolicy s2sPolicy = (Service2ServicePolicy)policy;
                    em.persist((Object)new ServicePolicyEntity(s2sPolicy.getContext(), s2sPolicy.getServiceAccess(), s2sPolicy.getClient(), s2sPolicy.getMode()));
                    continue;
                }
                User2ServicePolicy u2sPolicy = (User2ServicePolicy)policy;
                em.persist((Object)new UserPolicyEntity(u2sPolicy.getContext(), u2sPolicy.getServiceAccess(), u2sPolicy.getEntity(), u2sPolicy.getMode()));
            }
            em.getTransaction().commit();
        }
        catch (Exception e) {
            em.close();
        }
    }

    public void removePolicy(long policyId) {
        EntityManager em = this.emFactory.createEntityManager();
        try {
            em.getTransaction().begin();
            PolicyEntity entity = (PolicyEntity)em.find(PolicyEntity.class, (Object)policyId);
            if (entity != null) {
                em.remove((Object)entity);
            } else {
                log.warn("policy with id {} not found", (Object)policyId);
            }
            em.getTransaction().commit();
        }
        catch (Exception e) {
            log.error("error removing policy with id {}", (Object)policyId);
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Policy> getPolices(String context) {
        ArrayList<Policy> policiesToReturn = new ArrayList<Policy>();
        try (EntityManager em = this.emFactory.createEntityManager();){
            TypedQuery query = em.createNamedQuery("Policy.all", PolicyEntity.class);
            query.setParameter("context", (Object)context);
            for (PolicyEntity pEntity : query.getResultList()) {
                Object policy = pEntity.getPolicyType().equals("ServicePolicy") ? new Service2ServicePolicy(context, pEntity.getServiceAccess(), ((ServicePolicyEntity)pEntity).getClientAccess(), pEntity.getAction()) : new User2ServicePolicy(context, pEntity.getServiceAccess(), ((UserPolicyEntity)pEntity).getUser(), pEntity.getAction());
                policy.setId(pEntity.getId());
                policy.setCreationTime(pEntity.getCreationTime());
                policy.setLastUpdateTime(pEntity.getLastUpdateTime());
                policiesToReturn.add((Policy)policy);
            }
        }
        return policiesToReturn;
    }

    public List<Policy> getPolicesByType(String context, PolicyType type) {
        return null;
    }

    public List<Policy> getPolicesByTypeAndClientId(String context, PolicyType type, String clientId) {
        return null;
    }

    private List<Policy> retrievePolicies(UserAuthorizationEntity uAuth, EntityManager em) {
        ArrayList<Policy> policies = new ArrayList<Policy>();
        TypedQuery queryU = em.createNamedQuery("UserPolicy.get", UserPolicyEntity.class);
        queryU.setParameter("context", (Object)uAuth.getContext());
        queryU.setParameter("user", (Object)uAuth.getInfo().getId());
        if (!uAuth.getInfo().getRoles().isEmpty()) {
            queryU.setParameter("rolesList", (Object)uAuth.getInfo().getRoles());
        } else {
            queryU.setParameter("rolesList", Collections.singleton(""));
        }
        List userPolicies = queryU.getResultList();
        for (UserPolicyEntity uPolicy : userPolicies) {
            User2ServicePolicy u2sP = new User2ServicePolicy(uPolicy.getContext(), uPolicy.getServiceAccess(), uPolicy.getUser(), uPolicy.getAction());
            u2sP.setCreationTime(uPolicy.getCreationTime());
            u2sP.setLastUpdateTime(uPolicy.getLastUpdateTime());
            policies.add((Policy)u2sP);
        }
        log.debug("user policies found are {}", policies);
        return policies;
    }

    private List<Policy> retrievePolicies(ServiceAuthorizationEntity sAuth, EntityManager em) {
        ArrayList<Policy> policies = new ArrayList<Policy>();
        ServiceIdentifier sIdentifier = ((ServiceInfo)sAuth.getInfo()).getServiceIdentifier();
        TypedQuery queryS = em.createNamedQuery("ServicePolicy.get", ServicePolicyEntity.class);
        queryS.setParameter("context", (Object)sAuth.getContext());
        queryS.setParameter("serviceClass", (Object)sIdentifier.getServiceClass());
        queryS.setParameter("serviceName", (Object)sIdentifier.getServiceName());
        queryS.setParameter("identifier", (Object)sIdentifier.getServiceId());
        List servicePolicies = queryS.getResultList();
        for (ServicePolicyEntity sPolicy : servicePolicies) {
            Service2ServicePolicy s2sP = new Service2ServicePolicy(sPolicy.getContext(), sPolicy.getServiceAccess(), sPolicy.getClientAccess(), sPolicy.getAction());
            s2sP.setCreationTime(sPolicy.getCreationTime());
            s2sP.setLastUpdateTime(sPolicy.getLastUpdateTime());
            policies.add((Policy)s2sP);
        }
        log.debug("service policies found are {}", policies);
        return policies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getExistingApiKeys(String clientId, String context) {
        try (EntityManager em = this.emFactory.createEntityManager();){
            TypedQuery queryS = em.createNamedQuery("Authz.getQualifiers", AuthorizationEntity.class);
            queryS.setParameter("context", (Object)context);
            queryS.setParameter("clientId", (Object)clientId);
            List apikeys = queryS.getResultList();
            HashMap<String, String> qualifiers = new HashMap<String, String>();
            for (AuthorizationEntity apikey : apikeys) {
                qualifiers.put(apikey.getQualifier(), apikey.getToken());
            }
            HashMap<String, String> hashMap = qualifiers;
            return hashMap;
        }
    }

    public void removeApiKey(String token) {
        EntityManager em = this.emFactory.createEntityManager();
        try {
            em.getTransaction().begin();
            TypedQuery queryS = em.createNamedQuery("Authz.getByToken", AuthorizationEntity.class);
            queryS.setParameter("token", (Object)token);
            AuthorizationEntity authEntry = (AuthorizationEntity)queryS.getSingleResult();
            if (authEntry != null) {
                em.remove((Object)authEntry);
            }
            em.getTransaction().commit();
        }
        catch (Exception e) {
            log.error("error removing apikey  {}", (Object)token);
            em.close();
        }
    }
}

