/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.authorization.utils.manager;

import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;
import org.gcube.common.authorization.utils.secret.Secret;
import org.gcube.common.authorization.utils.user.User;
import org.gcube.common.scope.api.ScopeProvider;

public class SecretHolder {
    private SortedSet<Secret> secrets;

    public SecretHolder() {
        this.secrets = new TreeSet<Secret>();
    }

    public SecretHolder(Secret secret) {
        this.secrets = new TreeSet<Secret>();
        this.addSecret(secret);
    }

    public SecretHolder(Collection<Secret> secrets) {
        this.secrets = new TreeSet<Secret>(secrets);
    }

    public void addSecret(Secret secret) {
        if (secret != null) {
            this.secrets.add(secret);
        }
    }

    public void addAuthorizationSecrets(Collection<Secret> secrets) {
        for (Secret secret : secrets) {
            this.addSecret(secret);
        }
    }

    public void set() throws Exception {
        boolean first = true;
        for (Secret secret : this.secrets) {
            if (first) {
                secret.set();
                first = false;
                continue;
            }
            secret.setToken();
        }
    }

    public SortedSet<Secret> getSecrets() {
        return this.secrets;
    }

    public User getUser() {
        for (Secret secret : this.secrets) {
            try {
                return secret.getUser();
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public String getContext() {
        for (Secret secret : this.secrets) {
            try {
                return secret.getContext();
            }
            catch (Exception exception) {
            }
        }
        return ScopeProvider.instance.get();
    }

    public void reset() {
        for (Secret secret : this.secrets) {
            try {
                secret.reset();
            }
            catch (Exception exception) {}
        }
    }
}

