/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.authorization.library.policies;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.common.authorization.library.policies.ServiceAccess;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ServiceEntity {
    private ServiceAccess service = null;
    private List<ServiceAccess> excludes = null;

    private ServiceEntity() {
    }

    protected ServiceEntity(ServiceAccess service) {
        if (service == null) {
            throw new IllegalArgumentException("serviceAccess cannot be null");
        }
        this.service = service;
    }

    protected ServiceEntity(List<ServiceAccess> excludes) {
        if (excludes == null || excludes.isEmpty()) {
            throw new IllegalArgumentException("list of excludes cannot be empty");
        }
        ArrayList<ServiceAccess> newExcludes = new ArrayList<ServiceAccess>();
        block0: for (ServiceAccess sa : excludes) {
            if (sa.getClass() == null) {
                throw new IllegalArgumentException("excluding all services to a deny policy is illegal");
            }
            for (ServiceAccess alreadySaved : newExcludes) {
                if (!sa.isSubsetOf(alreadySaved)) continue;
                break block0;
            }
            newExcludes.add(sa);
        }
        this.excludes = newExcludes;
    }

    public ServiceAccess getService() {
        return this.service;
    }

    public List<ServiceAccess> getExcludes() {
        return Collections.unmodifiableList(this.excludes);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.excludes == null ? 0 : this.excludes.hashCode());
        result = 31 * result + (this.service == null ? 0 : this.service.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServiceEntity other = (ServiceEntity)obj;
        if (this.excludes == null ? other.excludes != null : !this.excludes.equals(other.excludes)) {
            return false;
        }
        return !(this.service == null ? other.service != null : !this.service.equals(other.service));
    }

    public String toString() {
        if (this.service != null) {
            return "ServiceEntity [service=" + this.service + "]";
        }
        return "ServiceEntity [ allExcept : " + this.excludes + "]";
    }

    public String getAsString() {
        if (this.service != null) {
            return this.service.getAsString();
        }
        return "allExcept" + this.excludes;
    }
}

