/*
 * Decompiled with CFR 0.152.
 */
package net.sf.csv4j;

import java.io.Closeable;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.SortedMap;

public class CSVWriter
implements Closeable {
    private final Writer writer;
    private final char commentChar;
    private final char delimiter;
    private final String lineSeparator;

    public CSVWriter(Writer writer) {
        this(writer, ',', '#');
    }

    public CSVWriter(Writer writer, char delimiter) {
        this(writer, delimiter, '#');
    }

    public CSVWriter(Writer writer, char delimiter, char comment) {
        this.writer = writer;
        this.delimiter = delimiter;
        this.commentChar = comment;
        this.lineSeparator = System.getProperty("line.separator");
    }

    public void writeCommentLine(String comment) throws IOException {
        String[] lines;
        for (String line : lines = comment.split("[\r\n]")) {
            this.writer.write(this.commentChar);
            this.writer.write(32);
            this.writer.write(line);
            this.writer.write(this.lineSeparator);
        }
    }

    public void writeHeaderLine(SortedMap<String, String> fields) throws IOException {
        this.writeLine(fields.keySet());
    }

    public void writeDataLine(SortedMap<String, String> fields) throws IOException {
        this.writeLine(fields.values());
    }

    public void writeLine(List<String> values) throws IOException {
        this.writeLine((Collection<String>)values);
    }

    public void writeLine(String[] values) throws IOException {
        for (int ii = 0; ii < values.length; ++ii) {
            CSVWriter.escapeCSV(this.writer, values[ii], this.delimiter);
            if (ii + 1 >= values.length) continue;
            this.writer.append(this.delimiter);
        }
        this.writer.write(this.lineSeparator);
    }

    private void writeLine(Collection<String> values) throws IOException {
        int ii = 0;
        for (String value : values) {
            CSVWriter.escapeCSV(this.writer, value, this.delimiter);
            if (++ii >= values.size()) continue;
            this.writer.append(this.delimiter);
        }
        this.writer.write(this.lineSeparator);
    }

    public static String escapeCSV(String text) {
        return CSVWriter.escapeCSV(text, ',');
    }

    public static String escapeCSV(String text, char delimiter) {
        try {
            StringWriter writer = new StringWriter();
            CSVWriter.escapeCSV(writer, text, delimiter);
            return writer.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("escapeCSV error", e);
        }
    }

    public static void escapeCSV(Writer writer, String text, char delimiter) throws IOException {
        StringBuilder sbuf = new StringBuilder();
        boolean isBuffering = true;
        block4: for (int ii = 0; ii < text.length(); ++ii) {
            char ch = text.charAt(ii);
            switch (ch) {
                case '\"': {
                    if (isBuffering) {
                        isBuffering = false;
                        writer.write(34);
                        if (sbuf.length() != 0) {
                            writer.write(sbuf.toString());
                        }
                    }
                    writer.write(34);
                    writer.write(34);
                    continue block4;
                }
                case '\n': 
                case '\r': {
                    if (isBuffering) {
                        isBuffering = false;
                        writer.write(34);
                        if (sbuf.length() != 0) {
                            writer.write(sbuf.toString());
                        }
                    }
                    writer.write(ch);
                    continue block4;
                }
                default: {
                    if (ch == delimiter) {
                        if (isBuffering) {
                            isBuffering = false;
                            writer.write(34);
                            if (sbuf.length() != 0) {
                                writer.write(sbuf.toString());
                            }
                        }
                        writer.write(ch);
                        continue block4;
                    }
                    if (isBuffering) {
                        sbuf.append(ch);
                        continue block4;
                    }
                    writer.write(ch);
                }
            }
        }
        if (isBuffering) {
            writer.write(text);
        } else {
            writer.write(34);
        }
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

