/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.dbinterface.pool;

import java.util.Enumeration;
import java.util.Hashtable;
import org.gcube.common.core.utils.logging.GCUBELog;

public abstract class ObjectPool<T> {
    private static GCUBELog logger = new GCUBELog(ObjectPool.class);
    private long expirationTime = 300000L;
    private long timeoutTime = 3600000L;
    private Hashtable<T, Long> locked = new Hashtable();
    private Hashtable<T, Long> unlocked = new Hashtable();

    protected abstract T create();

    public abstract boolean validate(T var1);

    public abstract void expire(T var1);

    public synchronized T acquire() {
        T t;
        Enumeration<T> e;
        logger.trace((Object)("unlocked are " + this.unlocked.size()));
        logger.trace((Object)("locked are " + this.locked.size()));
        long now = System.currentTimeMillis();
        if (this.locked.size() > 0 && this.timeoutTime > 0L) {
            e = this.locked.keys();
            while (e.hasMoreElements()) {
                t = e.nextElement();
                if (now - this.locked.get(t) <= this.timeoutTime) continue;
                this.release(t);
            }
        }
        if (this.unlocked.size() > 0) {
            e = this.unlocked.keys();
            while (e.hasMoreElements()) {
                t = e.nextElement();
                if (now - this.unlocked.get(t) > this.expirationTime) {
                    this.unlocked.remove(t);
                    this.expire(t);
                    t = null;
                    logger.trace((Object)"object expired, removing it");
                    continue;
                }
                if (this.validate(t)) {
                    this.unlocked.remove(t);
                    this.locked.put(t, now);
                    logger.trace((Object)"acquired connection ");
                    return t;
                }
                this.unlocked.remove(t);
                this.expire(t);
                t = null;
            }
        }
        t = this.create();
        this.locked.put(t, now);
        return t;
    }

    public synchronized void release(T t) {
        long value = this.locked.remove(t);
        logger.trace((Object)("releasing connection " + value));
        this.unlocked.put(t, System.currentTimeMillis());
    }
}

