/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.dbinterface.pool;

import java.sql.DriverManager;
import java.sql.SQLException;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.pool.ObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionPool
extends ObjectPool<DBSession> {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionPool.class);
    private String dsn;
    private String usr;
    private String pwd;

    public ConnectionPool(String driver, String dsn, String usr, String pwd) {
        try {
            Class.forName(driver).newInstance();
        }
        catch (Exception e) {
            logger.error("error getting db drivers", (Throwable)e);
        }
        this.dsn = dsn;
        this.usr = usr;
        this.pwd = pwd;
    }

    @Override
    protected DBSession create() {
        try {
            return new DBSession(DriverManager.getConnection(this.dsn, this.usr, this.pwd));
        }
        catch (SQLException e) {
            logger.error("", (Throwable)e);
            return null;
        }
    }

    @Override
    public void expire(DBSession o) {
        try {
            o.closeConnection();
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
    }

    @Override
    public boolean validate(DBSession o) {
        try {
            return !o.isConnectionClosed();
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return false;
        }
    }
}

