/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.geoserverinterface;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.gcube.common.geoserverinterface.Logger;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.datatransfer.agent.library.AgentLibrary;
import org.gcube.datatransfer.agent.library.exceptions.ConfigurationException;
import org.gcube.datatransfer.agent.library.exceptions.GetTransferOutcomesException;
import org.gcube.datatransfer.agent.library.exceptions.TransferException;
import org.gcube.datatransfer.agent.library.proxies.Proxies;
import org.gcube.datatransfer.common.agent.Types;
import org.gcube.datatransfer.common.options.TransferOptions;
import org.gcube.datatransfer.common.outcome.FileTransferOutcome;
import org.gcube.datatransfer.common.outcome.TransferStatus;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;

public class DataTransferUtl {
    private static final String TRANSFER_STATE_DONE = "DONE";
    private static final long INTERVAL_MONITOR = 5000L;

    public static String transferFromUrl(String geoTiffUrl, String destinationUrl, String dataSubFolder, String scope, boolean convert) throws URISyntaxException, TransferException, ConfigurationException, GetTransferOutcomesException {
        URI destURI = new URI(destinationUrl);
        String host = destURI.getHost();
        ScopeProvider.instance.set(scope);
        int port = DataTransferUtl.getAgentPortOnHost(host);
        Logger.info("[DataTransfer] Start Transfer");
        Logger.info("[DataTransfer] source: " + geoTiffUrl + "; destination host: " + host + "; destination Port : " + port + "scope: " + scope);
        AgentLibrary library = (AgentLibrary)Proxies.transferAgent().at(host, port).build();
        ArrayList<URI> inputs = new ArrayList<URI>();
        inputs.add(new URI(geoTiffUrl));
        String outPath = "./data/" + dataSubFolder + "/";
        TransferOptions options = new TransferOptions();
        options.setOverwriteFile(true);
        options.setType(Types.storageType.LocalGHN);
        options.setUnzipFile(false);
        if (convert) {
            options.setCovertFile(true);
            options.setConversionType(TransferOptions.ConversionType.GEOTIFF);
            options.setDeleteOriginalFile(true);
        }
        String transferId = library.startTransfer(inputs, outPath, options);
        Logger.info("Transfer started " + transferId);
        Types.MonitorTransferReportMessage message = null;
        TransferStatus ts = null;
        do {
            try {
                message = library.monitorTransferWithProgress(transferId);
                ts = TransferStatus.valueOf((String)message.getTransferStatus());
                double percentage = (double)message.getBytesTransferred() / (double)message.getTotalBytes() * 100.0;
                Logger.info("[" + Math.round(percentage) + "%]" + "\tStatus: " + message.getTransferStatus() + "\tTotBytes: " + message.getTotalBytes() + "\tTransferedBytes: " + message.getBytesTransferred() + "\tTotalTransfers: " + message.getTotalTransfers() + "\tTransfersCompleted: " + message.getTransferCompleted());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } while (!ts.hasCompleted());
        Logger.info("done!");
        FileTransferOutcome outcome = (FileTransferOutcome)library.getTransferOutcomes(transferId, FileTransferOutcome.class).get(0);
        Logger.info("file: " + outcome.getDest() + "; " + (outcome.isSuccess() ? "SUCCESS" : "FAILURE"));
        String fileName = outcome.isSuccess() ? new File(outcome.getDest()).getName() : null;
        return fileName;
    }

    private static final int getAgentPortOnHost(String host) {
        XQuery query = ICFactory.queryFor(GCoreEndpoint.class);
        query.addCondition("$resource/Profile/ServiceClass/text() eq DataTransfer").addCondition("$resource/Profile/ServiceName/text() eq agent-service");
        DiscoveryClient client = ICFactory.clientFor(GCoreEndpoint.class);
        for (GCoreEndpoint epr : client.submit((Query)query)) {
            URI uri = ((GCoreEndpoint.Profile.Endpoint)epr.profile().endpointMap().get("gcube/datatransfer/agent/DataTransferAgent")).uri();
            if (!uri.getHost().equalsIgnoreCase(host)) continue;
            return uri.getPort();
        }
        throw new RuntimeException("No Agent service found");
    }
}

