/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.epsg;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.geotools.factory.Hints;
import org.geotools.referencing.factory.epsg.FactoryUsingAnsiSQL;

final class FactoryUsingHSQL
extends FactoryUsingAnsiSQL {
    private static final Pattern OPENING_PATTERN = Pattern.compile("\\s+FROM\\s*\\(", 2);

    public FactoryUsingHSQL(Hints hints, Connection connection) {
        super(hints, connection);
    }

    @Override
    public String adaptSQL(String query) {
        block6: {
            Matcher matcher = OPENING_PATTERN.matcher(query = super.adaptSQL(query));
            if (!matcher.find()) break block6;
            int opening = matcher.end() - 1;
            int length = query.length();
            int closing = opening;
            int count = 0;
            while (true) {
                block7: {
                    if (closing >= length) {
                        return query;
                    }
                    switch (query.charAt(closing)) {
                        case '(': {
                            ++count;
                            break;
                        }
                        case ')': {
                            --count;
                            break;
                        }
                        default: {
                            break block7;
                        }
                    }
                    if (count == 0) break;
                }
                ++closing;
            }
            query = query.substring(0, opening) + query.substring(opening + 1, closing) + query.substring(closing + 1);
        }
        return query;
    }

    @Override
    protected void shutdown(boolean active) throws SQLException {
        if (active) {
            Statement statement = this.getConnection().createStatement();
            statement.execute("SHUTDOWN");
            statement.close();
        }
        super.shutdown(active);
    }
}

