/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.traverse.standard;

import java.util.Iterator;
import org.geotools.graph.structure.Graph;
import org.geotools.graph.structure.GraphVisitor;
import org.geotools.graph.structure.Graphable;
import org.geotools.graph.structure.Node;
import org.geotools.graph.traverse.GraphTraversal;
import org.geotools.graph.traverse.basic.AbstractGraphIterator;
import org.geotools.graph.util.FIFOQueue;
import org.geotools.graph.util.Queue;

public class BreadthFirstTopologicalIterator
extends AbstractGraphIterator {
    private Queue m_queue;

    @Override
    public void init(Graph graph, GraphTraversal traversal) {
        this.m_queue = this.buildQueue(graph);
        graph.visitNodes(new GraphVisitor(){

            @Override
            public int visit(Graphable component) {
                Node node = (Node)component;
                node.setCount(0);
                if (node.getDegree() < 2) {
                    BreadthFirstTopologicalIterator.this.m_queue.enq(node);
                }
                return 0;
            }
        });
    }

    @Override
    public Graphable next(GraphTraversal traversal) {
        return !this.m_queue.isEmpty() ? (Graphable)this.m_queue.deq() : null;
    }

    @Override
    public void cont(Graphable current, GraphTraversal traversal) {
        Iterator itr = current.getRelated();
        while (itr.hasNext()) {
            Node related = (Node)itr.next();
            if (traversal.isVisited(related)) continue;
            related.setCount(related.getCount() + 1);
            if (related.getDegree() - 1 != related.getCount()) continue;
            this.m_queue.enq(related);
        }
    }

    @Override
    public void killBranch(Graphable current, GraphTraversal traversal) {
    }

    protected Queue buildQueue(Graph graph) {
        return new FIFOQueue(graph.getNodes().size());
    }
}

