/*
 * Decompiled with CFR 0.152.
 */
package geodb;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.io.InStream;
import com.vividsolutions.jts.io.InputStreamInStream;
import com.vividsolutions.jts.io.OutStream;
import com.vividsolutions.jts.io.OutputStreamOutStream;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKBReader;
import com.vividsolutions.jts.io.WKBWriter;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.io.WKTWriter;
import com.vividsolutions.jts.simplify.DouglasPeuckerSimplifier;
import geodb.GeoString;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.logging.Level;
import net.sourceforge.hatbox.jts.Proc;
import net.sourceforge.hatbox.tools.CmdLine;

public class GeoDB {
    static WKBReader wkbreader;
    static WKBWriter wkbwriter;
    static WKTReader wktreader;
    static WKTWriter wktwriter;

    static {
        CmdLine.LOGGER.setLevel(Level.WARNING);
        wkbreader = new WKBReader();
        wkbwriter = new WKBWriter();
        wktreader = new WKTReader();
        wktwriter = new WKTWriter();
    }

    public static String GeoToolsVersion() {
        return "0.1";
    }

    public static String CheckSum() {
        return "4";
    }

    /*
     * Exception decompiling
     */
    public static void InitGeoDB(Connection cx) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 7[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String ST_AsText(byte[] wkb) {
        if (wkb == null) {
            return null;
        }
        return GeoDB.gToWKT(GeoDB.gFromWKB(wkb));
    }

    public static String ST_AsEWKT(byte[] wkb) {
        if (wkb == null) {
            return null;
        }
        Geometry g = GeoDB.gFromWKB(wkb);
        return GeoDB.gToEWKT(g);
    }

    public static byte[] ST_AsEWKB(byte[] wkb) {
        return wkb;
    }

    public static String ST_AsHexEWKB(byte[] wkb) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < wkb.length) {
            sb.append(Integer.toString((wkb[i] & 0xFF) + 256, 16).substring(1));
            ++i;
        }
        return sb.toString();
    }

    public static String ST_GeoHash(byte[] wkb) {
        if (wkb == null) {
            return null;
        }
        Geometry g = GeoDB.gFromWKB(wkb);
        Envelope e = g.getEnvelopeInternal();
        GeoString gs1 = new GeoString(e.getMinX(), e.getMinY());
        GeoString gs2 = new GeoString(e.getMaxX(), e.getMaxY());
        return gs1.union(gs2).toString();
    }

    public static byte[] ST_GeomFromEWKB(byte[] wkb) {
        return GeoDB.gToWKB(GeoDB.gFromWKB(wkb));
    }

    public static byte[] ST_GeomFromEWKT(String wkt) {
        if (wkt == null) {
            return null;
        }
        return GeoDB.gToWKB(GeoDB.gFromEWKT(wkt));
    }

    public static byte[] ST_GeomFromText(String wkt, int srid) {
        if (wkt == null) {
            return null;
        }
        Geometry g = GeoDB.gFromWKT(wkt, srid);
        return GeoDB.gToWKB(g);
    }

    public static byte[] ST_GeomFromWKB(byte[] wkb, int srid) {
        if (wkb == null) {
            return null;
        }
        try {
            Geometry g = wkbreader.read(wkb);
            g.setSRID(srid);
            return GeoDB.gToWKB(g);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static byte[] ST_MakeBox2D(byte[] wkb1, byte[] wkb2) {
        if (wkb1 == null || wkb2 == null) {
            return null;
        }
        Point p1 = (Point)GeoDB.gFromWKB(wkb1);
        Point p2 = (Point)GeoDB.gFromWKB(wkb1);
        return GeoDB.ST_MakeBox2D(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public static byte[] ST_MakeBox2D(double x1, double y1, double x2, double y2) {
        return GeoDB.envToWKB(x1, y1, x2, y2);
    }

    public static String GeometryType(byte[] wkb) {
        if (wkb == null) {
            return null;
        }
        Geometry g = GeoDB.gFromWKB(wkb);
        return g.getGeometryType().toUpperCase();
    }

    public static Envelope ST_Envelope(byte[] wkb) {
        if (wkb == null) {
            return null;
        }
        return GeoDB.gFromWKB(wkb).getEnvelopeInternal();
    }

    public static String EnvelopeAsText(byte[] wkb) {
        Envelope env = GeoDB.ST_Envelope(wkb);
        if (env == null) {
            return null;
        }
        return "(" + env.getMinX() + "," + env.getMinY() + "," + env.getMaxX() + "," + env.getMaxY() + ")";
    }

    public static int ST_SRID(byte[] wkb) {
        if (wkb == null) {
            return -1;
        }
        Geometry g = GeoDB.gFromWKB(wkb);
        return g.getSRID();
    }

    public static boolean ST_IsValid(byte[] wkb) {
        if (wkb == null) {
            return false;
        }
        Geometry g = GeoDB.gFromWKB(wkb);
        return g.isValid();
    }

    public static boolean ST_IsSimple(byte[] wkb) {
        if (wkb == null) {
            return false;
        }
        Geometry g = GeoDB.gFromWKB(wkb);
        return g.isSimple();
    }

    public static boolean ST_IsEmpty(byte[] wkb) {
        if (wkb == null) {
            return false;
        }
        Geometry g = GeoDB.gFromWKB(wkb);
        return g.isEmpty();
    }

    public static byte[] ST_SetSRID(byte[] wkb, int srid) {
        if (wkb == null) {
            return null;
        }
        Geometry g = GeoDB.gFromWKB(wkb);
        g.setSRID(srid);
        return GeoDB.gToWKB(g);
    }

    public static double ST_Area(byte[] wkb) {
        if (wkb == null) {
            return -1.0;
        }
        Geometry g = GeoDB.gFromWKB(wkb);
        return g.getArea();
    }

    public static boolean ST_BBox(byte[] b1, byte[] b2) {
        if (b1 == null || b2 == null) {
            return false;
        }
        Envelope e1 = GeoDB.envFromWKB(b1);
        Envelope e2 = GeoDB.envFromWKB(b2);
        return e1.intersects(e2);
    }

    public static byte[] ST_Centroid(byte[] wkb) {
        if (wkb == null) {
            return null;
        }
        Geometry g = GeoDB.gFromWKB(wkb);
        return GeoDB.gToWKB((Geometry)g.getCentroid());
    }

    public static boolean ST_Crosses(byte[] wkb1, byte[] wkb2) {
        if (wkb1 == null || wkb2 == null) {
            return false;
        }
        Geometry g1 = GeoDB.gFromWKB(wkb1);
        Geometry g2 = GeoDB.gFromWKB(wkb2);
        return g1.crosses(g2);
    }

    public static boolean ST_Contains(byte[] wkb1, byte[] wkb2) {
        if (wkb1 == null || wkb2 == null) {
            return false;
        }
        Geometry g1 = GeoDB.gFromWKB(wkb1);
        Geometry g2 = GeoDB.gFromWKB(wkb2);
        return g1.contains(g2);
    }

    public static boolean ST_Disjoint(byte[] wkb1, byte[] wkb2) {
        if (wkb1 == null || wkb2 == null) {
            return false;
        }
        Geometry g1 = GeoDB.gFromWKB(wkb1);
        Geometry g2 = GeoDB.gFromWKB(wkb2);
        return g1.disjoint(g2);
    }

    public static boolean ST_DWithin(byte[] wkb1, byte[] wkb2, double distance) {
        Geometry g2;
        if (wkb1 == null || wkb2 == null) {
            return false;
        }
        Geometry g1 = GeoDB.gFromWKB(wkb1);
        return g1.distance(g2 = GeoDB.gFromWKB(wkb2)) <= distance;
    }

    public static boolean ST_Equals(byte[] wkb1, byte[] wkb2) {
        if (wkb1 == null || wkb2 == null) {
            return false;
        }
        Geometry g1 = GeoDB.gFromWKB(wkb1);
        Geometry g2 = GeoDB.gFromWKB(wkb2);
        return g1.equals(g2);
    }

    public static boolean ST_Intersects(byte[] wkb1, byte[] wkb2) {
        if (wkb1 == null || wkb2 == null) {
            return false;
        }
        Geometry g1 = GeoDB.gFromWKB(wkb1);
        Geometry g2 = GeoDB.gFromWKB(wkb2);
        return g1.intersects(g2);
    }

    public static boolean ST_Overlaps(byte[] wkb1, byte[] wkb2) {
        if (wkb1 == null || wkb2 == null) {
            return false;
        }
        Geometry g1 = GeoDB.gFromWKB(wkb1);
        Geometry g2 = GeoDB.gFromWKB(wkb2);
        return g1.overlaps(g2);
    }

    public static boolean ST_Touches(byte[] wkb1, byte[] wkb2) {
        if (wkb1 == null || wkb2 == null) {
            return false;
        }
        Geometry g1 = GeoDB.gFromWKB(wkb1);
        Geometry g2 = GeoDB.gFromWKB(wkb2);
        return g1.touches(g2);
    }

    public static boolean ST_Within(byte[] wkb1, byte[] wkb2) {
        if (wkb1 == null || wkb2 == null) {
            return false;
        }
        Geometry g1 = GeoDB.gFromWKB(wkb1);
        Geometry g2 = GeoDB.gFromWKB(wkb2);
        return g1.within(g2);
    }

    public static byte[] ST_Buffer(byte[] wkb, double distance) {
        if (wkb == null) {
            return null;
        }
        Geometry g = GeoDB.gFromWKB(wkb);
        return GeoDB.gToWKB(g.buffer(distance));
    }

    public static byte[] ST_Simplify(byte[] wkb, double tol) {
        if (wkb == null) {
            return null;
        }
        Geometry g = GeoDB.gFromWKB(wkb);
        return GeoDB.gToWKB(DouglasPeuckerSimplifier.simplify((Geometry)g, (double)tol));
    }

    public static void CreateSpatialIndex(Connection cx, String schemaName, String tableName, String columnName, String srid) throws SQLException {
        HashMap<String, String> args = new HashMap<String, String>();
        if (schemaName == null) {
            schemaName = "PUBLIC";
        }
        args.put("s", schemaName);
        args.put("t", tableName);
        args.put("geom", columnName);
        args.put("srid", srid);
        try {
            CmdLine.spatialize((Connection)cx, args);
            Proc.buildIndex((Connection)cx, (String)schemaName, (String)tableName, (int)10000, null);
        }
        catch (Exception e) {
            throw (SQLException)new SQLException("Error creating spatial index").initCause(e);
        }
    }

    public static void CreateSpatialIndex_GeoHash(Connection cx, String schemaName, String tableName, String columnName) throws SQLException {
        schemaName = "".equals(schemaName) ? null : schemaName;
        Statement st = cx.createStatement();
        try {
            String table = "\"" + tableName + "\"";
            table = schemaName != null ? "\"" + schemaName + "\"." + table : table;
            String column = "\"_" + columnName + "_GEOHASH\"";
            String sql = "ALTER TABLE " + table + " ADD " + column + " VARCHAR";
            st.execute(sql);
            sql = "UPDATE " + table + " SET " + column + " = ST_GeoHash(\"" + columnName + "\")";
            st.execute(sql);
            sql = "CREATE INDEX \"_" + columnName + "_GEOHASH_INDEX\" " + "ON " + table + "(" + column + ")";
            st.execute(sql);
        }
        finally {
            st.close();
        }
    }

    public static void DropSpatialIndex(Connection cx, String schemaName, String tableName) throws SQLException {
        HashMap<String, String> args = new HashMap<String, String>();
        if (schemaName == null) {
            schemaName = "PUBLIC";
        }
        args.put("s", schemaName);
        args.put("t", tableName);
        try {
            CmdLine.deSpatialize((Connection)cx, args);
        }
        catch (Exception e) {
            throw (SQLException)new SQLException("Error dropping spatial index").initCause(e);
        }
    }

    /*
     * Exception decompiling
     */
    public static int GetSRID(Connection cx, String schemaName, String tableName) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 6[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static byte[] gToWKB(Geometry g) {
        return wkbwriter.write(g);
    }

    public static byte[] gToEWKB(Geometry g) {
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            wkbwriter.write(g, (OutStream)new OutputStreamOutStream((OutputStream)bytes));
            byte[] b = bytes.toByteArray();
            byte[] ewkb = new byte[32 + b.length + 4];
            Envelope bbox = g.getEnvelopeInternal();
            GeoDB.envToWKB(bbox, ewkb, 0);
            System.arraycopy(b, 0, ewkb, 32, 5);
            ewkb[33] = (byte)(ewkb[33] | 0x20);
            int srid = g.getSRID();
            ewkb[37] = (byte)(srid >>> 24);
            ewkb[38] = (byte)(srid >> 16 & 0xFF);
            ewkb[39] = (byte)(srid >> 8 & 0xFF);
            ewkb[40] = (byte)(srid & 0xFF);
            System.arraycopy(b, 5, ewkb, 41, b.length - 5);
            return ewkb;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Geometry gFromWKB(byte[] wkb) {
        return GeoDB.gFromWKB(wkb, wkbreader);
    }

    public static Geometry gFromWKB(byte[] wkb, WKBReader wkbreader) {
        try {
            return wkbreader.read(wkb);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static Geometry gFromEWKB(byte[] wkb) {
        return GeoDB.gFromEWKB(wkb, wkbreader);
    }

    public static Geometry gFromEWKB(byte[] wkb, WKBReader wkbreader) {
        try {
            return wkbreader.read((InStream)new InputStreamInStream((InputStream)new ByteArrayInputStream(wkb, 32, wkb.length - 32)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] envToWKB(Envelope e) {
        return GeoDB.envToWKB(e.getMinX(), e.getMinY(), e.getMaxX(), e.getMaxY());
    }

    public static byte[] envToWKB(double x1, double y1, double x2, double y2) {
        return GeoDB.envToWKB(x1, y1, x2, y2, new byte[32], 0);
    }

    public static byte[] envToWKB(Envelope e, byte[] wkb, int pos) {
        return GeoDB.envToWKB(e.getMinX(), e.getMinY(), e.getMaxX(), e.getMaxY(), wkb, pos);
    }

    public static byte[] envToWKB(double x1, double y1, double x2, double y2, byte[] wkb, int pos) {
        GeoDB.doubleToBytes(wkb, pos, x1);
        GeoDB.doubleToBytes(wkb, 8, y1);
        GeoDB.doubleToBytes(wkb, 16, x2);
        GeoDB.doubleToBytes(wkb, 24, y2);
        return wkb;
    }

    public static Envelope envFromWKB(byte[] wkb) {
        try {
            return wkbreader.read(wkb).getEnvelopeInternal();
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    static void doubleToBytes(byte[] b, int pos, double d) {
        long l = Double.doubleToRawLongBits(d);
        b[pos] = (byte)(l >>> 56);
        b[pos + 1] = (byte)(l >> 48 & 0xFFL);
        b[pos + 2] = (byte)(l >> 40 & 0xFFL);
        b[pos + 3] = (byte)(l >> 32 & 0xFFL);
        b[pos + 4] = (byte)(l >> 24 & 0xFFL);
        b[pos + 5] = (byte)(l >> 16 & 0xFFL);
        b[pos + 6] = (byte)(l >> 8 & 0xFFL);
        b[pos + 7] = (byte)(l & 0xFFL);
    }

    static double bytesToDouble(byte[] b, int pos) {
        long l = (long)(0xFF & b[pos]) << 56 | (long)(0xFF & b[pos + 1]) << 48 | (long)(0xFF & b[pos + 2]) << 40 | (long)(0xFF & b[pos + 3]) << 32 | (long)(0xFF & b[pos + 4]) << 24 | (long)(0xFF & b[pos + 5]) << 16 | (long)(0xFF & b[pos + 6]) << 8 | (long)(0xFF & b[pos + 7]) << 0;
        return Double.longBitsToDouble(l);
    }

    public static Geometry gFromWKT(String wkt, int srid) {
        try {
            Geometry g = wktreader.read(wkt);
            g.setSRID(srid);
            return g;
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String gToWKT(Geometry g) {
        return g.toText();
    }

    public static Geometry gFromEWKT(String wkt) {
        wkt = wkt.toUpperCase();
        int srid = -1;
        if (wkt.startsWith("SRID=")) {
            int semi = wkt.indexOf(59);
            if (semi == -1) {
                throw new IllegalArgumentException("Could not read EWKT format, should be 'SRID=<srid>;<WKT>'");
            }
            String s = wkt.substring(0, semi);
            srid = Integer.parseInt(s.substring(5, s.length()));
            wkt = wkt.substring(s.length() + 1);
        }
        return GeoDB.gFromWKT(wkt, srid);
    }

    public static String gToEWKT(Geometry g) {
        return "SRID=" + g.getSRID() + ";" + g.toText();
    }

    private static Geometry fromWKB(byte[] wkb) {
        try {
            ByteArrayInputStream bytes = new ByteArrayInputStream(wkb, 0, wkb.length - 4);
            Geometry g = new WKBReader().read((InStream)new InputStreamInStream((InputStream)bytes));
            int srid = 0;
            srid |= wkb[wkb.length - 4] & 0xFF;
            srid <<= 8;
            srid |= wkb[wkb.length - 3] & 0xFF;
            srid <<= 8;
            srid |= wkb[wkb.length - 2] & 0xFF;
            srid <<= 8;
            g.setSRID(srid |= wkb[wkb.length - 1] & 0xFF);
            return g;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] toWKB(Geometry g) {
        try {
            WKBWriter w = new WKBWriter();
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            w.write(g, (OutStream)new OutputStreamOutStream((OutputStream)bytes));
            int srid = g.getSRID();
            bytes.write((byte)(srid >>> 24));
            bytes.write((byte)(srid >> 16 & 0xFF));
            bytes.write((byte)(srid >> 8 & 0xFF));
            bytes.write((byte)(srid & 0xFF));
            return bytes.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

