/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.protocol.http;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.commons.codec.binary.Base64;
import org.geotools.data.wfs.protocol.http.AbstractHttpProtocol;
import org.geotools.data.wfs.protocol.http.HTTPProtocol;
import org.geotools.data.wfs.protocol.http.HTTPResponse;
import org.geotools.data.wfs.protocol.http.HttpMethod;

public class SimpleHttpProtocol
extends AbstractHttpProtocol {
    @Override
    public HTTPResponse issueGet(URL baseUrl, Map<String, String> kvp) throws IOException {
        URL targetUrl = this.createUrl(baseUrl, kvp);
        HttpURLConnection conn = this.openConnection(targetUrl, HttpMethod.GET);
        SimpleHttpResponse response = new SimpleHttpResponse(conn);
        return response;
    }

    @Override
    public HTTPResponse issuePost(URL targetUrl, HTTPProtocol.POSTCallBack callback) throws IOException {
        HttpURLConnection conn = this.openConnection(targetUrl, HttpMethod.POST);
        long contentLength = callback.getContentLength();
        conn.setRequestProperty("Content-Length", String.valueOf(contentLength));
        String bodyContentType = callback.getContentType();
        conn.setRequestProperty("Content-Type", bodyContentType);
        OutputStream bodyOut = conn.getOutputStream();
        callback.writeBody(bodyOut);
        SimpleHttpResponse response = new SimpleHttpResponse(conn);
        return response;
    }

    private HttpURLConnection openConnection(URL targetUrl, HttpMethod method) throws IOException {
        HttpURLConnection conn;
        try {
            conn = (HttpURLConnection)targetUrl.openConnection();
        }
        catch (ClassCastException wrongUrl) {
            throw new IOException("HTTP connection required for " + targetUrl);
        }
        if (0 < this.getTimeoutMillis()) {
            conn.setConnectTimeout(this.getTimeoutMillis());
            conn.setReadTimeout(this.getTimeoutMillis());
        }
        if (this.isTryGzip()) {
            conn.setRequestProperty("Accept-Encoding", "gzip");
        }
        if (method == HttpMethod.POST) {
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
        } else {
            conn.setRequestMethod("GET");
        }
        conn.setDoInput(true);
        if (this.authUsername != null && this.authPassword != null) {
            String userPassword = this.authUsername + ":" + this.authPassword;
            byte[] encodedUserPassword = userPassword.getBytes();
            String base64UserAndPasswd = new String(Base64.encodeBase64((byte[])encodedUserPassword));
            conn.setRequestProperty("Authorization", "Basic " + base64UserAndPasswd);
        }
        return conn;
    }

    private static class SimpleHttpResponse
    implements HTTPResponse {
        private HttpURLConnection conn;
        private InputStream inputStream;

        public SimpleHttpResponse(HttpURLConnection conn) {
            this.conn = conn;
        }

        @Override
        public String getContentType() {
            return this.conn.getContentType();
        }

        @Override
        public String getResponseCharset() {
            return null;
        }

        @Override
        public String getResponseHeader(String headerName) {
            String headerField = this.conn.getHeaderField(headerName);
            return headerField;
        }

        @Override
        public InputStream getResponseStream() throws IOException {
            if (this.inputStream == null) {
                InputStream responseStream = this.conn.getInputStream();
                responseStream = new BufferedInputStream(responseStream);
                String contentEncoding = this.conn.getContentEncoding();
                if (contentEncoding != null && contentEncoding.toLowerCase().indexOf("gzip") != -1) {
                    responseStream = new GZIPInputStream(responseStream);
                }
                this.inputStream = responseStream;
            }
            return this.inputStream;
        }

        @Override
        public String getTargetUrl() {
            return this.conn.getURL().toExternalForm();
        }
    }
}

