/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.v1_0_0.gml;

import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.xml.gml.ChoiceGeometryType;
import org.geotools.xml.gml.ChoiceGeometryTypeImpl;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class WFSFeatureTypeTransformer {
    public static SimpleFeatureType transform(SimpleFeatureType schema, CoordinateReferenceSystem crs) throws SchemaException {
        SimpleFeatureTypeBuilder build = new SimpleFeatureTypeBuilder();
        build.setName(schema.getName());
        GeometryDescriptor defaultGeometryType = null;
        for (int i = 0; i < schema.getAttributeCount(); ++i) {
            AttributeDescriptor attributeType = schema.getDescriptor(i);
            if (attributeType instanceof ChoiceGeometryType) {
                defaultGeometryType = WFSFeatureTypeTransformer.handleChoiceGeometryAttribute(schema, crs, build, defaultGeometryType, attributeType);
                continue;
            }
            if (attributeType instanceof GeometryDescriptor) {
                defaultGeometryType = WFSFeatureTypeTransformer.handleGeometryAttribute(schema, crs, build, defaultGeometryType, attributeType);
                continue;
            }
            build.add(attributeType);
        }
        if (defaultGeometryType != null) {
            build.setDefaultGeometry(defaultGeometryType.getLocalName());
        }
        return build.buildFeatureType();
    }

    private static GeometryDescriptor handleGeometryAttribute(SimpleFeatureType schema, CoordinateReferenceSystem crs, SimpleFeatureTypeBuilder factory, GeometryDescriptor defaultGeometryType, AttributeDescriptor attributeType) {
        GeometryDescriptor geometryType = (GeometryDescriptor)attributeType;
        AttributeTypeBuilder builder = new AttributeTypeBuilder();
        builder.setName(geometryType.getLocalName());
        builder.setBinding(geometryType.getType().getBinding());
        builder.setNillable(geometryType.isNillable());
        builder.setCRS(crs);
        GeometryDescriptor geometry = builder.buildDescriptor(geometryType.getLocalName(), builder.buildGeometryType());
        if (defaultGeometryType == null || geometryType == schema.getGeometryDescriptor()) {
            defaultGeometryType = geometry;
        }
        factory.add((AttributeDescriptor)geometry);
        return defaultGeometryType;
    }

    private static GeometryDescriptor handleChoiceGeometryAttribute(SimpleFeatureType schema, CoordinateReferenceSystem crs, SimpleFeatureTypeBuilder factory, GeometryDescriptor defaultGeometryType, AttributeDescriptor attributeType) {
        ChoiceGeometryTypeImpl geometryType = (ChoiceGeometryTypeImpl)attributeType;
        ChoiceGeometryTypeImpl geometry = new ChoiceGeometryTypeImpl(geometryType.getName(), geometryType.getChoices(), geometryType.getBinding(), geometryType.isNillable(), geometryType.getMinOccurs(), geometryType.getMaxOccurs(), geometryType.createDefaultValue(), crs, geometryType.getRestrictions());
        if (defaultGeometryType == null || geometryType == schema.getGeometryDescriptor()) {
            defaultGeometryType = geometry;
        }
        factory.add((AttributeDescriptor)geometry);
        return defaultGeometryType;
    }
}

