/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.v1_0_0.xml;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.data.wfs.v1_0_0.xml.WFSBasicComplexTypes;
import org.geotools.data.wfs.v1_0_0.xml.WFSCapabilitiesComplexTypes;
import org.geotools.data.wfs.v1_0_0.xml.WFSTransactionComplexTypes;
import org.geotools.util.logging.Logging;
import org.geotools.xml.filter.FilterSchema;
import org.geotools.xml.gml.GMLSchema;
import org.geotools.xml.schema.Attribute;
import org.geotools.xml.schema.AttributeGroup;
import org.geotools.xml.schema.ComplexType;
import org.geotools.xml.schema.Element;
import org.geotools.xml.schema.Facet;
import org.geotools.xml.schema.Group;
import org.geotools.xml.schema.Schema;
import org.geotools.xml.schema.SimpleType;
import org.geotools.xml.schema.Type;
import org.geotools.xml.schema.impl.AttributeGT;
import org.geotools.xml.schema.impl.FacetGT;
import org.geotools.xml.schema.impl.SimpleTypeGT;
import org.geotools.xml.xsi.XSISimpleTypes;

public class WFSSchema
implements Schema {
    static Logger logger = Logging.getLogger((String)"net.refractions.xml.wfs");
    private static Schema instance = new WFSSchema();
    public static URI NAMESPACE = WFSSchema.makeURI("http://www.opengis.net/wfs");
    static final Element[] elements = new Element[]{new WFSElement("GetCapabilities", WFSBasicComplexTypes.GetCapabilitiesType.getInstance()), new WFSElement("DescribeFeatureType", WFSBasicComplexTypes.DescribeFeatureTypeType.getInstance()), new WFSElement("GetFeature", WFSBasicComplexTypes.GetFeatureType.getInstance()), new WFSElement("FeatureCollection", WFSBasicComplexTypes.FeatureCollectionType.getInstance(), 1, 1, false, WFSSchema.findElement(GMLSchema.getInstance(), "_FeatureCollection")), new WFSElement("Query", WFSBasicComplexTypes.QueryType.getInstance()), new WFSElement("Abstract", XSISimpleTypes.String.getInstance()), new WFSElement("AccessConstraints", XSISimpleTypes.String.getInstance()), new WFSElement("Fees", XSISimpleTypes.String.getInstance()), new WFSElement("Keywords", XSISimpleTypes.String.getInstance()), new WFSElement("OnlineResource", XSISimpleTypes.String.getInstance()), new WFSElement("SRS", XSISimpleTypes.String.getInstance()), new WFSElement("Title", XSISimpleTypes.String.getInstance()), new WFSElement("Query", WFSCapabilitiesComplexTypes.EmptyType.getInstance()), new WFSElement("Insert", WFSCapabilitiesComplexTypes.EmptyType.getInstance()), new WFSElement("Update", WFSCapabilitiesComplexTypes.EmptyType.getInstance()), new WFSElement("Delete", WFSCapabilitiesComplexTypes.EmptyType.getInstance()), new WFSElement("Lock", WFSCapabilitiesComplexTypes.EmptyType.getInstance()), new WFSElement("VendorSpecificCapabilities", XSISimpleTypes.String.getInstance()), new WFSElement("WFS_Capabilities", WFSCapabilitiesComplexTypes.WFS_CapabilitiesType.getInstance()), new WFSElement("GML2", WFSCapabilitiesComplexTypes.EmptyType.getInstance()), new WFSElement("GML2-GZIP", WFSCapabilitiesComplexTypes.EmptyType.getInstance()), new WFSElement("XMLSCHEMA", WFSCapabilitiesComplexTypes.EmptyType.getInstance()), new WFSElement("GetFeatureWithLock", WFSTransactionComplexTypes.GetFeatureWithLockType.getInstance()), new WFSElement("LockFeature", WFSTransactionComplexTypes.LockFeatureType.getInstance()), new WFSElement("Transaction", WFSTransactionComplexTypes.TransactionType.getInstance()), new WFSElement("WFS_TransactionResponse", WFSTransactionComplexTypes.WFS_TransactionResponseType.getInstance()), new WFSElement("WFS_LockFeatureResponse", WFSTransactionComplexTypes.WFS_LockFeatureResponseType.getInstance()), new WFSElement("LockId", XSISimpleTypes.String.getInstance()), new WFSElement("Insert", WFSTransactionComplexTypes.InsertElementType.getInstance()), new WFSElement("Update", WFSTransactionComplexTypes.UpdateElementType.getInstance()), new WFSElement("Delete", WFSTransactionComplexTypes.DeleteElementType.getInstance()), new WFSElement("Native", WFSTransactionComplexTypes.NativeType.getInstance()), new WFSElement("Property", WFSTransactionComplexTypes.PropertyType.getInstance()), new WFSElement("SUCCESS", WFSCapabilitiesComplexTypes.EmptyType.getInstance()), new WFSElement("FAILED", WFSCapabilitiesComplexTypes.EmptyType.getInstance()), new WFSElement("PARTIAL", WFSCapabilitiesComplexTypes.EmptyType.getInstance())};
    static final ComplexType[] complexTypes = new ComplexType[]{WFSBasicComplexTypes.GetCapabilitiesType.getInstance(), WFSBasicComplexTypes.DescribeFeatureTypeType.getInstance(), WFSBasicComplexTypes.GetFeatureType.getInstance(), WFSBasicComplexTypes.QueryType.getInstance(), WFSBasicComplexTypes.FeatureCollectionType.getInstance(), WFSCapabilitiesComplexTypes.WFS_CapabilitiesType.getInstance(), WFSCapabilitiesComplexTypes.ServiceType.getInstance(), WFSCapabilitiesComplexTypes.CapabilityType.getInstance(), WFSCapabilitiesComplexTypes.FeatureTypeListType.getInstance(), WFSCapabilitiesComplexTypes.RequestType.getInstance(), WFSTransactionComplexTypes.TransactionType.getInstance(), WFSCapabilitiesComplexTypes.LockFeatureTypeType.getInstance(), WFSCapabilitiesComplexTypes.DCPTypeType.getInstance(), WFSCapabilitiesComplexTypes.FeatureTypeType.getInstance(), WFSCapabilitiesComplexTypes.GetType.getInstance(), WFSCapabilitiesComplexTypes.HTTPType.getInstance(), WFSCapabilitiesComplexTypes.LatLongBoundingBoxType.getInstance(), WFSCapabilitiesComplexTypes.MetadataURLType.getInstance(), WFSCapabilitiesComplexTypes.OperationsType.getInstance(), WFSCapabilitiesComplexTypes.PostType.getInstance(), WFSCapabilitiesComplexTypes.ResultFormatType.getInstance(), WFSCapabilitiesComplexTypes.SchemaDescriptionLanguageType.getInstance(), WFSCapabilitiesComplexTypes.EmptyType.getInstance(), WFSTransactionComplexTypes.GetFeatureWithLockType.getInstance(), WFSTransactionComplexTypes.LockFeatureType.getInstance(), WFSTransactionComplexTypes.LockType.getInstance(), WFSTransactionComplexTypes.InsertElementType.getInstance(), WFSTransactionComplexTypes.UpdateElementType.getInstance(), WFSTransactionComplexTypes.DeleteElementType.getInstance(), WFSTransactionComplexTypes.NativeType.getInstance(), WFSTransactionComplexTypes.PropertyType.getInstance(), WFSTransactionComplexTypes.WFS_LockFeatureResponseType.getInstance(), WFSTransactionComplexTypes.FeaturesLockedType.getInstance(), WFSTransactionComplexTypes.FeaturesNotLockedType.getInstance(), WFSTransactionComplexTypes.WFS_TransactionResponseType.getInstance(), WFSTransactionComplexTypes.TransactionResultType.getInstance(), WFSTransactionComplexTypes.InsertResultType.getInstance(), WFSTransactionComplexTypes.StatusType.getInstance()};
    static final SimpleType[] simpleTypes = new SimpleType[]{new SimpleTypeGT(null, "AllSomeType", NAMESPACE, 4, new SimpleType[]{XSISimpleTypes.String.getInstance()}, new Facet[]{new FacetGT(1, "ALL"), new FacetGT(1, "SOME")}, 0)};

    private static URI makeURI(String s) {
        try {
            return new URI(s);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public static Schema getInstance() {
        return instance;
    }

    private static Element findElement(Schema s, String name) {
        if (name == null || "".equals(name)) {
            return null;
        }
        Element[] elems = s.getElements();
        if (elems == null) {
            return null;
        }
        for (int i = 0; i < elems.length; ++i) {
            if (!name.equals(elems[i].getName())) continue;
            return elems[i];
        }
        return null;
    }

    @Override
    public AttributeGroup[] getAttributeGroups() {
        return new AttributeGroup[0];
    }

    @Override
    public Attribute[] getAttributes() {
        return new Attribute[0];
    }

    @Override
    public int getBlockDefault() {
        return 0;
    }

    @Override
    public ComplexType[] getComplexTypes() {
        return complexTypes;
    }

    @Override
    public Element[] getElements() {
        return elements;
    }

    @Override
    public int getFinalDefault() {
        return 0;
    }

    @Override
    public Group[] getGroups() {
        return new Group[0];
    }

    @Override
    public String getId() {
        return null;
    }

    @Override
    public Schema[] getImports() {
        return new Schema[]{GMLSchema.getInstance(), FilterSchema.getInstance()};
    }

    @Override
    public SimpleType[] getSimpleTypes() {
        return simpleTypes;
    }

    @Override
    public URI getTargetNamespace() {
        return NAMESPACE;
    }

    @Override
    public URI getURI() {
        try {
            return new URI("http://www.opengis.net/wfs");
        }
        catch (URISyntaxException e) {
            logger.warning(e.toString());
            return null;
        }
    }

    @Override
    public String getVersion() {
        return "1.0.0";
    }

    @Override
    public boolean includesURI(URI uri) {
        return true;
    }

    @Override
    public boolean isAttributeFormDefault() {
        return false;
    }

    @Override
    public boolean isElementFormDefault() {
        return true;
    }

    @Override
    public String getPrefix() {
        return "wfs";
    }

    public Map getImplementationHints() {
        return Collections.EMPTY_MAP;
    }

    static class WFSAttribute
    extends AttributeGT {
        private WFSAttribute() {
            super(null, null, NAMESPACE, null, 0, null, null, false);
        }

        public WFSAttribute(String name, SimpleType simpleType) {
            super(null, name, NAMESPACE, simpleType, 0, null, null, false);
        }

        public WFSAttribute(String name, SimpleType simpleType, int use) {
            super(null, name, NAMESPACE, simpleType, use, null, null, false);
        }

        public WFSAttribute(String name, SimpleType simpleType, int use, String def) {
            super(null, name, NAMESPACE, simpleType, use, def, null, false);
        }
    }

    static class WFSElement
    implements Element {
        boolean abstracT = false;
        int max;
        int min;
        String name;
        Type type;
        Element substitutionGroup;

        private WFSElement() {
        }

        public WFSElement(String name, Type type) {
            this.max = 1;
            this.min = 1;
            this.name = name;
            this.type = type;
            this.substitutionGroup = null;
        }

        public WFSElement(String name, Type type, int min, int max, boolean abstracT, Element substitutionGroup) {
            this.abstracT = abstracT;
            this.max = max;
            this.min = min;
            this.name = name;
            this.type = type;
            this.substitutionGroup = substitutionGroup;
        }

        public WFSElement(Element element, int min, int max) {
            this.abstracT = element.isAbstract();
            this.max = max;
            this.min = min;
            this.name = element.getName();
            this.type = element.getType();
            this.substitutionGroup = element.getSubstitutionGroup();
        }

        @Override
        public Element findChildElement(String name1) {
            if (this.name != null && this.name.equals(name1)) {
                return this;
            }
            return null;
        }

        @Override
        public int getGrouping() {
            return 1;
        }

        @Override
        public boolean isAbstract() {
            return this.abstracT;
        }

        @Override
        public int getBlock() {
            return 0;
        }

        @Override
        public String getDefault() {
            return null;
        }

        @Override
        public int getFinal() {
            return 0;
        }

        @Override
        public String getFixed() {
            return null;
        }

        @Override
        public boolean isForm() {
            return false;
        }

        @Override
        public String getId() {
            return null;
        }

        @Override
        public int getMaxOccurs() {
            return this.max;
        }

        @Override
        public int getMinOccurs() {
            return this.min;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isNillable() {
            return false;
        }

        @Override
        public Element getSubstitutionGroup() {
            return this.substitutionGroup;
        }

        @Override
        public Type getType() {
            return this.type;
        }

        @Override
        public URI getNamespace() {
            return NAMESPACE;
        }

        @Override
        public Element findChildElement(String localName, URI namespaceURI) {
            if (this.name != null && this.name.equals(localName) && this.getNamespace().equals(namespaceURI)) {
                return this;
            }
            return null;
        }
    }

    static abstract class WFSComplexType
    implements ComplexType {
        WFSComplexType() {
        }

        @Override
        public int getBlock() {
            return 0;
        }

        @Override
        public int getFinal() {
            return 0;
        }

        @Override
        public String getId() {
            return null;
        }

        @Override
        public boolean isMixed() {
            return false;
        }

        @Override
        public URI getNamespace() {
            return NAMESPACE;
        }

        static WFSComplexType getInstance() {
            return null;
        }

        @Override
        public boolean isDerived() {
            return false;
        }

        @Override
        public Type getParent() {
            return null;
        }

        @Override
        public boolean cache(Element element, Map hints) {
            return true;
        }

        @Override
        public String getAnyAttributeNameSpace() {
            return null;
        }

        @Override
        public Element findChildElement(String name) {
            return this.getChild() == null ? null : this.getChild().findChildElement(name);
        }

        @Override
        public boolean isAbstract() {
            return false;
        }
    }
}

