/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.test.metadata;

import java.util.Collection;
import org.opengis.test.Assert;
import org.opengis.test.Validator;
import org.opengis.test.ValidatorContainer;
import org.opengis.util.InternationalString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MetadataValidator
extends Validator {
    protected MetadataValidator(ValidatorContainer validatorContainer, String string) {
        super(validatorContainer, string);
    }

    final <T> void validateCollection(Class<T> clazz, Collection<? extends T> collection) {
        this.mandatory("Null collection. Should be an empty one if there is no elements.", collection);
        if (collection != null) {
            for (T t : collection) {
                Assert.assertNotNull((String)"Collection should not contain null element.", t);
                Assert.assertInstanceOf("Wrong element type in the collection.", clazz, t);
                this.container.dispatch(t);
            }
        }
    }

    final void validateMandatory(InternationalString internationalString) {
        this.mandatory("Missing mandatory metadata attribute.", internationalString);
        this.container.naming.validate(internationalString);
    }

    final void validateOptional(InternationalString internationalString) {
        this.container.naming.validate(internationalString);
    }
}

