/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.wcs.bindings;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.gml3.GML;
import org.geotools.metadata.iso.extent.ExtentImpl;
import org.geotools.referencing.crs.DefaultCompoundCRS;
import org.geotools.referencing.crs.DefaultTemporalCRS;
import org.geotools.temporal.object.DefaultPosition;
import org.geotools.wcs.WCS;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.TemporalCRS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LonLatEnvelopeTypeBinding
extends AbstractComplexBinding {
    public QName getTarget() {
        return WCS.LonLatEnvelopeType;
    }

    public Class getType() {
        return GeneralEnvelope.class;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        GeneralEnvelope envelope = (GeneralEnvelope)value;
        List timePositions = node.getChildren("timePosition");
        if (timePositions != null && !timePositions.isEmpty()) {
            HashMap<String, String> properties = new HashMap<String, String>(4);
            properties.put("name", "WGS84");
            properties.put("domainOfValidity", (String)ExtentImpl.WORLD);
            DefaultCompoundCRS crs = new DefaultCompoundCRS(properties, new CoordinateReferenceSystem[]{envelope.getCoordinateReferenceSystem(), DefaultTemporalCRS.TRUNCATED_JULIAN});
            double[] minCP = new double[envelope.getDimension() + 1];
            double[] maxCP = new double[envelope.getDimension() + 1];
            for (int i = 0; i < envelope.getDimension(); ++i) {
                minCP[i] = envelope.getLowerCorner().getOrdinate(i);
                maxCP[i] = envelope.getUpperCorner().getOrdinate(i);
            }
            DefaultTemporalCRS TCRS = (DefaultTemporalCRS)((CompoundCRS)crs).getCoordinateReferenceSystems().get(1);
            Node timePositionNodeBegin = (Node)timePositions.get(0);
            Node timePositionNodeEnd = (Node)timePositions.get(1);
            minCP[minCP.length - 1] = TCRS.toValue(((DefaultPosition)timePositionNodeBegin.getValue()).getDate());
            maxCP[maxCP.length - 1] = TCRS.toValue(((DefaultPosition)timePositionNodeEnd.getValue()).getDate());
            GeneralDirectPosition minDP = new GeneralDirectPosition(minCP);
            minDP.setCoordinateReferenceSystem((CoordinateReferenceSystem)crs);
            GeneralDirectPosition maxDP = new GeneralDirectPosition(maxCP);
            maxDP.setCoordinateReferenceSystem((CoordinateReferenceSystem)crs);
            GeneralEnvelope envelopeWithTime = new GeneralEnvelope(minDP, maxDP);
            return envelopeWithTime;
        }
        return envelope;
    }

    public int getExecutionMode() {
        return 0;
    }

    public Element encode(Object object, Document document, Element value) throws Exception {
        GeneralEnvelope envelope = (GeneralEnvelope)object;
        if (envelope == null) {
            value.appendChild(document.createElementNS("http://www.opengis.net/gml", GML.Null.getLocalPart()));
        }
        return null;
    }

    public Object getProperty(Object object, QName name) {
        GeneralEnvelope envelope = (GeneralEnvelope)object;
        if (envelope == null) {
            return null;
        }
        if (name.getLocalPart().equals("timePosition")) {
            CoordinateReferenceSystem crs = envelope.getCoordinateReferenceSystem();
            TemporalCRS temporalCRS = null;
            if (crs instanceof CompoundCRS) {
                List CRSs = ((DefaultCompoundCRS)crs).getCoordinateReferenceSystems();
                for (Object item : CRSs) {
                    if (!(item instanceof TemporalCRS)) continue;
                    temporalCRS = (TemporalCRS)item;
                }
            }
            if (temporalCRS != null) {
                LinkedList<DefaultPosition> envelopePositions = new LinkedList<DefaultPosition>();
                DefaultPosition beginning = new DefaultPosition(((DefaultTemporalCRS)temporalCRS).toDate(envelope.getLowerCorner().getOrdinate(envelope.getDimension() - 1)));
                DefaultPosition ending = new DefaultPosition(((DefaultTemporalCRS)temporalCRS).toDate(envelope.getUpperCorner().getOrdinate(envelope.getDimension() - 1)));
                envelopePositions.add(beginning);
                envelopePositions.add(ending);
                return envelopePositions;
            }
        }
        return null;
    }
}

