/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.impl;

public class Buffer {
    static final int DEFAULT_SIZE = 1024;
    Object[] buffer;
    int in;
    int out;
    int size;
    boolean closed;

    public Buffer() {
        this(1024);
    }

    public Buffer(int size) {
        this.buffer = new Object[size];
        this.in = 0;
        this.out = 0;
        size = 0;
        this.closed = false;
    }

    public synchronized void put(Object object) {
        while (this.size == this.buffer.length) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        this.buffer[this.in++] = object;
        this.in = this.in == this.buffer.length ? 0 : this.in;
        ++this.size;
        this.notifyAll();
    }

    public synchronized Object get() {
        while (this.size == 0) {
            if (this.closed) {
                return null;
            }
            try {
                this.wait(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        Object object = this.buffer[this.out];
        this.buffer[this.out++] = null;
        this.out = this.out == this.buffer.length ? 0 : this.out;
        --this.size;
        this.notifyAll();
        return object;
    }

    public synchronized void close() {
        this.closed = true;
        this.notifyAll();
    }
}

