/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.geoserverinterface.test;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.gcube.common.geoserverinterface.HttpMethodCall;
import org.gcube.common.geoserverinterface.cxml.CXml;
import org.gcube.common.geoserverinterface.cxml.CXmlManager;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestCsw {
    private static final String geonetworkUrl = "http://geoserver.d4science-ii.research-infrastructures.eu/geonetwork";
    private static final String gnUser = "admin";
    private static final String gnPwd = "admin";
    private static final int MAX_RECORDS = 100000;

    public static void main(String[] args) {
        long startTime = new Date().getTime();
        try {
            MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
            HttpMethodCall HMC = new HttpMethodCall(connectionManager, "http://geoserver.d4science-ii.research-infrastructures.eu/geonetwork/srv/en", "", "");
            TestCsw.login(HMC);
            int maxRecords = 10;
            int startPosition = 1;
            boolean sortByTitle = true;
            boolean sortAscendent = true;
            FILTER_TYPE filter = FILTER_TYPE.TITLE;
            String textToSearch = "eezall";
            if (maxRecords == 0) {
                maxRecords = 100000;
            }
            String cswQuery = "<csw:GetRecords xmlns:csw='http://www.opengis.net/cat/csw/2.0.2' service='CSW' version='2.0.2' resultType='results' \toutputSchema='csw:Record' maxRecords='" + maxRecords + "' startPosition='" + startPosition + "'>\n" + "<csw:Query typeNames='csw:Record'>\n" + "\t<csw:ElementName>dc:title</csw:ElementName>\n" + "\t<csw:ElementName>dc:identifier</csw:ElementName>\n" + "\t<csw:ElementName>dc:URI</csw:ElementName>\n" + "\t<csw:Constraint version='1.1.0'>\n" + "\t\t<Filter xmlns='http://www.opengis.net/ogc' xmlns:gml='http://www.opengis.net/gml'>\n" + "\t\t\t<And>\n" + "\t\t\t\t<PropertyIsNotEqualTo>\n" + "\t\t\t\t\t<PropertyName>title</PropertyName>\n" + "\t\t\t\t\t<Literal>GeoServer Web Map Service</Literal>\n" + "\t\t\t\t</PropertyIsNotEqualTo>\n" + "\t\t\t\t<Not>\n" + "\t\t\t\t\t<PropertyIsLike wildCard='*' singleChar='?' escapeChar=''>\n" + "\t\t\t\t\t\t<PropertyName>abstract</PropertyName>\n" + "\t\t\t\t\t\t<Literal>*Group*</Literal>\n" + "\t\t\t\t\t</PropertyIsLike>\n" + "\t\t\t\t</Not>\n";
            if (filter == FILTER_TYPE.TITLE || filter == FILTER_TYPE.ANY_TEXT) {
                cswQuery = String.valueOf(cswQuery) + "\t\t\t\t<PropertyIsLike wildCard='*' singleChar='?' escapeChar=''>\n\t\t\t\t\t<PropertyName>" + (filter == FILTER_TYPE.TITLE ? "title" : "AnyText") + "</PropertyName>\n" + "\t\t\t\t\t<Literal>%" + textToSearch + "%</Literal>\n" + "\t\t\t\t</PropertyIsLike>\n";
            }
            cswQuery = String.valueOf(cswQuery) + "\t\t\t</And>\n\t\t</Filter>\n\t</csw:Constraint>\n";
            if (sortByTitle) {
                cswQuery = String.valueOf(cswQuery) + "\t<ogc:SortBy xmlns:ogc='http://www.opengis.net/ogc'>\n\t\t<ogc:SortProperty>\n\t\t\t<ogc:PropertyName>title</ogc:PropertyName>\n\t\t\t<ogc:SortOrder>" + (sortAscendent ? "ASC" : "DESC") + "</ogc:SortOrder>\n" + "\t\t</ogc:SortProperty>\n" + "\t</ogc:SortBy>\n";
            }
            cswQuery = String.valueOf(cswQuery) + "</csw:Query>\n</csw:GetRecords>";
            String res = TestCsw.call(HMC, "csw", cswQuery);
            TestCsw.out(res);
            CXml result = new CXml(res);
            int nTot = Integer.parseInt(result.find("csw:SearchResults").attr("numberOfRecordsReturned"));
            result.find("csw:Record").each(new CXmlManager(){

                public void manage(int i, CXml record) {
                    String id = record.child("dc:identifier").text();
                    String title = record.child("dc:title").text();
                    String name = record.child("dc:URI").attr("name");
                    String geoserverUrl = record.child("dc:URI").text();
                    System.out.println(String.valueOf(i) + ") " + id + "\t" + title + "\t" + name + "\t" + geoserverUrl);
                }
            });
            System.out.println("OK");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("general error");
        }
        long endTime = new Date().getTime();
        System.out.println("Tempo trascorso :" + (endTime - startTime) / 1000L);
    }

    private static List<String> parseUuids(String res) {
        ArrayList<String> uuids = new ArrayList<String>();
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(res));
            Document doc = db.parse(is);
            NodeList nodes = doc.getElementsByTagName("uuid");
            int i = 0;
            while (i < nodes.getLength()) {
                Element uuid = (Element)nodes.item(i);
                uuids.add(TestCsw.getCharacterDataFromElement(uuid));
                ++i;
            }
            return uuids;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getCharacterDataFromElement(Element e) {
        Node child = e.getFirstChild();
        if (child instanceof CharacterData) {
            CharacterData cd = (CharacterData)child;
            return cd.getData();
        }
        return "?";
    }

    private static String call(HttpMethodCall HMC, String req, String xml) {
        try {
            return HMC.CallPost(req, "<?xml version='1.0' encoding='UTF-8'?>" + xml, "text/xml");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void login(HttpMethodCall HMC) throws Exception {
        HMC.CallPost("xml.user.login", "<?xml version='1.0' encoding=\"UTF-8\"?><request>\t\t<username>admin</username>\t\t<password>admin</password></request>", "text/xml");
    }

    private static void out(String res) {
        System.out.println("---------------------------------------\n" + res + "\n--------------------------------------");
    }

    private void asd() throws Exception {
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        HttpMethodCall HMC = new HttpMethodCall(connectionManager, "http://geoserver.d4science-ii.research-infrastructures.eu/geonetwork/srv/en", "", "");
        TestCsw.login(HMC);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum FILTER_TYPE {
        NO_FILTER,
        TITLE,
        ANY_TEXT;

    }
}

