/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.geoserverinterface.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import org.gcube.common.geoserverinterface.GeonetworkCommonResourceInterface;
import org.gcube.common.geoserverinterface.HttpMethodCall;
import org.gcube.common.geoserverinterface.Logger;
import org.gcube.common.geoserverinterface.bean.BoundsRest;
import org.gcube.common.geoserverinterface.bean.FeatureTypeRest;
import org.gcube.common.geoserverinterface.bean.GroupRest;
import org.gcube.common.geoserverinterface.bean.MetadataInfo;
import org.gcube.common.geoserverinterface.geonetwork.csw.MetadataISO19139;
import org.gcube.common.geoserverinterface.geonetwork.utils.StringValidator;

public class GeonetworkPutMethods {
    private HttpMethodCall HMC = null;
    private final String suffixWMS = "SERVICE=WMS";
    private final String APPLICATIONXML = "application/xml";
    private final String METADATAINSERT = "metadata.insert";
    private final String TEXTXML = "text/xml";
    private final String NOTDEFINED = "Not defined";
    private final String CSW = "csw";
    private final String ERRORGEOSERVERURL = "Error in metadata insert ... Geoserver wms url must be not empty";
    private final String ERRORLAYERNAME = "Error in metadata insert... Layer Name must be not empty";
    private final String GROUPLAYERSLIST = "Layer-Group layers list:";
    private final String XMLHARVESTINGRUN = "xml.harvesting.run";
    private final String METADATADELETE = "metadata.delete";
    private final String GROUPSTILESLIST = "Layer-Group stiles list";
    private final String INSERTMETADATA = "Insert metadata: ";
    private final String INSERTMETADATAOK = "Insert metadata <- OK";

    public GeonetworkPutMethods(HttpMethodCall hmc) {
        this.HMC = hmc;
    }

    public String insertMetadata(String fileIdentifier, String workspace, String layerTitle, String layerName, String layerDescription, GeonetworkCommonResourceInterface.GeonetworkCategory category, String geoServerWmsUrl) throws Exception {
        String res = null;
        MetadataInfo metadataInfo = this.createMetadataInfo(fileIdentifier, workspace, layerTitle, layerName, layerDescription, geoServerWmsUrl);
        MetadataISO19139 metadata = new MetadataISO19139(metadataInfo);
        String query = "<request><group>3</group><category>" + category.toString().toLowerCase() + "</category>" + "<styleSheet>_none_</styleSheet>" + "<data>" + "<![CDATA[" + metadata.getISO19139() + "]]>" + "</data>" + "</request>";
        return res;
    }

    public String insertMetadataByCswTransaction(String fileIdentifier, String workspace, String layerTitle, String layerName, String layerDescription, String geoServerWmsUrl) throws Exception {
        String res = null;
        MetadataInfo metadataInfo = this.createMetadataInfo(fileIdentifier, workspace, layerTitle, layerName, layerDescription, geoServerWmsUrl);
        MetadataISO19139 metadata = new MetadataISO19139(metadataInfo);
        String query = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><csw:Transaction xmlns:csw=\"http://www.opengis.net/cat/csw/2.0.2\" version=\"2.0.2\" service=\"CSW\"><csw:Insert>" + metadata.getISO19139() + "</csw:Insert>" + "</csw:Transaction>";
        try {
            res = this.HMC.CallPost("csw", query, "application/xml");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    private MetadataInfo createMetadataInfo(String fileIdentifier, String workspace, String title, String name, String description, String url) throws Exception {
        MetadataInfo metadataInfo = new MetadataInfo();
        if (!StringValidator.isValidateString(name)) {
            throw new Exception("Error in metadata insert... Layer Name must be not empty");
        }
        metadataInfo.setName(name);
        if (!StringValidator.isValidateString(url)) {
            throw new Exception("Error in metadata insert ... Geoserver wms url must be not empty");
        }
        url = String.valueOf(url) + "?" + "SERVICE=WMS";
        metadataInfo.setUrl(url);
        if (!StringValidator.isValidateString(fileIdentifier)) {
            metadataInfo.setFileIdentifier(UUID.randomUUID().toString());
        } else {
            metadataInfo.setFileIdentifier(fileIdentifier);
        }
        if (StringValidator.isValidateString(workspace)) {
            metadataInfo.setName(String.valueOf(workspace) + ":" + name);
        }
        if (!StringValidator.isValidateString(title)) {
            metadataInfo.setTitle("Not defined");
        } else {
            metadataInfo.setTitle(title);
        }
        if (!StringValidator.isValidateString(description)) {
            metadataInfo.setDescription("Not defined");
        } else {
            metadataInfo.setDescription(description);
        }
        return metadataInfo;
    }

    private void validateMetadataInfo(MetadataInfo metadataInfo) throws Exception {
        if (!StringValidator.isValidateString(metadataInfo.getName())) {
            throw new Exception("Error in metadata insert... Layer Name must be not empty");
        }
        if (!StringValidator.isValidateString(metadataInfo.getUrl())) {
            throw new Exception("Error in metadata insert ... Geoserver wms url must be not empty");
        }
        String url = metadataInfo.getUrl();
        url = String.valueOf(url) + "?" + "SERVICE=WMS";
        metadataInfo.setUrl(url);
        if (!StringValidator.isValidateString(metadataInfo.getFileIdentifier())) {
            metadataInfo.setFileIdentifier(UUID.randomUUID().toString());
        }
        if (StringValidator.isValidateString(metadataInfo.getWorkspace())) {
            String workspace = metadataInfo.getWorkspace();
            metadataInfo.setName(String.valueOf(workspace) + ":" + metadataInfo.getName());
        }
        if (!StringValidator.isValidateString(metadataInfo.getTitle())) {
            metadataInfo.setTitle("Not defined");
        }
        if (!StringValidator.isValidateString(metadataInfo.getDescription())) {
            metadataInfo.setDescription("Not defined");
        }
    }

    public String insertNETCDFMetadata(String TitleName, String LayerName, String description, String FileUrl) throws Exception {
        MetadataInfo metadataInfo = new MetadataInfo();
        metadataInfo.setAbst("NETCDF data file " + TitleName);
        metadataInfo.setCategory(GeonetworkCommonResourceInterface.GeonetworkCategory.DATASETS);
        metadataInfo.setDescription(description);
        metadataInfo.setEastBoundLongitude("-180");
        metadataInfo.setWestBoundLongitude("180");
        metadataInfo.setNorthBoundLongitude("90");
        metadataInfo.setSouthBoundLongitude("-90");
        metadataInfo.setTitle(TitleName);
        metadataInfo.setEnabled(true);
        metadataInfo.setUrl(FileUrl);
        metadataInfo.setName(LayerName);
        metadataInfo.setFileIdentifier(UUID.randomUUID().toString());
        return this.insertRawMetadata(metadataInfo);
    }

    public String insertRawMetadata(MetadataInfo metadataInfo) throws Exception {
        String res = null;
        MetadataISO19139 metadata = new MetadataISO19139(metadataInfo);
        String query = "<request><group>3</group><category>" + metadataInfo.getCategory().toString().toLowerCase() + "</category>" + "<styleSheet>_none_</styleSheet>" + "<data>" + "<![CDATA[" + metadata.getISO19139() + "]]>" + "</data>" + "</request>";
        try {
            res = this.HMC.CallPost("metadata.insert", query, "text/xml");
            Logger.info("Insert metadata <- OK");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    public String insertMetadata(MetadataInfo metadataInfo) throws Exception {
        String res = null;
        this.validateMetadataInfo(metadataInfo);
        MetadataISO19139 metadata = new MetadataISO19139(metadataInfo);
        String query = "<request><group>3</group><category>" + metadataInfo.getCategory().toString().toLowerCase() + "</category>" + "<styleSheet>_none_</styleSheet>" + "<data>" + "<![CDATA[" + metadata.getISO19139() + "]]>" + "</data>" + "</request>";
        try {
            res = this.HMC.CallPost("metadata.insert", query, "text/xml");
            Logger.info("Insert metadata <- OK");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    public String insertMetadataByFeatureType(FeatureTypeRest featureTypeRest, GeonetworkCommonResourceInterface.GeonetworkCategory category, String geoServerWmsUrl) throws Exception {
        String res = null;
        if (!StringValidator.isValidateString(featureTypeRest.getName())) {
            throw new Exception("Error in metadata insert... Layer Name must be not empty");
        }
        if (!StringValidator.isValidateString(geoServerWmsUrl)) {
            throw new Exception("Error in metadata insert ... Geoserver wms url must be not empty");
        }
        MetadataInfo metadataInfo = new MetadataInfo();
        metadataInfo.setFileIdentifier(UUID.randomUUID().toString());
        metadataInfo.setName(featureTypeRest.getName());
        if (!StringValidator.isValidateString(featureTypeRest.getTitle())) {
            metadataInfo.setTitle("Not defined");
        } else {
            metadataInfo.setTitle(featureTypeRest.getTitle());
        }
        BoundsRest bounds = featureTypeRest.getNativeBoundingBox();
        metadataInfo.setWestBoundLongitude(String.valueOf(bounds.getMinx()));
        metadataInfo.setEastBoundLongitude(String.valueOf(bounds.getMaxx()));
        metadataInfo.setSouthBoundLongitude(String.valueOf(bounds.getMiny()));
        metadataInfo.setNorthBoundLongitude(String.valueOf(bounds.getMaxy()));
        if (StringValidator.isValidateString(featureTypeRest.getWorkspace())) {
            metadataInfo.setName(String.valueOf(featureTypeRest.getWorkspace()) + ":" + featureTypeRest.getName());
        }
        geoServerWmsUrl = String.valueOf(geoServerWmsUrl) + "?" + "SERVICE=WMS";
        metadataInfo.setUrl(geoServerWmsUrl);
        MetadataISO19139 metadata = new MetadataISO19139(metadataInfo);
        String query = "<request><group>3</group><category>" + category.toString().toLowerCase() + "</category>" + "<styleSheet>_none_</styleSheet>" + "<data>" + "<![CDATA[" + metadata.getISO19139() + "]]>" + "</data>" + "</request>";
        try {
            res = this.HMC.CallPost("metadata.insert", query, "text/xml");
            Logger.info("Insert metadata <- OK");
            return res;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String insertMetadataByGroupRest(GroupRest groupRest, GeonetworkCommonResourceInterface.GeonetworkCategory category, String geoServerWmsUrl) throws Exception {
        String res = null;
        if (!StringValidator.isValidateString(groupRest.getName())) {
            throw new Exception("Error in metadata insert... Layer Name must be not empty");
        }
        if (!StringValidator.isValidateString(geoServerWmsUrl)) {
            throw new Exception("Error in metadata insert ... Geoserver wms url must be not empty");
        }
        MetadataInfo metadataInfo = new MetadataInfo();
        metadataInfo.setFileIdentifier(UUID.randomUUID().toString());
        metadataInfo.setName(groupRest.getName());
        metadataInfo.setTitle(groupRest.getName());
        ArrayList<String> groupList = groupRest.getLayers();
        String tempAbs = "Layer-Group layers list:";
        for (String layer : groupList) {
            tempAbs = String.valueOf(tempAbs) + " " + layer + " ";
        }
        metadataInfo.setAbst(tempAbs);
        String description = "Layer-Group stiles list";
        Collection<String> stylesList = groupRest.getStyles();
        for (String style : stylesList) {
            description = String.valueOf(description) + " " + style + " ";
        }
        geoServerWmsUrl = String.valueOf(geoServerWmsUrl) + "?" + "SERVICE=WMS";
        metadataInfo.setUrl(geoServerWmsUrl);
        metadataInfo.setDescription(description);
        MetadataISO19139 metadata = new MetadataISO19139(metadataInfo);
        String query = "<request><group>3</group><category>" + category.toString().toLowerCase() + "</category>" + "<styleSheet>_none_</styleSheet>" + "<data>" + "<![CDATA[" + metadata.getISO19139() + "]]>" + "</data>" + "</request>";
        try {
            res = this.HMC.CallPost("metadata.insert", query, "text/xml");
            Logger.info("Insert metadata <- OK");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    public String deleteMetadataById(String id) {
        String res = null;
        try {
            res = this.HMC.CallPost("metadata.delete", "<?xml version=\"1.0\" encoding=\"UTF-8\"?><request><id>" + id + "</id>" + "</request>", "application/xml");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    public String updateHarvesting(String id) {
        String res = null;
        try {
            res = this.HMC.CallPost("xml.harvesting.run", "<?xml version=\"1.0\" encoding=\"UTF-8\"?><request> <id>" + id + "</id>" + "</request>", "application/xml");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }
}

