/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.gxrest.request;

import java.util.Objects;
import org.gcube.common.gxrest.request.GXConnection;
import org.gcube.common.gxrest.request.GXHTTP;
import org.gcube.common.gxrest.request.GXHTTPCommon;
import org.gcube.common.gxrest.response.inbound.GXInboundResponse;

public class GXHTTPStringRequest
extends GXHTTPCommon<GXHTTPStringRequest>
implements GXHTTP<String> {
    private GXHTTPStringRequest(String address) {
        this.connection = new GXConnection(address);
    }

    public static GXHTTPStringRequest newRequest(String address) {
        return new GXHTTPStringRequest(address);
    }

    public GXHTTPStringRequest withBody(String body) {
        this.connection.addBody(body);
        return this;
    }

    @Override
    public GXInboundResponse put(String body) throws Exception {
        if (Objects.nonNull(body)) {
            this.connection.addBody(body);
        }
        logger.trace("Sending a PUT request...");
        return this.connection.send(GXConnection.HTTPMETHOD.PUT);
    }

    @Override
    public GXInboundResponse post(String body) throws Exception {
        logger.trace("Sending a POST request...");
        if (Objects.nonNull(body)) {
            this.connection.addBody(body);
        }
        return this.connection.send(GXConnection.HTTPMETHOD.POST);
    }
}

