/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.gxrest.response.entity;

import org.gcube.common.gxrest.response.entity.StackTraceEncoder;
import org.gcube.common.gxrest.response.outbound.ErrorCode;

public class SerializableErrorEntity {
    private int id = -1;
    private String message;
    private String exceptionClass;
    private String encodedTrace = "";

    public SerializableErrorEntity() {
    }

    public SerializableErrorEntity(ErrorCode errorCode) {
        this.id = errorCode.getId();
        this.message = errorCode.getMessage();
    }

    public SerializableErrorEntity(Exception e) {
        this.exceptionClass = e.getClass().getCanonicalName();
        this.message = e.getMessage();
    }

    public SerializableErrorEntity(Exception e, int lines) {
        this.exceptionClass = e.getClass().getCanonicalName();
        this.message = e.getMessage();
        this.encodedTrace = StackTraceEncoder.encodeTrace(e.getStackTrace(), lines);
    }

    public int getId() {
        return this.id;
    }

    public String getMessage() {
        return this.message;
    }

    public String getExceptionClass() {
        return this.exceptionClass;
    }

    public String getEncodedTrace() {
        return this.encodedTrace;
    }

    public boolean hasStackTrace() {
        return !this.encodedTrace.isEmpty();
    }
}

