/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.entities.mapper.relation.query;

import java.util.Collections;
import org.hibernate.Query;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.configuration.AuditEntitiesConfiguration;
import org.hibernate.envers.entities.mapper.id.QueryParameterData;
import org.hibernate.envers.entities.mapper.relation.MiddleComponentData;
import org.hibernate.envers.entities.mapper.relation.MiddleIdData;
import org.hibernate.envers.entities.mapper.relation.query.RelationQueryGenerator;
import org.hibernate.envers.reader.AuditReaderImplementor;
import org.hibernate.envers.tools.query.Parameters;
import org.hibernate.envers.tools.query.QueryBuilder;

public final class OneEntityQueryGenerator
implements RelationQueryGenerator {
    private final String queryString;
    private final MiddleIdData referencingIdData;

    public OneEntityQueryGenerator(AuditEntitiesConfiguration verEntCfg, String versionsMiddleEntityName, MiddleIdData referencingIdData, MiddleComponentData ... componentDatas) {
        this.referencingIdData = referencingIdData;
        String revisionPropertyPath = verEntCfg.getRevisionNumberPath();
        String originalIdPropertyName = verEntCfg.getOriginalIdPropName();
        QueryBuilder qb = new QueryBuilder(versionsMiddleEntityName, "ee");
        qb.addProjection("new list", "ee", false, false);
        Parameters rootParameters = qb.getRootParameters();
        referencingIdData.getPrefixedMapper().addNamedIdEqualsToQuery(rootParameters, originalIdPropertyName, true);
        QueryBuilder maxRevQb = qb.newSubQueryBuilder(versionsMiddleEntityName, "ee2");
        maxRevQb.addProjection("max", revisionPropertyPath, false);
        Parameters maxRevQbParameters = maxRevQb.getRootParameters();
        maxRevQbParameters.addWhereWithNamedParam(revisionPropertyPath, "<=", "revision");
        String eeOriginalIdPropertyPath = "ee." + originalIdPropertyName;
        String ee2OriginalIdPropertyPath = "ee2." + originalIdPropertyName;
        referencingIdData.getPrefixedMapper().addIdsEqualToQuery(maxRevQbParameters, eeOriginalIdPropertyPath, ee2OriginalIdPropertyPath);
        for (MiddleComponentData componentData : componentDatas) {
            componentData.getComponentMapper().addMiddleEqualToQuery(maxRevQbParameters, eeOriginalIdPropertyPath, ee2OriginalIdPropertyPath);
        }
        rootParameters.addWhere(revisionPropertyPath, "=", maxRevQb);
        rootParameters.addWhereWithNamedParam(verEntCfg.getRevisionTypePropName(), "!=", "delrevisiontype");
        StringBuilder sb = new StringBuilder();
        qb.build(sb, Collections.<String, Object>emptyMap());
        this.queryString = sb.toString();
    }

    public Query getQuery(AuditReaderImplementor versionsReader, Object primaryKey, Number revision) {
        Query query = versionsReader.getSession().createQuery(this.queryString);
        query.setParameter("revision", (Object)revision);
        query.setParameter("delrevisiontype", (Object)RevisionType.DEL);
        for (QueryParameterData paramData : this.referencingIdData.getPrefixedMapper().mapToQueryParametersFromId(primaryKey)) {
            paramData.setParameterValue(query);
        }
        return query;
    }
}

