package org.gcube.common.homelibrary.jcr.workspace.search;

import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.RepositoryException;

import org.gcube.common.homelibrary.home.workspace.WorkspaceItemType;
import org.gcube.common.homelibrary.home.workspace.search.SearchFolder;
import org.gcube.common.homelibrary.jcr.JCRUser;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceItem;

public class JCRSearchFolder implements SearchFolder {

	private final String id;
	private final Calendar creationDate;
	private final Calendar lastModified;
	private final String owner;
	private final String type;
	
	protected String name;
	
	public JCRSearchFolder(Node node, String name) throws RepositoryException{
		
		this.id = node.getIdentifier();
		this.name = name;
		this.creationDate = node.getProperty(JCRWorkspaceItem.CREATED).getDate();
		this.lastModified = node.getProperty(JCRWorkspaceItem.LAST_MODIFIED).getDate();
		
		Node nodeOwner = null;
		try{
			nodeOwner = node.getNode(JCRWorkspaceItem.OWNER);
		}catch (Exception e) {
			// TODO: handle exception
		}
		
		this.owner = nodeOwner.getProperty(JCRWorkspaceItem.PORTAL_LOGIN).getString();
		this.type = node.getPrimaryNodeType().getName();
System.out.println("type " + this.type);
	}
	
	
	@Override
	public String getId() {
		return id;
	}

	@Override
	public String getName() {
		return name;
	}

	@Override
	public Calendar getCreationDate() {
		return creationDate;
	}

	@Override
	public Calendar getLastModified() {		
		return lastModified;
	}
	
	@Override
	public String getOwner() {
		return owner;
	}
	
	@Override
	public WorkspaceItemType getType() {
		
		if (type.equals(JCRWorkspace.NT_WORKSPACE_SHARED_FOLDER))
			return WorkspaceItemType.SHARED_FOLDER;
			
		return WorkspaceItemType.FOLDER;

	}


	
}
