/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.accessmanager;

import com.thoughtworks.xstream.XStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlList;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.Privilege;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.accessmanager.AccessManager;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRAccessManager
implements AccessManager {
    private Logger logger = LoggerFactory.getLogger(JCRAccessManager.class);
    public static final String JUST_OWNER = "hl:justOwner";
    public static String url;

    public JCRAccessManager() {
        url = JCRRepository.url;
    }

    public Map<String, List<String>> getACL(String absPath) throws InternalErrorException {
        Session session = JCRRepository.getSession();
        ArrayList<AccessControlEntry> allEntries = null;
        try {
            AccessControlPolicy[] policies;
            allEntries = new ArrayList<AccessControlEntry>();
            AccessControlManager accessControlManager = session.getAccessControlManager();
            AccessControlPolicy[] accessControlPolicyArray = policies = accessControlManager.getPolicies(absPath);
            int n = policies.length;
            int n2 = 0;
            while (n2 < n) {
                AccessControlPolicy accessControlPolicy = accessControlPolicyArray[n2];
                if (accessControlPolicy instanceof AccessControlList) {
                    AccessControlEntry[] accessControlEntries;
                    AccessControlEntry[] accessControlEntryArray = accessControlEntries = ((AccessControlList)accessControlPolicy).getAccessControlEntries();
                    int n3 = accessControlEntries.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        AccessControlEntry accessControlEntry = accessControlEntryArray[n4];
                        allEntries.add(accessControlEntry);
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        catch (RepositoryException e) {
            this.logger.error("Error getting ACL in AccessManager for node: " + absPath, (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        Map<String, List<String>> map = this.getMap(allEntries);
        return map;
    }

    public void modifyAce(List<String> users, String absPath, List<String> privilegesList, String order) throws InternalErrorException {
        try {
            this.deleteAces(absPath, users);
        }
        catch (Exception e) {
            this.logger.error("Error deleting old ACLs: " + e);
            throw new InternalErrorException((Throwable)e);
        }
        GetMethod getMethod = null;
        try {
            try {
                HttpClient httpClient = new HttpClient();
                StringBuilder privileges = new StringBuilder();
                for (String privilege : privilegesList) {
                    privileges.append("&privilege@" + privilege);
                }
                if (order == null) {
                    order = "first";
                }
                for (String user : users) {
                    try {
                        String requestUrl = String.valueOf(url) + "/ModifyAceServlet?principalId=" + user + "&resourcePath=" + absPath + privileges.toString() + "&order=" + order;
                        this.logger.debug(requestUrl);
                        getMethod = new GetMethod(requestUrl);
                        httpClient.executeMethod((HttpMethod)getMethod);
                        this.logger.debug("Response " + getMethod.getResponseBodyAsString());
                        if (getMethod == null) continue;
                        getMethod.releaseConnection();
                    }
                    catch (Exception e) {
                        this.logger.error("Error deleting old ACLs: " + e);
                        throw new InternalErrorException((Throwable)e);
                    }
                }
                XStream xstream = new XStream();
                Boolean modified = true;
                try {
                    modified = (Boolean)xstream.fromXML(getMethod.getResponseBodyAsString());
                }
                catch (Exception e) {
                    this.logger.error("Error in Modify ace", (Throwable)e);
                }
            }
            catch (Exception e) {
                this.logger.error("Error in Add or Modify Permissions in AccessManager", (Throwable)e);
                throw new InternalErrorException((Throwable)e);
            }
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
    }

    public Map<String, List<String>> getEACL(String absPath) throws InternalErrorException {
        Session session = JCRRepository.getSession();
        ArrayList<AccessControlEntry> allEntries = null;
        try {
            AccessControlPolicy[] policies;
            allEntries = new ArrayList<AccessControlEntry>();
            AccessControlManager accessControlManager = session.getAccessControlManager();
            AccessControlPolicy[] accessControlPolicyArray = policies = accessControlManager.getEffectivePolicies(absPath);
            int n = policies.length;
            int n2 = 0;
            while (n2 < n) {
                AccessControlPolicy accessControlPolicy = accessControlPolicyArray[n2];
                if (accessControlPolicy instanceof AccessControlList) {
                    AccessControlEntry[] accessControlEntries;
                    AccessControlEntry[] accessControlEntryArray = accessControlEntries = ((AccessControlList)accessControlPolicy).getAccessControlEntries();
                    int n3 = accessControlEntries.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        AccessControlEntry accessControlEntry = accessControlEntryArray[n4];
                        allEntries.add(accessControlEntry);
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        catch (RepositoryException e) {
            this.logger.error("Error getting Effective ACL for node: " + absPath, (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        Map<String, List<String>> map = this.getMap(allEntries);
        this.logger.debug("ACL map: " + map.toString());
        return map;
    }

    private Map<String, List<String>> getMap(List<AccessControlEntry> allEntries) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (AccessControlEntry entry : allEntries) {
            ArrayList<String> privilegesList = null;
            String key = entry.getPrincipal().getName();
            if (key.equals("everyone")) continue;
            try {
                privilegesList = (ArrayList<String>)map.get(key);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Privilege[] privileges = entry.getPrivileges();
            int i = 0;
            while (i < privileges.length) {
                if (privilegesList == null) {
                    privilegesList = new ArrayList<String>();
                }
                privilegesList.add(privileges[i].getName());
                ++i;
            }
            map.put(entry.getPrincipal().getName(), (List<String>)privilegesList);
        }
        return map;
    }

    public void setReadOnlyACL(List<String> users, String absPath) throws InternalErrorException {
        ArrayList<String> privileges = new ArrayList<String>();
        privileges.add("jcr:read=granted");
        try {
            this.modifyAce(users, absPath, privileges, null);
        }
        catch (Exception e) {
            this.logger.error("Error setting Read-only Ace", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
    }

    public void setWriteOwnerACL(List<String> users, String absPath) throws InternalErrorException {
        this.logger.debug("setAuthorAce - users: " + users.toString() + " - absPath: " + absPath);
        try {
            ArrayList<String> privileges = new ArrayList<String>();
            privileges.add("jcr:write=granted");
            try {
                this.modifyAce(users, absPath, privileges, null);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new InternalErrorException((Throwable)e);
            }
            this.logger.debug("Ace modified");
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public void setWriteAllACL(List<String> users, String absPath) throws InternalErrorException {
        ArrayList<String> privileges = new ArrayList<String>();
        privileges.add("hl:writeAll=granted");
        try {
            this.modifyAce(users, absPath, privileges, null);
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public void setAdminACL(List<String> users, String absPath) throws InternalErrorException {
        ArrayList<String> privileges = new ArrayList<String>();
        privileges.add("jcr:all=granted");
        try {
            this.modifyAce(users, absPath, privileges, null);
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public void deleteAces(String resourcePath, List<String> users) throws InternalErrorException {
        GetMethod getMethod = null;
        try {
            try {
                HttpClient httpClient = new HttpClient();
                StringBuilder applyTo = new StringBuilder();
                for (String user : users) {
                    applyTo.append("&applyTo=" + user);
                }
                try {
                    String requestUrl = String.valueOf(url) + "/DeleteAcesServlet?absPath=" + resourcePath + applyTo;
                    this.logger.debug(requestUrl);
                    getMethod = new GetMethod(requestUrl);
                    httpClient.executeMethod((HttpMethod)getMethod);
                    this.logger.debug("Response " + getMethod.getResponseBodyAsString());
                    if (getMethod != null) {
                        getMethod.releaseConnection();
                    }
                }
                catch (Exception requestUrl) {
                    // empty catch block
                }
                XStream xstream = new XStream();
                Boolean modified = true;
                try {
                    modified = (Boolean)xstream.fromXML(getMethod.getResponseBodyAsString());
                }
                catch (Exception e) {
                    this.logger.error("Error in Modify ace", (Throwable)e);
                }
            }
            catch (Exception e) {
                this.logger.error("Error deleting Permissions in AccessManager", (Throwable)e);
                throw new InternalErrorException((Throwable)e);
            }
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
    }
}

