package org.gcube.common.homelibrary.jcr.workspace.folder.items;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.Calendar;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;

import org.apache.commons.lang.Validate;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItemType;
import org.gcube.common.homelibrary.home.workspace.folder.items.ReportTemplate;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;

public class JCRReportTemplate extends JCRWorkspaceFolderItem implements
		ReportTemplate {
	
	private static final String CREATED  			= "hl:created";
	private static final String LAST_EDIT 			= "hl:lastEdit";
	private static final String AUTHOR 				= "hl:author";
	private static final String LAST_EDIT_BY 		= "hl:lastEditBy";
	private static final String NUMBER_OF_SECTION 	= "hl:numberOfSection";
	private static final String STATUS				= "hl:status";
	
	private static final String NT_CONTENT			= "nthl:reportTemplateContent";
	
	
	private final JCRFile file;
	
	public JCRReportTemplate(JCRWorkspace workspace, Node node) throws RepositoryException, InternalErrorException {
		super(workspace, node);
		
		Node nodeContent = node.getNode(CONTENT);
		this.file = new JCRFile(workspace, nodeContent);
	}
	
	public JCRReportTemplate(JCRWorkspace workspace,Node node, String name,
			String description, Calendar created, Calendar lastEdit,
			String author, String lastEditBy, int numberOfSections, String status,
			InputStream templateData) throws RepositoryException, RemoteBackendException  {
		super(workspace,node,name,description);
		
		Validate.notNull(created, "Created must be not null");
		Validate.notNull(lastEdit, "LastEdit must be not null");
		Validate.notNull(author, "Author must be not null");
		Validate.notNull(lastEditBy, "LastEditBy must be not null");
		Validate.notNull(status, "Status must be not null");
		Validate.notNull(templateData, "TemplateData must be not null");
		
		node.setProperty(FOLDER_ITEM_TYPE, FolderItemType.REPORT_TEMPLATE.toString());
		
		Node contentNode = node.addNode(CONTENT,NT_CONTENT);
		this.file = new JCRFile(workspace, contentNode, new BufferedInputStream(templateData));
		contentNode.setProperty(AUTHOR,author);
		contentNode.setProperty(CREATED, created);
		contentNode.setProperty(LAST_EDIT, lastEdit);
		contentNode.setProperty(LAST_EDIT_BY, lastEditBy);
		contentNode.setProperty(NUMBER_OF_SECTION, numberOfSections);
		contentNode.setProperty(STATUS, status);
	}

	@Override
	public long getLength() throws InternalErrorException {
		return file.getLength();
	}

	@Override
	public InputStream getData() throws InternalErrorException {
		return file.getData();
	}

	@Override
	public Calendar getCreated() {
		
		Session session = null;
		try {
			session = JCRRepository.getSession();
			Node node = session.getNodeByIdentifier(identifier);
			Node contentNode = node.getNode(CONTENT);
			return contentNode.getProperty(CREATED).getDate();
		} catch (Exception e) {
			throw new RuntimeException(e) ;
		} finally {
			if(session != null)
				session.logout();
		}	
		
	}

	@Override
	public Calendar getLastEdit() {
		
		Session session = null;
		try {
			session = JCRRepository.getSession();
			Node node = session.getNodeByIdentifier(identifier);
			Node contentNode = node.getNode(CONTENT);
			return contentNode.getProperty(LAST_EDIT).getDate();
		} catch (Exception e) {
			throw new RuntimeException(e) ;
		} finally {
			if(session != null)
				session.logout();
		}	
		
		
	}

	@Override
	public String getAuthor() {
		
		Session session = null;
		try {
			session = JCRRepository.getSession();
			Node node = session.getNodeByIdentifier(identifier);
			Node contentNode = node.getNode(CONTENT);
			return contentNode.getProperty(AUTHOR).getString();
		} catch (Exception e) {
			throw new RuntimeException(e) ;
		} finally {
			if(session != null)
				session.logout();
		}	
	}

	@Override
	public String getLastEditBy() {
		
		Session session = null;
		try {
			session = JCRRepository.getSession();
			Node node = session.getNodeByIdentifier(identifier);
			Node contentNode = node.getNode(CONTENT);
			return contentNode.getProperty(LAST_EDIT_BY).getString();
		} catch (Exception e) {
			throw new RuntimeException(e) ;
		} finally {
			if(session != null)
				session.logout();
		}	
	}

	@Override
	public int getNumberOfSections() {
		
		Session session = null;
		try {
			session = JCRRepository.getSession();
			Node node = session.getNodeByIdentifier(identifier);
			Node contentNode = node.getNode(CONTENT);
			return (int)contentNode.getProperty(NUMBER_OF_SECTION).getLong();
		} catch (Exception e) {
			throw new RuntimeException(e) ;
		} finally {
			if(session != null)
				session.logout();
		}	
	}

	@Override
	public String getStatus() {
		
		Session session = null;
		try {
			session = JCRRepository.getSession();
			Node node = session.getNodeByIdentifier(identifier);
			Node contentNode = node.getNode(CONTENT);
			return contentNode.getProperty(STATUS).getString();
		} catch (Exception e) {
			throw new RuntimeException(e) ;
		} finally {
			if(session != null)
				session.logout();
		}	
		
	}

	@Override
	public FolderItemType getFolderItemType() {
		return FolderItemType.REPORT_TEMPLATE;
	}

	@Override
	public void saveContent(Node node) throws RepositoryException {
		file.save(node);
		
	}

	@Override
	public String getMimeType() throws InternalErrorException {
		return null;
	}

}
