package org.gcube.common.homelibrary.jcr.workspace.folder.items.gcube;

import java.io.InputStream;
import java.util.Map;

import javax.jcr.Node;
import javax.jcr.RepositoryException;

import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItemType;
import org.gcube.common.homelibrary.home.workspace.folder.items.gcube.PDFDocument;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.ContentType;
import org.gcube.common.homelibrary.jcr.workspace.folder.items.JCRPDFFile;

public class JCRPDFDocument extends JCRDocument implements PDFDocument {
	
	public JCRPDFDocument(JCRWorkspace workspace, Node node) throws RepositoryException, InternalErrorException {
		super(workspace, node, ContentType.PDF);
	}
	
	public JCRPDFDocument(JCRWorkspace workspace, Node node, String name,
			String description, String objectId, String mimeType,
			InputStream documentData, Map<String, String> metadata,
			Map<String, String> annotations, String collectionName)
			throws RepositoryException, InternalErrorException {
		super(workspace, node, name, description, objectId, mimeType,ContentType.PDF,
				documentData,metadata, annotations, collectionName);
		
		node.setProperty(FOLDER_ITEM_TYPE, FolderItemType.PDF_DOCUMENT.toString());
		
	}

	@Override
	public int getNumberOfPages() {	
		return ((JCRPDFFile)documentContent).getNumberOfPages();
	}

	@Override
	public String getVersion() {
		return ((JCRPDFFile)documentContent).getVersion();
	}

	@Override
	public String getAuthor() {
		return ((JCRPDFFile)documentContent).getAuthor();
	}

	@Override
	public String getTitle() {
		return ((JCRPDFFile)documentContent).getTitle();
	}

	@Override
	public String getProducer() {
		return ((JCRPDFFile)documentContent).getProducer();
	}
	
	@Override
	public FolderItemType getFolderItemType() {
		return FolderItemType.PDF_DOCUMENT;
	}

}
