/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.accounting;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.gcube.common.homelibrary.home.workspace.accounting.AccountingEntry;
import org.gcube.common.homelibrary.home.workspace.accounting.AccountingEntryType;

public abstract class JCRAccountingEntry
implements AccountingEntry {
    private static final String USER = "hl:user";
    private static final String DATE = "hl:date";
    private String user;
    private Calendar date;

    public JCRAccountingEntry(Node node) throws RepositoryException {
        this.user = node.getProperty(USER).getString();
        this.date = node.getProperty(DATE).getDate();
    }

    public JCRAccountingEntry(String user, Calendar date) {
        this.user = user;
        this.date = date;
    }

    public abstract AccountingEntryType getEntryType();

    public String getUser() {
        return this.user;
    }

    public Calendar getDate() {
        return this.date;
    }

    public void save(Node entryNode) throws RepositoryException {
        entryNode.setProperty(USER, this.user);
        entryNode.setProperty(DATE, this.date);
    }

    public String toString() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return String.format("[ user:%s, date:%s ]", this.user, sdf.format(this.date.getTime()));
    }
}

