package org.gcube.common.homelibrary.jcr.workspace.servlet.wrapper;

import java.util.List;

import org.apache.jackrabbit.util.Text;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.util.WorkspaceItemAction;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;

public class DelegateManager{

	ItemDelegate item;
	String login;


	public DelegateManager(ItemDelegate item, String login){
//		System.out.println("delegate " + item.toString());
		this.item = item;
		this.login = login;
	}


	public DelegateManager(String name, String type, String parentId) {
		item.setName(name);
		item.setPrimaryType(type);
		item.setParentId(parentId);
	}

	public ItemDelegate save() throws Exception {
		
//		ItemDelegate delegate = JCRRepository.getServlets().saveItem(item);
//		item.setId(delegate.getId());
//		item.setPath(delegate.getPath());
//		item.setCreationTime(delegate.getCreationTime());
//		item.setLastModificationTime(delegate.getLastModificationTime());
//		System.out.println("---> " + item.toString());
		ItemDelegate saved = JCRRepository.getServlets().saveItem(item);
//		System.out.println("item saved " +  item.toString());
		return saved;
	}
	
	public void save(ItemDelegate itemDelegate) throws Exception {
		ItemDelegate delegate = JCRRepository.getServlets().saveItem(itemDelegate);
		itemDelegate.setId(delegate.getId());
		itemDelegate.setPath(delegate.getPath());
		itemDelegate.setCreationTime(delegate.getCreationTime());
		itemDelegate.setLastModificationTime(delegate.getLastModificationTime());

		
	}


	public ItemDelegate getParent() {
		ItemDelegate parent = null;
		try{
			parent = JCRRepository.getServlets().getItemById(item.getParentId());
		}catch (Exception e) {
			e.printStackTrace();
		}
		return parent;

	}


	public List<ItemDelegate> getNodes() {
		List<ItemDelegate> children = null;
		try{
			children = JCRRepository.getServlets().getChildrenById(item.getId(), login);
		}catch (Exception e) {

		}
		return children;
	}

	/**
	 * Remove an Item Delegate by absolute path
	 */
	public void remove() {
		try{
			JCRRepository.getServlets().removeItem(item.getPath());
		}catch (Exception e) {
			e.printStackTrace();
		}

	}

	public ItemDelegate addNode(String name, String type) {
		ItemDelegate delegate = new ItemDelegate();
		delegate.setName(name);
		if (type!=null)
			delegate.setPrimaryType(type);
		delegate.setParentId(item.getId());
		delegate.setLastAction(WorkspaceItemAction.CREATED);
		return delegate;
	}

	
	public ItemDelegate addNode(String name) {
		ItemDelegate delegate = new ItemDelegate();
		delegate.setName(name);
		delegate.setParentId(item.getId());
		return delegate;
	}
	
	/**
	 * Get ItemDelegate by relative Path
	 * @param relativePath
	 * @return
	 * @throws ItemNotFoundException 
	 */
	public ItemDelegate getNode(String name) throws ItemNotFoundException {

		ItemDelegate delegate = null;
		try {
			delegate = JCRRepository.getServlets().getItemByPath(item.getPath() + "/" + Text.escapeIllegalJcrChars(name), login);
		} catch (ItemNotFoundException e) {
			throw new ItemNotFoundException(e.toString());
		}
		return delegate;

	}



}