/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.accessmanager;

import com.thoughtworks.xstream.XStream;
import java.net.URLEncoder;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlList;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.Privilege;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.accessmanager.AccessManager;
import org.gcube.common.homelibrary.jcr.repository.JCRRepository;
import org.gcube.common.homelibrary.jcr.workspace.accessmanager.AccessControlUtil;
import org.gcube.common.homelibrary.jcr.workspace.accessmanager.JCRPrivilegesInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRAccessManager
implements AccessManager {
    private Logger logger = LoggerFactory.getLogger(JCRAccessManager.class);
    public static final String JUST_OWNER = "hl:justOwner";
    public static String url;

    public JCRAccessManager() {
        url = JCRRepository.url;
    }

    public Map<String, List<String>> getACL(String absPath) throws InternalErrorException {
        Session session = JCRRepository.getSession();
        ArrayList<AccessControlEntry> allEntries = null;
        try {
            AccessControlPolicy[] policies;
            allEntries = new ArrayList<AccessControlEntry>();
            AccessControlManager accessControlManager = session.getAccessControlManager();
            for (AccessControlPolicy accessControlPolicy : policies = accessControlManager.getPolicies(absPath)) {
                AccessControlEntry[] accessControlEntries;
                if (!(accessControlPolicy instanceof AccessControlList)) continue;
                for (AccessControlEntry accessControlEntry : accessControlEntries = ((AccessControlList)accessControlPolicy).getAccessControlEntries()) {
                    allEntries.add(accessControlEntry);
                }
            }
        }
        catch (RepositoryException e) {
            this.logger.error("Error getting ACL in AccessManager for node: " + absPath, (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        Map<String, List<String>> map = this.getMap(allEntries);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean modifyAce(List<String> users, String absPath, List<String> privilegesList, String order) throws InternalErrorException {
        Boolean modified = true;
        try {
            this.deleteAces(absPath, users);
        }
        catch (Exception e) {
            this.logger.error("Error deleting old ACLs: " + e);
            throw new InternalErrorException((Throwable)e);
        }
        GetMethod getMethod = null;
        try {
            HttpClient httpClient = new HttpClient();
            StringBuilder privileges = new StringBuilder();
            for (String privilege : privilegesList) {
                privileges.append("&privilege@" + privilege);
            }
            if (order == null) {
                order = "first";
            }
            for (String user : users) {
                try {
                    String requestUrl = url + "/ModifyAceServlet?" + JCRRepository.getCredentials() + "&principalId=" + user + "&resourcePath=" + URLEncoder.encode(absPath, "UTF-8") + privileges.toString() + "&order=" + order;
                    this.logger.debug(requestUrl);
                    getMethod = new GetMethod(requestUrl);
                    httpClient.executeMethod((HttpMethod)getMethod);
                    this.logger.debug("Response " + getMethod.getResponseBodyAsString());
                    if (getMethod == null) continue;
                    getMethod.releaseConnection();
                }
                catch (Exception e) {
                    this.logger.error("Error modifing ACLs: " + e);
                    throw new InternalErrorException((Throwable)e);
                }
            }
            XStream xstream = new XStream();
            try {
                modified = (Boolean)xstream.fromXML(getMethod.getResponseBodyAsString());
            }
            catch (Exception e) {
                modified = false;
                this.logger.error("Error in Modify ace", (Throwable)e);
            }
        }
        catch (Exception e) {
            this.logger.error("Error in Add or Modify Permissions in AccessManager", (Throwable)e);
            modified = false;
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return modified;
    }

    public Map<String, List<String>> getEACL(String absPath) throws InternalErrorException {
        Session session = JCRRepository.getSession();
        ArrayList<AccessControlEntry> allEntries = null;
        try {
            AccessControlPolicy[] policies;
            allEntries = new ArrayList<AccessControlEntry>();
            AccessControlManager accessControlManager = session.getAccessControlManager();
            for (AccessControlPolicy accessControlPolicy : policies = accessControlManager.getEffectivePolicies(absPath)) {
                AccessControlEntry[] accessControlEntries;
                if (!(accessControlPolicy instanceof AccessControlList)) continue;
                for (AccessControlEntry accessControlEntry : accessControlEntries = ((AccessControlList)accessControlPolicy).getAccessControlEntries()) {
                    allEntries.add(accessControlEntry);
                }
            }
        }
        catch (RepositoryException e) {
            this.logger.error("Error getting Effective ACL for node: " + absPath, (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        Map<String, List<String>> map = this.getMap(allEntries);
        this.logger.debug("ACL map on " + absPath + " : " + map.toString());
        return map;
    }

    private Map<String, List<String>> getMap(List<AccessControlEntry> allEntries) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (AccessControlEntry entry : allEntries) {
            ArrayList<String> privilegesList = null;
            String key = entry.getPrincipal().getName();
            if (key.equals("everyone")) continue;
            try {
                privilegesList = (ArrayList<String>)map.get(key);
            }
            catch (Exception e) {
                // empty catch block
            }
            Privilege[] privileges = entry.getPrivileges();
            for (int i = 0; i < privileges.length; ++i) {
                if (privilegesList == null) {
                    privilegesList = new ArrayList<String>();
                }
                privilegesList.add(privileges[i].getName());
            }
            map.put(entry.getPrincipal().getName(), privilegesList);
        }
        return map;
    }

    public boolean setReadOnlyACL(List<String> users, String absPath) throws InternalErrorException {
        boolean flag = true;
        ArrayList<String> privileges = new ArrayList<String>();
        privileges.add("jcr:read=granted");
        try {
            flag = this.modifyAce(users, absPath, privileges, null);
        }
        catch (Exception e) {
            this.logger.error("Error setting WriteOwner to users " + users.toString() + " to path " + absPath);
            flag = false;
        }
        return flag;
    }

    public boolean setWriteOwnerACL(List<String> users, String absPath) throws InternalErrorException {
        this.logger.debug("setAuthorAce - users: " + users.toString() + " - absPath: " + absPath);
        boolean flag = true;
        ArrayList<String> privileges = new ArrayList<String>();
        privileges.add("jcr:write=granted");
        try {
            flag = this.modifyAce(users, absPath, privileges, null);
        }
        catch (Exception e) {
            this.logger.error("Error setting WriteOwner to users " + users.toString() + " to path " + absPath);
            flag = false;
        }
        this.logger.debug("Ace modified");
        return flag;
    }

    public boolean setWriteAllACL(List<String> users, String absPath) throws InternalErrorException {
        ArrayList<String> privileges = new ArrayList<String>();
        privileges.add("hl:writeAll=granted");
        boolean flag = true;
        try {
            flag = this.modifyAce(users, absPath, privileges, null);
        }
        catch (Exception e) {
            this.logger.error("Error setting Write All to users " + users.toString() + " to path " + absPath);
            flag = false;
        }
        return flag;
    }

    public boolean setAccessDenied(List<String> users, String absPath) throws InternalErrorException {
        ArrayList<String> privileges = new ArrayList<String>();
        privileges.add("jcr:read=denied");
        boolean flag = true;
        try {
            flag = this.modifyAce(users, absPath, privileges, null);
        }
        catch (Exception e) {
            this.logger.error("Error removing Read privilege to users " + users.toString() + " to path " + absPath);
            flag = false;
        }
        return flag;
    }

    public boolean setAdminACL(List<String> users, String absPath) throws InternalErrorException {
        ArrayList<String> privileges = new ArrayList<String>();
        privileges.add("jcr:all=granted");
        boolean flag = true;
        try {
            flag = this.modifyAce(users, absPath, privileges, null);
        }
        catch (Exception e) {
            this.logger.error("Error setting Admin to users " + users.toString() + " to path " + absPath);
            flag = false;
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteAces(String resourcePath, List<String> users) throws InternalErrorException {
        GetMethod getMethod = null;
        Boolean modified = true;
        try {
            HttpClient httpClient = new HttpClient();
            StringBuilder applyTo = new StringBuilder();
            for (String user : users) {
                applyTo.append("&applyTo=" + user);
            }
            String requestUrl = url + "/DeleteAcesServlet?" + JCRRepository.getCredentials() + "&absPath=" + URLEncoder.encode(resourcePath, "UTF-8") + applyTo;
            this.logger.debug(requestUrl);
            getMethod = new GetMethod(requestUrl);
            httpClient.executeMethod((HttpMethod)getMethod);
            this.logger.debug("Response " + getMethod.getResponseBodyAsString());
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
            XStream xstream = new XStream();
            modified = (Boolean)xstream.fromXML(getMethod.getResponseBodyAsString());
        }
        catch (Exception e) {
            this.logger.error("Error deleting Permissions in AccessManager", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (getMethod != null) {
                getMethod.releaseConnection();
            }
        }
        return modified;
    }

    public Map<String, List<String>> getGrantedMap(String absPath) throws RepositoryException, InternalErrorException {
        Session session = JCRRepository.getSession();
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        LinkedHashMap<Principal, JCRPrivilegesInfo.AccessRights> accessMap = new LinkedHashMap<Principal, JCRPrivilegesInfo.AccessRights>();
        AccessControlEntry[] entries = this.getDeclaredAccessControlEntries(session, absPath);
        if (entries != null) {
            for (AccessControlEntry ace : entries) {
                ArrayList<String> privilegesList = null;
                Principal principal = ace.getPrincipal();
                JCRPrivilegesInfo.AccessRights accessPrivileges = (JCRPrivilegesInfo.AccessRights)accessMap.get(principal);
                if (accessPrivileges == null) {
                    accessPrivileges = new JCRPrivilegesInfo.AccessRights();
                    accessMap.put(principal, accessPrivileges);
                }
                accessPrivileges.getGranted().addAll(Arrays.asList(ace.getPrivileges()));
                Set<Privilege> deniedPrivileges = accessPrivileges.getDenied();
                for (Privilege priv : deniedPrivileges) {
                    if (privilegesList == null) {
                        privilegesList = new ArrayList<String>();
                    }
                    privilegesList.add(priv.getName());
                }
                map.put(principal.getName(), privilegesList);
            }
        }
        return map;
    }

    public Map<String, List<String>> getDeniedMap(String absPath) throws RepositoryException, InternalErrorException {
        Session session = JCRRepository.getSession();
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        LinkedHashMap<Principal, JCRPrivilegesInfo.AccessRights> accessMap = new LinkedHashMap<Principal, JCRPrivilegesInfo.AccessRights>();
        AccessControlEntry[] entries = this.getDeclaredAccessControlEntries(session, absPath);
        if (entries != null) {
            for (AccessControlEntry ace : entries) {
                ArrayList<String> privilegesList = null;
                Principal principal = ace.getPrincipal();
                JCRPrivilegesInfo.AccessRights accessPrivileges = (JCRPrivilegesInfo.AccessRights)accessMap.get(principal);
                if (accessPrivileges == null) {
                    accessPrivileges = new JCRPrivilegesInfo.AccessRights();
                    accessMap.put(principal, accessPrivileges);
                }
                accessPrivileges.getDenied().addAll(Arrays.asList(ace.getPrivileges()));
                Set<Privilege> deniedPrivileges = accessPrivileges.getDenied();
                for (Privilege priv : deniedPrivileges) {
                    if (privilegesList == null) {
                        privilegesList = new ArrayList<String>();
                    }
                    privilegesList.add(priv.getName());
                }
                map.put(principal.getName(), privilegesList);
            }
        }
        return map;
    }

    private AccessControlEntry[] getDeclaredAccessControlEntries(Session session, String absPath) throws RepositoryException {
        AccessControlPolicy[] policies;
        AccessControlManager accessControlManager = AccessControlUtil.getAccessControlManager(session);
        for (AccessControlPolicy accessControlPolicy : policies = accessControlManager.getPolicies(absPath)) {
            if (!(accessControlPolicy instanceof AccessControlList)) continue;
            AccessControlEntry[] accessControlEntries = ((AccessControlList)accessControlPolicy).getAccessControlEntries();
            return accessControlEntries;
        }
        return new AccessControlEntry[0];
    }
}

