/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.sharing;

import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.jcr.PathNotFoundException;
import org.apache.commons.httpclient.HttpException;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibrary.home.HomeManager;
import org.gcube.common.homelibrary.home.User;
import org.gcube.common.homelibrary.home.exceptions.HomeNotFoundException;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.exceptions.UserNotFoundException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.home.workspace.sharing.WorkspaceMessage;
import org.gcube.common.homelibrary.home.workspace.sharing.WorkspaceMessageManager;
import org.gcube.common.homelibrary.jcr.sharing.JCRWorkspaceMessage;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspace;
import org.gcube.common.homelibrary.jcr.workspace.servlet.JCRSession;
import org.gcube.common.homelibrary.jcr.workspace.servlet.wrapper.DelegateManager;
import org.gcube.common.homelibrary.model.exceptions.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRWorkspaceMessageManager
implements WorkspaceMessageManager {
    private JCRWorkspace workspace;
    private static Logger logger = LoggerFactory.getLogger(JCRWorkspaceMessageManager.class);
    protected static final String CONTENT = "jcr:content";
    protected static final String ATTACHMENTS = "hl:attachments";

    public JCRWorkspaceMessageManager(JCRWorkspace workspace) {
        this.workspace = workspace;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String sendMessageToPortalLogins(String subject, String body, List<String> attachmentIds, List<String> addresses) throws InternalErrorException {
        JCRWorkspaceMessage itemToSend = null;
        try {
            String messageId = UUID.randomUUID().toString();
            ItemDelegate nodeOutBox = this.workspace.getRepository().getOutBoxFolder();
            JCRWorkspaceMessage itemInSentFolder = null;
            try {
                DelegateManager wrap = new DelegateManager(nodeOutBox, this.workspace.getOwner().getPortalLogin());
                ItemDelegate nodeSentMessage = wrap.addNode(messageId, "nthl:itemSentRequest");
                itemInSentFolder = new JCRWorkspaceMessage(this.workspace, nodeSentMessage, JCRWorkspaceMessage.WorkspaceMessageType.SENT, messageId, subject, body, this.workspace.getOwner(), attachmentIds, addresses, this.workspace.getOwner().getPortalLogin());
            }
            catch (RepositoryException e) {
                logger.error("Internal error exception", (Throwable)e);
                throw new InternalErrorException((Throwable)e);
            }
            List<String> copyAttachmentsIds = null;
            if (itemInSentFolder != null) {
                copyAttachmentsIds = itemInSentFolder.getCopyAttachmentsIds();
            }
            HashSet<String> set = new HashSet<String>(addresses);
            for (String user : set) {
                logger.debug("Send message to user " + user);
                HomeManager homeManager = this.workspace.getHome().getHomeManager();
                homeManager.getHome(user);
                ItemDelegate inBoxFolder = this.workspace.getRepository().getInBoxFolder(user);
                try {
                    DelegateManager wrap = new DelegateManager(inBoxFolder, this.workspace.getOwner().getPortalLogin());
                    ItemDelegate sentMessage = wrap.addNode(messageId, "nthl:itemSentRequest");
                    itemToSend = new JCRWorkspaceMessage(this.workspace, sentMessage, JCRWorkspaceMessage.WorkspaceMessageType.RECEIVED, messageId, subject, body, this.workspace.getOwner(), copyAttachmentsIds, addresses, user);
                }
                catch (RepositoryException e) {
                    logger.error("Internal error exception", (Throwable)e);
                    throw new InternalErrorException((Throwable)e);
                    return itemToSend.getId();
                }
            }
        }
        catch (HomeNotFoundException e) {
            logger.error("User home not found", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        catch (javax.jcr.RepositoryException e) {
            logger.error("Internal error exception", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
        catch (UserNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public String sendMessageToUsers(String subject, String body, List<String> attachmentIds, List<User> addresses) throws InternalErrorException {
        HashSet<User> set = new HashSet<User>(addresses);
        LinkedList<String> list = new LinkedList<String>();
        for (User user : set) {
            list.add(user.getPortalLogin());
        }
        return this.sendMessageToPortalLogins(subject, body, attachmentIds, list);
    }

    public WorkspaceMessage getSentMessage(String id) throws InternalErrorException, ItemNotFoundException {
        try {
            ItemDelegate outBoxFolder = this.workspace.getRepository().getOutBoxFolder();
            ItemDelegate messageNode = new DelegateManager(outBoxFolder, this.workspace.getOwner().getPortalLogin()).getNode(id);
            JCRWorkspaceMessage message = new JCRWorkspaceMessage(this.workspace, messageNode, JCRWorkspaceMessage.WorkspaceMessageType.SENT);
            return message;
        }
        catch (PathNotFoundException e) {
            throw new ItemNotFoundException(e.getMessage());
        }
        catch (javax.jcr.RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
    }

    public WorkspaceMessage getReceivedMessage(String id) throws InternalErrorException, ItemNotFoundException {
        JCRWorkspaceMessage message;
        try {
            ItemDelegate ownInBoxFolder = this.workspace.getRepository().getOwnInBoxFolder();
            ItemDelegate messageNode = new DelegateManager(ownInBoxFolder, this.workspace.getOwner().getPortalLogin()).getNode(id);
            message = new JCRWorkspaceMessage(this.workspace, messageNode, JCRWorkspaceMessage.WorkspaceMessageType.RECEIVED);
        }
        catch (PathNotFoundException e) {
            throw new ItemNotFoundException(e.getMessage());
        }
        catch (javax.jcr.RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteReceivedMessage(String id) {
        JCRSession servlets = null;
        try {
            servlets = new JCRSession(this.workspace.getOwner().getPortalLogin(), false);
            ItemDelegate ownInBoxFolder = this.workspace.getRepository().getOwnInBoxFolder();
            ItemDelegate messageNode = new DelegateManager(ownInBoxFolder, this.workspace.getOwner().getPortalLogin()).getNode(id);
            this.workspace.getStorage().removeRemoteFolder(messageNode.getPath());
            servlets.removeItem(messageNode.getPath());
        }
        catch (Exception e) {
            logger.error("Internal error exception", (Throwable)e);
        }
        finally {
            if (servlets != null) {
                servlets.releaseSession();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSentMessage(String id) {
        JCRSession servlets = null;
        try {
            servlets = new JCRSession(this.workspace.getOwner().getPortalLogin(), false);
            DelegateManager wrap = new DelegateManager(this.workspace.getRepository().getOutBoxFolder(), this.workspace.getOwner().getPortalLogin());
            ItemDelegate messageNode = wrap.getNode(id);
            this.workspace.getStorage().removeRemoteFolder(messageNode.getPath());
            servlets.removeItem(messageNode.getPath());
        }
        catch (Exception e) {
            logger.error("Internal error exception", (Throwable)e);
        }
        finally {
            if (servlets != null) {
                servlets.releaseSession();
            }
        }
    }

    public List<WorkspaceMessage> getReceivedMessages() {
        LinkedList<JCRWorkspaceMessage> list = null;
        try {
            DelegateManager wrap = new DelegateManager(this.workspace.getRepository().getInBoxFolder(this.workspace.getOwner().getPortalLogin()), this.workspace.getOwner().getPortalLogin());
            list = new LinkedList<JCRWorkspaceMessage>();
            for (ItemDelegate messageNode : wrap.getNodes()) {
                list.add(new JCRWorkspaceMessage(this.workspace, messageNode, JCRWorkspaceMessage.WorkspaceMessageType.RECEIVED));
            }
        }
        catch (Exception e) {
            logger.error("Internal error exception", (Throwable)e);
        }
        return list;
    }

    public List<WorkspaceMessage> getSentMessages() {
        LinkedList<JCRWorkspaceMessage> list = null;
        try {
            DelegateManager wrap = new DelegateManager(this.workspace.getRepository().getOutBoxFolder(), this.workspace.getOwner().getPortalLogin());
            list = new LinkedList<JCRWorkspaceMessage>();
            for (ItemDelegate messageNode : wrap.getNodes()) {
                list.add(new JCRWorkspaceMessage(this.workspace, messageNode, JCRWorkspaceMessage.WorkspaceMessageType.SENT));
            }
        }
        catch (Exception e) {
            logger.error("Internal error exception", (Throwable)e);
        }
        return list;
    }

    public int getMessagesNotOpened() {
        int count = 0;
        for (WorkspaceMessage message : this.getReceivedMessages()) {
            if (((JCRWorkspaceMessage)message).isOpened()) continue;
            ++count;
        }
        return count;
    }

    public List<WorkspaceMessage> searchInMessages(String word) throws InternalErrorException {
        try {
            ItemDelegate nodeInBox = this.workspace.getRepository().getOwnInBoxFolder();
            List<ItemDelegate> iterator = this.getNodeSearched(nodeInBox, word);
            List<WorkspaceMessage> list = this.getMessagesSearched(iterator, JCRWorkspaceMessage.WorkspaceMessageType.RECEIVED);
            return list;
        }
        catch (javax.jcr.RepositoryException e) {
            logger.error("Error ", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
    }

    public List<WorkspaceMessage> searchOutMessages(String word) throws InternalErrorException {
        try {
            ItemDelegate nodeOutBox = this.workspace.getRepository().getOutBoxFolder();
            List<ItemDelegate> iterator = this.getNodeSearched(nodeOutBox, word);
            List<WorkspaceMessage> list = this.getMessagesSearched(iterator, JCRWorkspaceMessage.WorkspaceMessageType.SENT);
            return list;
        }
        catch (javax.jcr.RepositoryException e) {
            logger.error("Error", (Throwable)e);
            throw new InternalErrorException((Throwable)e);
        }
    }

    private List<WorkspaceMessage> getMessagesSearched(List<ItemDelegate> messages, JCRWorkspaceMessage.WorkspaceMessageType type) {
        LinkedList<WorkspaceMessage> list = new LinkedList<WorkspaceMessage>();
        for (ItemDelegate message : messages) {
            try {
                list.add(new JCRWorkspaceMessage(this.workspace, message, type));
            }
            catch (javax.jcr.RepositoryException e) {
                logger.error("Message Item " + message.getTitle() + " unknow");
            }
        }
        return list;
    }

    private List<ItemDelegate> getNodeSearched(ItemDelegate searchRoot, String word) throws InternalErrorException {
        JCRSession servlets = null;
        List<ItemDelegate> itemDelegateList = null;
        try {
            servlets = new JCRSession(this.workspace.getOwner().getPortalLogin(), false);
            String xpath = "/jcr:root" + searchRoot.getPath() + "//element()[jcr:contains(@hl:subject,'*" + word + "*') or jcr:contains(@hl:body,'*" + word + "*') ] ";
            itemDelegateList = servlets.searchItems(xpath, "xpath");
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (HttpException e) {
            throw new InternalErrorException((Throwable)e);
        }
        catch (IOException e) {
            throw new InternalErrorException((Throwable)e);
        }
        return itemDelegateList;
    }
}

