/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.util;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestUtil {
    private static final int CONNECTION_TIMEOUT = 1000;
    public static Logger logger = LoggerFactory.getLogger(HttpRequestUtil.class);

    public static boolean urlExists(String urlConn) throws Exception {
        if (urlConn == null || urlConn.isEmpty()) {
            return false;
        }
        try {
            URL url = new URL(urlConn);
            URLConnection connection = url.openConnection();
            connection.setConnectTimeout(1000);
            connection.setReadTimeout(2000);
            logger.trace("open connection on: " + url);
            if (connection instanceof HttpURLConnection) {
                HttpURLConnection httpConnection = (HttpURLConnection)connection;
                httpConnection.setRequestMethod("GET");
                int code = httpConnection.getResponseCode();
                httpConnection.disconnect();
                if (code == 200) {
                    logger.trace("status code is " + code + " - on url connection: " + urlConn);
                    return true;
                }
                logger.warn("status code is " + code + " - on url connection: " + urlConn);
            } else {
                logger.error("error - not a http request!");
            }
            return false;
        }
        catch (SocketTimeoutException e) {
            logger.error("Error SocketTimeoutException with url " + urlConn, (Throwable)e);
            return true;
        }
        catch (MalformedURLException e) {
            logger.error("Error MalformedURLException with url " + urlConn, (Throwable)e);
            throw new Exception("Error MalformedURLException");
        }
        catch (IOException e) {
            logger.error("Error IOException with url " + urlConn, (Throwable)e);
            throw new Exception("Error IOException");
        }
        catch (Exception e) {
            logger.error("Error Exception with url " + urlConn, (Throwable)e);
            throw new Exception("Error Exception");
        }
    }
}

