/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibary.model.util;

import java.util.ArrayList;
import java.util.Set;
import org.apache.commons.collections.MapIterator;
import org.apache.commons.collections.map.LRUMap;
import org.gcube.common.homelibary.model.util.Cleanable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryCache<K, T extends Cleanable> {
    private long timeToLive;
    private LRUMap crunchifyCacheMap;
    private static Logger logger = LoggerFactory.getLogger(MemoryCache.class);

    public MemoryCache(long crunchifyTimeToLive, final long crunchifyTimerInterval, int maxItems) {
        logger.debug("Start Homes Memory Cache...");
        this.timeToLive = crunchifyTimeToLive * 1000L;
        logger.debug("TimeToLive set to " + this.timeToLive + " seconds.");
        this.crunchifyCacheMap = new LRUMap(maxItems);
        if (this.timeToLive > 0L && crunchifyTimerInterval > 0L) {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            Thread.sleep(crunchifyTimerInterval * 1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        MemoryCache.this.cleanup();
                    }
                }
            });
            t.setDaemon(true);
            t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(K key, T value) {
        LRUMap lRUMap = this.crunchifyCacheMap;
        synchronized (lRUMap) {
            this.crunchifyCacheMap.put(key, (Object)new CrunchifyCacheObject(this, value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(K key) {
        LRUMap lRUMap = this.crunchifyCacheMap;
        synchronized (lRUMap) {
            return this.crunchifyCacheMap.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> keySet() {
        LRUMap lRUMap = this.crunchifyCacheMap;
        synchronized (lRUMap) {
            return this.crunchifyCacheMap.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(K key) {
        LRUMap lRUMap = this.crunchifyCacheMap;
        synchronized (lRUMap) {
            CrunchifyCacheObject c = (CrunchifyCacheObject)this.crunchifyCacheMap.get(key);
            if (c == null) {
                return null;
            }
            c.lastAccessed = System.currentTimeMillis();
            return c.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(K key) {
        LRUMap lRUMap = this.crunchifyCacheMap;
        synchronized (lRUMap) {
            CrunchifyCacheObject c = (CrunchifyCacheObject)this.crunchifyCacheMap.remove(key);
            if (c != null) {
                c.getValue().releaseResources();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        LRUMap lRUMap = this.crunchifyCacheMap;
        synchronized (lRUMap) {
            return this.crunchifyCacheMap.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        CrunchifyCacheObject c;
        logger.debug("Clean unused homes...");
        long now = System.currentTimeMillis();
        ArrayList<Object> deleteKey = null;
        LRUMap lRUMap = this.crunchifyCacheMap;
        synchronized (lRUMap) {
            MapIterator mapIterator = this.crunchifyCacheMap.mapIterator();
            deleteKey = new ArrayList<Object>(this.crunchifyCacheMap.size() / 2 + 1);
            Object key = null;
            c = null;
            while (mapIterator.hasNext()) {
                key = mapIterator.next();
                c = (CrunchifyCacheObject)mapIterator.getValue();
                if (c == null || now <= this.timeToLive + c.lastAccessed) continue;
                deleteKey.add(key);
            }
        }
        for (Object e : deleteKey) {
            LRUMap lRUMap2 = this.crunchifyCacheMap;
            synchronized (lRUMap2) {
                c = (CrunchifyCacheObject)this.crunchifyCacheMap.remove(e);
                c.getValue().releaseResources();
                logger.debug(e + "'s home has been removed from memory home cache.");
            }
            Thread.yield();
        }
    }

    protected static class CrunchifyCacheObject {
        public long lastAccessed = System.currentTimeMillis();
        public T value;
        final /* synthetic */ MemoryCache this$0;

        protected CrunchifyCacheObject(T value) {
            this.this$0 = this$0;
            this.value = value;
        }

        protected T getValue() {
            return this.value;
        }
    }
}

