/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibary.model.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.gcube.common.homelibary.model.util.Cleanable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryCache<K, T extends Cleanable> {
    private long timeToLive;
    private Map<K, CrunchifyCacheObject> crunchifyCacheMap;
    private int MAX_NUM_ENTRY = 10;
    private static Logger logger = LoggerFactory.getLogger(MemoryCache.class);

    public MemoryCache(long crunchifyTimeToLive, long crunchifyTimerInterval, int maxItems) {
        logger.info("Start Homes Memory Cache...");
        this.timeToLive = crunchifyTimeToLive * 1000L;
        logger.debug("TimeToLive set to " + this.timeToLive + " seconds.");
        this.crunchifyCacheMap = new HashMap<K, CrunchifyCacheObject>(maxItems);
        this.MAX_NUM_ENTRY = maxItems;
        if (this.timeToLive > 0L && crunchifyTimerInterval > 0L) {
            Timer timer = new Timer(true);
            timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    MemoryCache.this.cleanup();
                }
            }, crunchifyTimerInterval * 1000L, crunchifyTimerInterval * 1000L);
        }
    }

    private boolean isFull() {
        return this.crunchifyCacheMap.size() == this.MAX_NUM_ENTRY;
    }

    private void removeLRUEntry() {
        Object keyToRemove = null;
        long lruTimestamp = System.currentTimeMillis();
        for (Map.Entry<K, CrunchifyCacheObject> entry : this.crunchifyCacheMap.entrySet()) {
            long entryTimestamp = entry.getValue().lastAccessed;
            if (entryTimestamp >= lruTimestamp) continue;
            keyToRemove = entry.getKey();
        }
        CrunchifyCacheObject c = this.crunchifyCacheMap.remove(keyToRemove);
        if (c.getValue() != null) {
            c.getValue().releaseResources();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(K key, T value) {
        Map<K, CrunchifyCacheObject> map = this.crunchifyCacheMap;
        synchronized (map) {
            if (this.isFull()) {
                this.removeLRUEntry();
            }
            this.crunchifyCacheMap.put(key, new CrunchifyCacheObject(this, value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(K key) {
        Map<K, CrunchifyCacheObject> map = this.crunchifyCacheMap;
        synchronized (map) {
            return this.crunchifyCacheMap.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<K> keySet() {
        Map<K, CrunchifyCacheObject> map = this.crunchifyCacheMap;
        synchronized (map) {
            return this.crunchifyCacheMap.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(K key) {
        Map<K, CrunchifyCacheObject> map = this.crunchifyCacheMap;
        synchronized (map) {
            CrunchifyCacheObject c = this.crunchifyCacheMap.get(key);
            if (c == null) {
                return null;
            }
            c.lastAccessed = System.currentTimeMillis();
            return c.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(K key) {
        Map<K, CrunchifyCacheObject> map = this.crunchifyCacheMap;
        synchronized (map) {
            CrunchifyCacheObject c = this.crunchifyCacheMap.remove(key);
            if (c != null) {
                c.getValue().releaseResources();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Map<K, CrunchifyCacheObject> map = this.crunchifyCacheMap;
        synchronized (map) {
            return this.crunchifyCacheMap.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        logger.debug("Clean unused homes...");
        long now = System.currentTimeMillis();
        ArrayList<K> deleteKey = null;
        Map<K, CrunchifyCacheObject> map = this.crunchifyCacheMap;
        synchronized (map) {
            Iterator<Map.Entry<K, CrunchifyCacheObject>> itr = this.crunchifyCacheMap.entrySet().iterator();
            deleteKey = new ArrayList<K>(this.crunchifyCacheMap.size() / 2 + 1);
            while (itr.hasNext()) {
                Map.Entry<K, CrunchifyCacheObject> entry = itr.next();
                K key = entry.getKey();
                CrunchifyCacheObject c = entry.getValue();
                if (c == null || now <= this.timeToLive + c.lastAccessed) continue;
                deleteKey.add(key);
            }
        }
        for (Object key : deleteKey) {
            Map<K, CrunchifyCacheObject> map2 = this.crunchifyCacheMap;
            synchronized (map2) {
                CrunchifyCacheObject c = this.crunchifyCacheMap.remove(key);
                if (c != null && c.getValue() != null) {
                    c.getValue().releaseResources();
                }
                logger.debug(key + "'s home has been removed from memory home cache.");
            }
            Thread.yield();
        }
    }

    protected static class CrunchifyCacheObject {
        public long lastAccessed = System.currentTimeMillis();
        public T value;
        final /* synthetic */ MemoryCache this$0;

        protected CrunchifyCacheObject(T value) {
            this.this$0 = var1_1;
            this.value = value;
        }

        protected T getValue() {
            return this.value;
        }
    }
}

