/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.consistency;

import java.util.List;
import org.gcube.common.homelibrary.consistency.WorkspaceConsistencyChecker;
import org.gcube.common.homelibrary.consistency.statistics.CheckStatistics;
import org.gcube.common.homelibrary.consistency.statistics.HomeCheckStatistics;
import org.gcube.common.homelibrary.home.Home;
import org.gcube.common.homelibrary.home.HomeManager;
import org.gcube.common.homelibrary.home.HomeManagerFactory;
import org.gcube.common.homelibrary.home.User;
import org.gcube.common.homelibrary.home.exceptions.HomeNotFoundException;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.exceptions.UserNotFoundException;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HomeManagerFactoryConsistencyChecker {
    private static Logger logger = LoggerFactory.getLogger(HomeManagerFactoryConsistencyChecker.class);
    protected HomeManagerFactory factory;
    protected boolean testEntireStream;
    protected CheckStatistics statistics;
    protected boolean acceptAllSentRequests;

    public HomeManagerFactoryConsistencyChecker(HomeManagerFactory factory, boolean testEntireStream, boolean acceptAllSentRequests) {
        this.factory = factory;
        this.testEntireStream = testEntireStream;
        this.acceptAllSentRequests = acceptAllSentRequests;
        this.statistics = new CheckStatistics();
    }

    public CheckStatistics getStatistics() {
        return this.statistics;
    }

    public boolean checkAllScopes() throws InternalErrorException {
        List scopes = this.factory.listScopes();
        boolean checkResult = true;
        for (String scope : scopes) {
            checkResult &= this.checkScope(scope);
        }
        return checkResult;
    }

    public boolean checkScope(String scope) throws InternalErrorException {
        logger.info("start checking " + scope);
        HomeManager manager = this.factory.getHomeManager();
        boolean passed = this.checkHomeManager(manager);
        logger.info(scope + " " + (passed ? "OK" : "FAILED"));
        return passed;
    }

    protected boolean checkHomeManager(HomeManager manager) throws InternalErrorException {
        boolean managerCheck = true;
        List users = manager.getUsers();
        String scope = manager.toString();
        HomeCheckStatistics homeStatistics = new HomeCheckStatistics();
        for (User user : users) {
            try {
                logger.debug("checking user " + user.getPortalLogin());
                Home home = manager.getHome(user.getPortalLogin());
                boolean passed = this.checkHome(home, homeStatistics);
                managerCheck &= passed;
                logger.info(scope + " " + user.getPortalLogin() + " " + (passed ? "OK" : "FAILED"));
            }
            catch (HomeNotFoundException hne) {
                logger.error(scope + " " + user.getPortalLogin() + " FAILED", (Throwable)hne);
                managerCheck = false;
            }
            catch (UserNotFoundException e) {
                e.printStackTrace();
            }
        }
        return managerCheck;
    }

    protected boolean checkHome(Home home, HomeCheckStatistics homeStatistics) {
        try {
            Workspace wa = home.getWorkspace();
            WorkspaceConsistencyChecker waChecker = new WorkspaceConsistencyChecker(wa, this.testEntireStream, this.acceptAllSentRequests);
            boolean result = waChecker.checkWorkspace();
            homeStatistics.addWorkspaceStatistics(home.getOwner().getPortalLogin(), waChecker.getStatistics());
            return result;
        }
        catch (Exception e) {
            logger.error("Error checking the home", (Throwable)e);
            return false;
        }
    }
}

