/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.util.zip;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.exceptions.InsufficientPrivilegesException;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemAlreadyExistException;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItem;
import org.gcube.common.homelibrary.util.MimeTypeUtil;
import org.gcube.common.homelibrary.util.WorkspaceUtil;
import org.gcube.common.homelibrary.util.zip.zipmodel.ZipFile;
import org.gcube.common.homelibrary.util.zip.zipmodel.ZipFolder;
import org.gcube.common.homelibrary.util.zip.zipmodel.ZipItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipModelToWorkspaceCreator {
    protected Logger logger = LoggerFactory.getLogger(ZipModelToWorkspaceCreator.class);

    public void create(WorkspaceFolder root, List<ZipItem> items) {
        for (ZipItem item : items) {
            try {
                this.createWorkspaceItem(root, item);
            }
            catch (Exception e) {
                this.logger.error("Error creating item " + item, (Throwable)e);
            }
        }
    }

    protected void createWorkspaceItem(WorkspaceFolder parentFolder, ZipItem item) throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException, IOException {
        switch (item.getType()) {
            case FOLDER: {
                this.createWorkspace(parentFolder, (ZipFolder)item);
                break;
            }
            case FILE: {
                this.createItem(parentFolder, (ZipFile)item);
            }
        }
    }

    protected void createWorkspace(WorkspaceFolder parentFolder, ZipFolder zipFolder) throws InternalErrorException, InsufficientPrivilegesException, ItemAlreadyExistException {
        String name = WorkspaceUtil.getUniqueName(zipFolder.getName(), parentFolder);
        String description = zipFolder.getComment() != null ? zipFolder.getComment() : "";
        WorkspaceFolder folder = parentFolder.createFolder(name, description);
        for (ZipItem workspaceFolder : zipFolder.getChildren()) {
            try {
                this.createWorkspaceItem(folder, workspaceFolder);
            }
            catch (Exception e) {
                this.logger.error("Error creating item " + workspaceFolder, (Throwable)e);
            }
        }
    }

    protected void createItem(WorkspaceFolder folder, ZipFile zipFile) throws InsufficientPrivilegesException, InternalErrorException, ItemAlreadyExistException, IOException {
        this.logger.trace("Creating item " + zipFile);
        String zipItemName = zipFile.getName();
        String name = WorkspaceUtil.getUniqueName(zipItemName, folder);
        String description = zipFile.getComment() != null ? zipFile.getComment() : "";
        String mimeType = MimeTypeUtil.getMimeType(zipFile.getName(), new FileInputStream(zipFile.getContentFile()));
        FolderItem item = WorkspaceUtil.createExternalFile(folder, name, description, mimeType, new FileInputStream(zipFile.getContentFile()));
        this.logger.trace("Item created " + item);
        zipFile.getContentFile().delete();
        this.logger.trace("Tmp file deleted");
    }
}

