package org.gcube.common.storagehub.client.proxies;

import java.io.InputStream;
import java.util.List;

import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.storagehub.client.StreamDescriptor;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.service.ItemList;

public class DefaultItemManager implements ItemManagerClient {

	private final ProxyDelegate<WebTarget> delegate;

	
	public DefaultItemManager(ProxyDelegate<WebTarget> config){
		this.delegate = config;
	}


	@Override
	public List<? extends Item> getChildren(String id, String ... excludeNodes) {
		Call<WebTarget, ItemList> call = new Call<WebTarget, ItemList>() {
			@Override
			public ItemList call(WebTarget manager) throws Exception {
				WebTarget myManager = manager.path(id).path("children");
				if (excludeNodes !=null && excludeNodes.length>0)
					myManager =  myManager.queryParam("exclude",excludeNodes);
				Invocation.Builder builder = myManager.request(MediaType.APPLICATION_JSON);
				ItemList response = builder.get(ItemList.class);
				return response;
			}
		};
		try {
			ItemList result = delegate.make(call);
			return result.getItemlist();
		}catch(Exception e) {
			throw new RuntimeException(e);
		}
	}

	
	@Override
	public StreamDescriptor download(String id) {
		Call<WebTarget, StreamDescriptor> call = new Call<WebTarget, StreamDescriptor>() {
			@Override
			public StreamDescriptor call(WebTarget manager) throws Exception {
				WebTarget myManager = manager.path(id).path("download");
				Invocation.Builder builder = myManager.request(MediaType.APPLICATION_OCTET_STREAM);
				Response resp = builder.get();
				InputStream stream = resp.readEntity(InputStream.class);
				String disposition = resp.getHeaderString("Content-Disposition");
				String fileName = disposition.replaceFirst("attachment; filename = ([^/s]+)?", "$1");
				return new StreamDescriptor(stream, fileName);
			}
		};
		try {
			StreamDescriptor result = delegate.make(call);
			return result;
		}catch(Exception e) {
			throw new RuntimeException(e);
		}
	}

}
