/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.keycloak.model;

import java.security.interfaces.RSAPublicKey;
import org.gcube.com.fasterxml.jackson.annotation.JsonIgnore;
import org.gcube.com.fasterxml.jackson.annotation.JsonProperty;
import org.gcube.common.keycloak.model.ModelUtils;

public class PublishedRealmRepresentation {
    protected String realm;
    @JsonProperty(value="public_key")
    protected String publicKeyPem;
    @JsonProperty(value="token-service")
    protected String tokenServiceUrl;
    @JsonProperty(value="account-service")
    protected String accountServiceUrl;
    @JsonProperty(value="tokens-not-before")
    protected int notBefore;
    @JsonIgnore
    protected volatile transient RSAPublicKey publicKey;

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public String getPublicKeyPem() {
        return this.publicKeyPem;
    }

    public void setPublicKeyPem(String publicKeyPem) {
        this.publicKeyPem = publicKeyPem;
        this.publicKey = null;
    }

    @JsonIgnore
    public RSAPublicKey getPublicKey() {
        if (this.publicKey != null) {
            return this.publicKey;
        }
        if (this.publicKeyPem != null) {
            try {
                this.publicKey = ModelUtils.createRSAPublicKey(this.publicKeyPem);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.publicKey;
    }

    @JsonIgnore
    public void setPublicKey(RSAPublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public String getTokenServiceUrl() {
        return this.tokenServiceUrl;
    }

    public void setTokenServiceUrl(String tokenServiceUrl) {
        this.tokenServiceUrl = tokenServiceUrl;
    }

    public String getAccountServiceUrl() {
        return this.accountServiceUrl;
    }

    public void setAccountServiceUrl(String accountServiceUrl) {
        this.accountServiceUrl = accountServiceUrl;
    }

    public int getNotBefore() {
        return this.notBefore;
    }

    public void setNotBefore(int notBefore) {
        this.notBefore = notBefore;
    }
}

