/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.metadataprofilediscovery;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.gcube.common.metadataprofilediscovery.jaxb.NamespaceCategories;
import org.gcube.common.metadataprofilediscovery.reader.NamespaceCategoryReader;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamespaceCategoriesCache {
    private static Logger LOG = LoggerFactory.getLogger(NamespaceCategoriesCache.class);
    private static LoadingCache<String, NamespaceCategories> namespaces;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void populateTheCache(ScopeBean scope) {
        String origScope = null;
        String instScope = scope.toString();
        try {
            origScope = ScopeProvider.instance.get();
            ScopeProvider.instance.set(scope.toString());
            LOG.info("Trying to populate the Namespaces cache in the scope: " + instScope);
            NamespaceCategoryReader rd = new NamespaceCategoryReader(scope);
            namespaces.put((Object)instScope, (Object)rd.getNamespaces());
        }
        catch (Exception exception) {
        }
        finally {
            if (origScope != null && !origScope.equals(scope.toString())) {
                ScopeProvider.instance.set(scope.toString());
            }
        }
    }

    public static NamespaceCategories get(String scope) throws ExecutionException {
        try {
            return (NamespaceCategories)namespaces.get((Object)scope);
        }
        catch (Exception e) {
            LOG.info("Error on getting NamespaceCategories obj for scope {}. Is the key {} not found in the cache?", (Object)scope, namespaces);
            throw e;
        }
    }

    protected static NamespaceCategories loadNamespaces(String scope) {
        NamespaceCategories namespacesCategories = (NamespaceCategories)namespaces.getIfPresent((Object)scope);
        if (namespacesCategories == null) {
            LOG.info("loading Catalogue Namespaces for scope: {}", (Object)scope);
            ScopeBean scopeB = new ScopeBean(scope);
            NamespaceCategoriesCache.populateTheCache(scopeB);
            namespacesCategories = (NamespaceCategories)namespaces.getIfPresent((Object)scope);
            LOG.info("NamespaceCategories populated correclty with scope: {}", (Object)scope);
        } else {
            LOG.info("NamespaceCategories cache already populated with scope: {}, returning cached NamespaceCategories", (Object)scope);
        }
        return namespacesCategories;
    }

    public LoadingCache<String, NamespaceCategories> getCache() {
        return namespaces;
    }

    static {
        CacheLoader<String, NamespaceCategories> loader = new CacheLoader<String, NamespaceCategories>(){

            public NamespaceCategories load(String scope) throws Exception {
                LOG.info("Loading the NamespaceCategories cache for scope: {}", (Object)scope);
                NamespaceCategories namespacesCat = NamespaceCategoriesCache.loadNamespaces(scope);
                if (namespacesCat != null) {
                    LOG.info("Returning {} for the scope name: {}", (Object)NamespaceCategories.class.getSimpleName(), (Object)scope);
                } else {
                    LOG.info("No NamespaceCategories obj for scope {}", (Object)scope);
                }
                return namespacesCat;
            }
        };
        RemovalListener<String, NamespaceCategories> removalListener = new RemovalListener<String, NamespaceCategories>(){

            public void onRemoval(RemovalNotification<String, NamespaceCategories> arg0) {
                LOG.debug("cache expired");
            }
        };
        namespaces = CacheBuilder.newBuilder().maximumSize(300L).expireAfterWrite(30L, TimeUnit.MINUTES).removalListener((RemovalListener)removalListener).build((CacheLoader)loader);
    }
}

