/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dbinterface.postgres;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.Condition;
import org.gcube.common.dbinterface.Limit;
import org.gcube.common.dbinterface.Order;
import org.gcube.common.dbinterface.attributes.Attribute;
import org.gcube.common.dbinterface.pool.DBSession;
import org.gcube.common.dbinterface.tables.SimpleTable;
import org.gcube.common.dbinterface.tables.Table;

public abstract class AbstractSelectQuery {
    private static final long serialVersionUID = 1L;
    private static GCUBELog logger = new GCUBELog(AbstractSelectQuery.class);
    private String expression = "SELECT <%DISTINCT%> <%ATTRIBUTES%> <%TABLE%> <%WHERE%> <%GROUPBY%> <%ORDER%> <%LIMIT%>  ";

    public String getExpression() {
        String tmpExpression = new String(this.expression);
        tmpExpression = tmpExpression.replaceAll("<%DISTINCT%>", this._getDistinct());
        tmpExpression = tmpExpression.replaceAll("<%WHERE%>", this._getFilters());
        tmpExpression = tmpExpression.replaceAll("<%GROUPBY%>", this._getGroups());
        tmpExpression = tmpExpression.replaceAll("<%ATTRIBUTES%>", this._getAttributes());
        tmpExpression = tmpExpression.replaceAll("<%ORDER%>", this._getOrders());
        tmpExpression = tmpExpression.replaceAll("<%TABLE%>", this._getTables());
        tmpExpression = tmpExpression.replaceAll("<%LIMIT%>", this._getLimits());
        return tmpExpression;
    }

    protected String _getAttributes() {
        if (this.getAttributes() == null || this.getAttributes().length == 0) {
            return "*";
        }
        String tmpAttributes = "";
        for (Attribute attribute : this.getAttributes()) {
            tmpAttributes = tmpAttributes + attribute.getAttribute() + ",";
        }
        return tmpAttributes.substring(0, tmpAttributes.length() - 1);
    }

    protected String _getFilters() {
        if (this.getFilter() == null) {
            return "";
        }
        return "WHERE " + this.getFilter().getCondition();
    }

    protected String _getOrders() {
        String tmpOrder = " ";
        if (this.getOrders() == null || this.getOrders().length == 0) {
            return "";
        }
        tmpOrder = "ORDER BY ";
        for (Order order : this.getOrders()) {
            tmpOrder = tmpOrder + order.getOrder() + ",";
        }
        return tmpOrder.substring(0, tmpOrder.length() - 1);
    }

    protected String _getTables() {
        if (this.getTables() == null || this.getTables().length == 0) {
            return "";
        }
        String tmpTables = " FROM ";
        for (Table table : this.getTables()) {
            tmpTables = tmpTables + table.getTable() + ",";
        }
        return tmpTables.substring(0, tmpTables.length() - 1);
    }

    protected String _getLimits() {
        if (this.getLimit() == null) {
            return "";
        }
        return this.getLimit().getLimits();
    }

    protected String _getGroups() {
        if (this.getGroups() == null || this.getGroups().length == 0) {
            return "";
        }
        String tmpGroups = "GROUP BY ";
        for (Attribute attrib : this.getGroups()) {
            tmpGroups = tmpGroups + attrib.getAttribute() + ",";
        }
        return tmpGroups.substring(0, tmpGroups.length() - 1);
    }

    protected String _getDistinct() {
        return this.isUseDistinct() ? "DISTINCT" : "";
    }

    public abstract Order[] getOrders();

    public abstract Limit getLimit();

    public abstract Condition getFilter();

    public abstract Attribute[] getAttributes();

    public abstract Table[] getTables();

    public abstract Attribute[] getGroups();

    public abstract boolean isUseDistinct();

    public String toString() {
        return this.getExpression();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResultAsJSon(boolean useTableCount, boolean ... resultSetReuse) throws Exception {
        String tempJson;
        DBSession session = DBSession.connect();
        try {
            tempJson = this.getResultAsJSon(session, useTableCount, resultSetReuse);
        }
        finally {
            session.release();
        }
        return tempJson;
    }

    public String getResultAsJSon(DBSession session, boolean useTableCount, boolean ... resultSetReuse) throws Exception {
        return this.toJSon(session.execute(this.getExpression(), resultSetReuse == null || resultSetReuse.length == 0 ? false : resultSetReuse[0]), useTableCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getResults(boolean ... resultSetReuse) throws Exception {
        ResultSet tempRes;
        DBSession session = DBSession.connect();
        try {
            tempRes = this.getResults(session, resultSetReuse);
        }
        finally {
            session.release();
        }
        return tempRes;
    }

    public ResultSet getResults(DBSession session, boolean ... resultSetReuse) throws Exception {
        return session.execute(this.getExpression(), resultSetReuse == null || resultSetReuse.length == 0 ? false : resultSetReuse[0]);
    }

    private String toJSon(ResultSet resultSet, boolean useTableCount) throws SQLException {
        StringBuilder json = new StringBuilder();
        json.append("{\"response\":{\"value\":{\"items\":[");
        ResultSetMetaData metaData = resultSet.getMetaData();
        int numberOfColumns = metaData.getColumnCount();
        int count = 0;
        while (resultSet.next()) {
            if (count > 0) {
                json.append(",{");
            } else {
                json.append('{');
            }
            for (int column = 1; column <= numberOfColumns; ++column) {
                if (column > 1) {
                    json.append(',');
                }
                json.append(AbstractSelectQuery.quote(metaData.getColumnName(column)));
                json.append(':');
                json.append(AbstractSelectQuery.quote(resultSet.getString(column)));
            }
            json.append('}');
            ++count;
        }
        int totalCount = 0;
        if (useTableCount) {
            if (SimpleTable.class.getName().compareTo(this.getTables()[0].getClass().getName()) == 0) {
                try {
                    long start = System.currentTimeMillis();
                    totalCount = ((SimpleTable)this.getTables()[0]).getCount();
                    logger.trace((Object)("totalcount is " + totalCount + " and took  " + (System.currentTimeMillis() - start)));
                }
                catch (Exception e) {
                    logger.warn((Object)"error getting count in ResultToJson");
                }
            } else {
                try {
                    long start = System.currentTimeMillis();
                    totalCount = new SimpleTable(this.getTables()[0].getTableName()).getCount();
                    logger.trace((Object)("totalcount is " + totalCount + " and took  " + (System.currentTimeMillis() - start)));
                }
                catch (Exception e) {
                    logger.warn((Object)"error getting count in ResultToJson");
                }
            }
        } else {
            totalCount = count;
        }
        json.append("],\"total_count\":" + totalCount);
        json.append(",\"version\":1}}}");
        logger.trace((Object)("the json count is: " + totalCount));
        return json.toString();
    }

    private static String quote(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c = '\u0000';
        int len = string.length();
        StringBuffer sb = new StringBuffer(len + 4);
        sb.append('\"');
        block9: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        sb.append('\\');
                    }
                    sb.append(c);
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u" + t.substring(t.length() - 4));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }
}

