package org.gcube.common.quota.check;

import java.util.Date;
import java.util.TimerTask;

import org.gcube.common.quota.service.exception.NotFoundQuotaExecption;
import org.gcube.common.quota.util.Constants;
import org.gcube.common.scope.api.ScopeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Quota Check Task 
 * Run with timerTask each DELAY_SCHEDULE_CHEK 
 * 
 * 
 *@author Alessandro Pieve (alessandro.pieve@isti.cnr.it)
 *
 */

public class QuotaCheckTask extends TimerTask {

	private static Logger log = LoggerFactory.getLogger(QuotaCheckTask.class);
	
	String context;
	String token;
	
	
	
	public QuotaCheckTask(String context, String token) {
		super();
		this.context = context;
		this.token = token;
	}
	
	@Override
	public void run() {
		//TODO Prendere il contesto del token 
		String context=ScopeProvider.instance.get();
		if (context==null){
			context=Constants.DEFAULT_CONTEXT;
			
		}
		ScopeProvider.instance.set(Constants.DEFAULT_CONTEXT);
		log.info("Timer task run at:{} in this context:{}",new Date(),context);
		try {
			@SuppressWarnings("unused")
			QuotaCheck quotaCheck= new QuotaCheck(context);
		} catch (NotFoundQuotaExecption e) {
			log.warn("No quote found!");
		}
		//quotaCheck.init(context);
		
		
	}
	public void startCheck() {
		
	}
}