/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools;

import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.plugin.Plugin;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class AboutBox
extends JDialog {
    private static final long serialVersionUID = -3889559376722324215L;
    private static final String PROPERTY_FILE = "about_infos.properties";
    private ContentPanel contentPanel;

    public AboutBox(Frame owner, String productName, String productVersion, String licensor, String url, String text, Image productLogo) {
        this(owner, AboutBox.createProperties(productName, productVersion, licensor, url, text), productLogo);
    }

    public AboutBox(Frame owner, String productVersion, Image productLogo) {
        this(owner, AboutBox.createProperties(productVersion), productLogo);
    }

    public AboutBox(Frame owner, Properties properties, Image productLogo) {
        super(owner, "About", true);
        this.setResizable(false);
        this.setLayout(new BorderLayout());
        String name = properties.getProperty("name");
        if (name != null) {
            this.setTitle("About " + name);
        }
        this.contentPanel = new ContentPanel(properties, productLogo);
        this.add((Component)this.contentPanel, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        JButton closeButton = new JButton(new AbstractAction("Close"){
            private static final long serialVersionUID = 1407089394491740308L;

            public void actionPerformed(ActionEvent e) {
                AboutBox.this.dispose();
            }
        });
        buttonPanel.add(closeButton);
        this.add((Component)buttonPanel, "South");
        this.pack();
        this.setLocationRelativeTo(owner);
    }

    public static Properties createProperties(InputStream inputStream, String productVersion) {
        Properties properties = new Properties();
        if (inputStream != null) {
            try {
                properties.load(inputStream);
            }
            catch (Exception e) {
                LogService.getGlobal().logError("Cannot read splash screen infos: " + e.getMessage());
            }
        }
        properties.setProperty("version", productVersion);
        Plugin.initAboutTexts(properties);
        return properties;
    }

    private static Properties createProperties(String productVersion) {
        Properties properties = new Properties();
        try {
            InputStream in = Tools.getResource(PROPERTY_FILE).openStream();
            properties.load(in);
            in.close();
        }
        catch (Exception e) {
            LogService.getGlobal().logError("Cannot read splash screen infos: " + e.getMessage());
        }
        properties.setProperty("version", productVersion);
        Plugin.initAboutTexts(properties);
        return properties;
    }

    private static Properties createProperties(String productName, String productVersion, String licensor, String url, String text) {
        Properties properties = new Properties();
        properties.setProperty("name", productName);
        properties.setProperty("version", productVersion);
        properties.setProperty("licensor", licensor);
        properties.setProperty("license", url);
        properties.setProperty("more", text);
        return properties;
    }

    private static class ContentPanel
    extends JPanel {
        private static final long serialVersionUID = -1763842074674706654L;
        private static final Paint MAIN_PAINT = Color.LIGHT_GRAY;
        private static Image backgroundImage = null;
        private static final int MARGIN = 10;
        private Properties properties;
        private transient Image productLogo;

        static {
            try {
                URL url = Tools.getResource("splashscreen_background.png");
                if (url != null) {
                    backgroundImage = ImageIO.read(url);
                }
            }
            catch (IOException e) {
                LogService.getGlobal().logWarning("Cannot load images for about box. Using empty image...");
            }
        }

        public ContentPanel(Properties properties, Image productLogo) {
            this.properties = properties;
            this.productLogo = productLogo;
            int width = 450;
            int height = 350;
            if (backgroundImage != null) {
                width = backgroundImage.getWidth(this);
                height = backgroundImage.getHeight(this);
            }
            this.setPreferredSize(new Dimension(width, height));
            this.setMinimumSize(new Dimension(width, height));
            this.setMaximumSize(new Dimension(width, height));
        }

        public void paint(Graphics g) {
            super.paint(g);
            g.setColor(Color.black);
            g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            this.drawMain((Graphics2D)g);
        }

        public void drawMain(Graphics2D g) {
            g.setPaint(MAIN_PAINT);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (backgroundImage != null) {
                g.drawImage(backgroundImage, 0, 0, this);
            }
            if (this.productLogo != null) {
                g.drawImage(this.productLogo, this.getWidth() / 2 - this.productLogo.getWidth(this) / 2, 90, this);
            }
            g.setColor(SwingTools.BROWN_FONT_COLOR);
            g.setFont(new Font("SansSerif", 1, 11));
            this.drawString(g, String.valueOf(this.properties.getProperty("name")) + " " + this.properties.getProperty("version"), 240);
            g.setFont(new Font("SansSerif", 0, 10));
            this.drawString(g, String.valueOf(this.properties.getProperty("name")) + " " + this.properties.getProperty("version"), 260);
            this.drawString(g, this.properties.getProperty("copyright"), 275);
            this.drawString(g, this.properties.getProperty("licensor"), 290);
            this.drawString(g, this.properties.getProperty("license"), 305);
            this.drawString(g, this.properties.getProperty("warranty"), 320);
            this.drawString(g, this.properties.getProperty("more"), 335);
        }

        private void drawString(Graphics2D g, String text, int height) {
            if (text == null) {
                return;
            }
            Rectangle2D stringBounds = g.getFontMetrics().getStringBounds(text, g);
            float xPos = (float)((double)(this.getWidth() - 10) - stringBounds.getWidth());
            float yPos = height;
            g.drawString(text, xPos, yPos);
        }
    }
}

