/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.series.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.preprocessing.series.AbstractSeriesProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexSeries
extends AbstractSeriesProcessing {
    public static final String PARAMETER_ATTRIBUTE_NAME = "attribute_name";
    public static final String PARAMETER_INDEX_ANCHOR = "index_anchor";
    public static final String[] INDEX_ANCHORS = new String[]{"first", "last"};
    public static final int INDEX_ANCHOR_FIRST = 0;
    public static final int INDEX_ANCHOR_LAST = 1;
    public static final int INDEX_ANCHOR_ID = 2;
    public static final String PARAMETER_INDEX_ANCHOR_ID = "index_anchor_id";
    public static final String PARAMETER_KEEP_ORIGINAL_ATTRIBUTE = "keep_original_attribute";

    public IndexSeries(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        Attribute attribute = exampleSet.getAttributes().get(this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME));
        if (attribute.isNominal()) {
            this.logWarning("attribute is not numerical: change attribute not created.");
            return exampleSet;
        }
        Attribute indexAttribute = AttributeFactory.createAttribute("index(" + attribute.getName() + ")", 2);
        exampleSet.getExampleTable().addAttribute(indexAttribute);
        exampleSet.getAttributes().addRegular(indexAttribute);
        int indexAnchor = this.getParameterAsInt(PARAMETER_INDEX_ANCHOR);
        double indexScaleValue = 1.0;
        boolean first = true;
        for (Example example : exampleSet) {
            switch (indexAnchor) {
                case 0: {
                    if (!first) break;
                    indexScaleValue = example.getValue(attribute);
                    first = false;
                    break;
                }
                case 1: {
                    indexScaleValue = example.getValue(attribute);
                }
            }
        }
        for (Example example : exampleSet) {
            example.setValue(indexAttribute, example.getValue(attribute) / indexScaleValue);
        }
        if (!this.getParameterAsBoolean(PARAMETER_KEEP_ORIGINAL_ATTRIBUTE)) {
            exampleSet.getAttributes().remove(attribute);
        }
        exampleSet.recalculateAttributeStatistics(indexAttribute);
        return exampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString(PARAMETER_ATTRIBUTE_NAME, "The name of the series attribute for MA calculation.", false));
        types.add(new ParameterTypeCategory(PARAMETER_INDEX_ANCHOR, "Determines which example should be the anchor of the index, i.e. which index value should be set equal to 1.", INDEX_ANCHORS, 0));
        types.add(new ParameterTypeBoolean(PARAMETER_KEEP_ORIGINAL_ATTRIBUTE, "Indicates whether the original attribute should be kept in the data set.", true));
        return types;
    }
}

