/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.look.ui;

import com.rapidminer.gui.look.ButtonListener;
import com.rapidminer.gui.look.RapidLookTools;
import com.rapidminer.gui.look.painters.CashedPainter;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;

public class ButtonUI
extends BasicButtonUI {
    private static final ButtonUI BUTTON_UI = new ButtonUI();

    public static ComponentUI createUI(JComponent c) {
        return BUTTON_UI;
    }

    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        b.setRolloverEnabled(true);
    }

    protected void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
    }

    public void installUI(JComponent c) {
        super.installUI(c);
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
    }

    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return new ButtonListener(b);
    }

    protected void paintText(Graphics g, AbstractButton c, Rectangle textRect, String text) {
        super.paintText(g, c, textRect, text);
    }

    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        if (b.isContentAreaFilled()) {
            if (b.getParent() instanceof JToolBar) {
                RapidLookTools.drawToolbarButton(g, c);
            } else {
                CashedPainter.drawButton(c, g);
            }
        }
        CashedPainter.drawButtonBorder(c, g, this.getPropertyPrefix());
        super.paint(g, c);
    }

    public Dimension getPreferredSize(JComponent c) {
        if (c.getParent() instanceof JToolBar) {
            return new Dimension((int)super.getPreferredSize(c).getWidth() + 6, (int)super.getPreferredSize(c).getHeight() + 6);
        }
        return new Dimension((int)super.getPreferredSize(c).getWidth() + 10, (int)super.getPreferredSize(c).getHeight() + 6);
    }

    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        CashedPainter.drawButtonBorder(b, g, this.getPropertyPrefix());
    }

    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        this.setTextShiftOffset();
    }
}

