/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.tools;

import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.Tools;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;

public class OperatorListCellRenderer
extends DefaultListCellRenderer {
    private static final long serialVersionUID = -4236587258844548010L;
    private boolean coloredBackground;

    public OperatorListCellRenderer(boolean coloredBackground) {
        this.coloredBackground = coloredBackground;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        OperatorDescription operatorDescription = (OperatorDescription)value;
        Component component = super.getListCellRendererComponent((JList<?>)list, operatorDescription.getName(), index, isSelected, cellHasFocus);
        JLabel label = (JLabel)component;
        try {
            label.setIcon(operatorDescription.getIcon());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.coloredBackground && !isSelected && index % 2 != 0) {
            label.setBackground(SwingTools.LIGHTEST_BLUE);
        }
        label.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        Operator operator = null;
        try {
            operator = operatorDescription.createOperatorInstance();
        }
        catch (OperatorCreationException e) {
            LogService.getGlobal().log("Problem during creation of operator instance: " + e.getMessage(), 5);
        }
        String descriptionString = operatorDescription.getLongDescriptionHTML();
        if (descriptionString == null) {
            descriptionString = operatorDescription.getShortDescription();
        }
        StringBuffer toolTipText = new StringBuffer("<b>Description:</b> " + descriptionString);
        if (operator != null) {
            toolTipText.append(String.valueOf(Tools.getLineSeparator()) + "<b>Input:</b> " + SwingTools.getStringFromClassArray(operator.getInputClasses()));
            toolTipText.append(String.valueOf(Tools.getLineSeparator()) + "<b>Output:</b> " + SwingTools.getStringFromClassArray(operator.getOutputClasses()));
        }
        label.setToolTipText(SwingTools.transformToolTipText(toolTipText.toString()));
        if (operatorDescription.getDeprecationInfo() != null || operator != null && operator.getDeprecationInfo() != null) {
            label.setForeground(Color.LIGHT_GRAY);
        }
        return label;
    }
}

