/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm;

import be.ac.ulg.montefiore.run.jahmm.ObservationDiscrete;
import be.ac.ulg.montefiore.run.jahmm.ObservationInteger;
import be.ac.ulg.montefiore.run.jahmm.Opdf;
import be.ac.ulg.montefiore.run.jahmm.OpdfInteger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpdfDiscrete<E extends Enum<E>>
implements Opdf<ObservationDiscrete<E>> {
    protected OpdfInteger distribution;
    protected final List<E> values;
    protected final EnumMap<E, ObservationInteger> toIntegerMap;
    private static final long serialVersionUID = 1L;

    public OpdfDiscrete(Class<E> valuesClass) {
        this.values = new ArrayList(EnumSet.allOf(valuesClass));
        if (this.values.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.distribution = new OpdfInteger(this.values.size());
        this.toIntegerMap = this.createMap(valuesClass);
    }

    public OpdfDiscrete(Class<E> valuesClass, double[] probabilities) {
        this.values = new ArrayList(EnumSet.allOf(valuesClass));
        if (probabilities.length == 0 || this.values.size() != probabilities.length) {
            throw new IllegalArgumentException();
        }
        this.distribution = new OpdfInteger(probabilities);
        this.toIntegerMap = this.createMap(valuesClass);
    }

    private EnumMap<E, ObservationInteger> createMap(Class<E> valuesClass) {
        EnumMap<E, ObservationInteger> result = new EnumMap<E, ObservationInteger>(valuesClass);
        for (Enum value : this.values) {
            result.put(value, new ObservationInteger(value.ordinal()));
        }
        return result;
    }

    @Override
    public double probability(ObservationDiscrete o) {
        return this.distribution.probability(this.toIntegerMap.get(o.value));
    }

    @Override
    public ObservationDiscrete<E> generate() {
        return new ObservationDiscrete<Enum>((Enum)this.values.get(this.distribution.generate().value));
    }

    public void fit(ObservationDiscrete<E> ... oa) {
        this.fit((Collection)Arrays.asList(oa));
    }

    @Override
    public void fit(Collection<? extends ObservationDiscrete<E>> co) {
        ArrayList<ObservationInteger> dco = new ArrayList<ObservationInteger>();
        for (ObservationDiscrete<E> o : co) {
            dco.add(this.toIntegerMap.get(o.value));
        }
        this.distribution.fit((Collection<? extends ObservationInteger>)dco);
    }

    public void fit(ObservationDiscrete<E>[] o, double[] weights) {
        this.fit((Collection)Arrays.asList(o), weights);
    }

    @Override
    public void fit(Collection<? extends ObservationDiscrete<E>> co, double[] weights) {
        ArrayList<ObservationInteger> dco = new ArrayList<ObservationInteger>();
        for (ObservationDiscrete<E> o : co) {
            dco.add(this.toIntegerMap.get(o.value));
        }
        this.distribution.fit((Collection<? extends ObservationInteger>)dco, weights);
    }

    @Override
    public OpdfDiscrete<E> clone() {
        try {
            OpdfDiscrete opdfDiscrete = (OpdfDiscrete)super.clone();
            opdfDiscrete.distribution = this.distribution.clone();
            return opdfDiscrete;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public String toString() {
        return this.toString(NumberFormat.getInstance());
    }

    @Override
    public String toString(NumberFormat numberFormat) {
        String s = "Discrete distribution --- ";
        int i = 0;
        while (i < this.values.size()) {
            ObservationDiscrete<Enum> o = new ObservationDiscrete<Enum>((Enum)this.values.get(i));
            s = String.valueOf(s) + o + " " + numberFormat.format(this.probability(o)) + (++i < this.values.size() ? ", " : "");
        }
        return s;
    }
}

