<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="xml" indent="yes" encoding="UTF-8"/> 
	<xsl:template match="/">
		<SpeciesMatchingResults>
			<xsl:apply-templates select="//MatchingDetails"/> 
		</SpeciesMatchingResults>
	</xsl:template>

	<xsl:template match="MatchingDetails">
		<MatchingResult>
			<xsl:apply-templates select="Source"/>
			<xsl:apply-templates select="Matchings/Matching"/>
		</MatchingResult>
	</xsl:template>

	<xsl:template match="Source">
		<SourceData>
			<xsl:attribute name="dataSourceId"><xsl:value-of select="dataSource/text()"/></xsl:attribute>
			<xsl:attribute name="id"><xsl:value-of select="id/text()"/></xsl:attribute>
			<Original>
				<xsl:value-of select="originalData/text()"/>
			</Original>
			<Parsed>
				<xsl:attribute name="parser"><xsl:value-of select="Parser"/></xsl:attribute>
				<Name><xsl:value-of select="parsedScientificName/text()"/></Name>
				<Authority><xsl:value-of select="parsedAuthority/text()"/></Authority>
			</Parsed>
		</SourceData>
	</xsl:template>

	<xsl:template match="vernacularCName">
		<VernacularName>
			<Language><xsl:value-of select="substring(type, 12)"/></Language>
			<Name><xsl:value-of select="name"/></Name>
		</VernacularName>
	</xsl:template>

	<xsl:template match="Matching">
		<MatchesWith>
			<xsl:attribute name="score"><xsl:value-of select="format-number(@score, '0.0000000000000000')"/></xsl:attribute>
			<TargetData>
				<xsl:attribute name="dataSourceId"><xsl:value-of select="Target/dataSource"/></xsl:attribute>
				<xsl:attribute name="id"><xsl:value-of select="Target/id"/></xsl:attribute>
				<ScientificName><xsl:value-of select="Target/scientificName"/></ScientificName>
				<Author><xsl:value-of select="Target/author"/></Author>
				<Kingdom><xsl:value-of select="Target/kingdom"/></Kingdom>
				<Phylum><xsl:value-of select="Target/phylum"/></Phylum>
				<Class><xsl:value-of select="Target/class"/></Class>
				<Order><xsl:value-of select="Target/order"/></Order>
				<Family><xsl:value-of select="Target/family"/></Family>
				<Genus><xsl:value-of select="Target/genus"/></Genus>
				<Species><xsl:value-of select="Target/species"/></Species>
				<VernacularNames>
					<xsl:apply-templates select="Target/vernacularCNames/vernacularCName"/>
				</VernacularNames>
			</TargetData>
		</MatchesWith>
	</xsl:template>
</xsl:stylesheet>