<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output method="text" omit-xml-declaration="yes" indent="no"/>
	<xsl:template match="/">
		<xsl:text>PROCESS_TYPE,THROUGHPUT,NUM_INPUTS,MEAN_PER_INPUT_THROUGHPUT,NUM_IDENTIFIED_INPUTS,NUM_CORRECTLY_IDENTIFIED_INPUTS,OVERALL_IDENTIFICATION_RATIO,CORRECT_IDENTIFICATION_RATIO
</xsl:text>	
		<xsl:apply-templates select="//Overall"/> 
	</xsl:template>
	
	<xsl:template match="Overall">
<xsl:value-of select="concat('&quot;', 
							 @processType, 
							 '&quot;,', 
							 format-number(throughput/text(), '##0.000000'),
							 ',', 
							 numInputs/text(),
							 ',', 
							 format-number(meanPerInputThroughput/text(), '##0.000000'),
							 ',',
							 numIdentifiedInputs/text(),
							 ',', 
							 numCorrectlyIdentifiedInputs/text(),
							 ',',
							 format-number(overallIdentificationRatio/text(), '0.000000'),
							 ',',
							 format-number(correctIdentificationRatio/text(), '0.000000'))"/><xsl:text>
</xsl:text></xsl:template>
</xsl:stylesheet>